/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.NodeEventType;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.marshall.MethodCall;

public class EvictionInterceptor
extends Interceptor {
    private static final Log log = LogFactory.getLog(EvictionInterceptor.class);
    protected RegionManager regionManager;
    protected Map<Integer, EvictionMethodHandler> evictionMethodHandlers = new HashMap<Integer, EvictionMethodHandler>();

    public EvictionInterceptor() {
        EvictionMethodHandler handler = new GetNodeEvictionMethodHandler();
        this.evictionMethodHandlers.put(31, handler);
        this.evictionMethodHandlers.put(24, handler);
        handler = new GetKeyEvictionMethodHandler();
        this.evictionMethodHandlers.put(26, handler);
        handler = new RemoveNodeEvictionMethodHandler();
        this.evictionMethodHandlers.put(5, handler);
        this.evictionMethodHandlers.put(7, handler);
        handler = new RemoveKeyEvictionMethodHandler();
        this.evictionMethodHandlers.put(6, handler);
        handler = new PutDataEvictionMethodHandler();
        this.evictionMethodHandlers.put(1, handler);
        handler = new PutDataEraseEvictionMethodHandler();
        this.evictionMethodHandlers.put(2, handler);
        handler = new PutKeyEvictionMethodHandler();
        this.evictionMethodHandlers.put(3, handler);
        this.evictionMethodHandlers.put(45, handler);
        handler = new PartialEvictionEvictionMethodHandler();
        this.evictionMethodHandlers.put(8, handler);
        this.evictionMethodHandlers.put(9, handler);
    }

    void setRegionManager(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.regionManager = cache.getRegionManager();
    }

    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        Object ret = super.invoke(ctx);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Invoking EvictionInterceptor");
        }
        this.updateNode(m, ret);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Finished invoking EvictionInterceptor");
        }
        return ret;
    }

    protected void updateNode(MethodCall m, Object retVal) {
        EvictedEventNode event;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Updating node/element events with no tx");
        }
        if ((event = this.extractEvent(m, retVal)) == null) {
            return;
        }
        this.doEventUpdatesOnRegionManager(event);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Finished updating node");
        }
    }

    protected EvictedEventNode extractEvent(MethodCall m, Object retVal) {
        EvictionMethodHandler handler = this.evictionMethodHandlers.get(m.getMethodId());
        if (handler == null) {
            return null;
        }
        return handler.extractEvictedEventNode(m, retVal);
    }

    protected boolean canIgnoreEvent(Fqn fqn, NodeEventType type) {
        Region r = this.regionManager.getRegion(fqn, Region.Type.EVICTION, false);
        if (r == null) {
            return true;
        }
        return r.getEvictionPolicy().canIgnoreEvent(fqn, type);
    }

    protected void doEventUpdatesOnRegionManager(EvictedEventNode event) {
        Region region = this.regionManager.getRegion(event.getFqn(), false);
        region.putNodeEvent(event);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding event " + event + " to region at " + region.getFqn()));
        }
    }

    protected static interface EvictionMethodHandler {
        public EvictedEventNode extractEvictedEventNode(MethodCall var1, Object var2);
    }

    protected class PartialEvictionEvictionMethodHandler
    implements EvictionMethodHandler {
        protected PartialEvictionEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args;
            Fqn fqn;
            boolean complete;
            boolean bl = complete = retVal != null && (Boolean)retVal != false;
            if (!complete && (fqn = (Fqn)(args = mc.getArgs())[0]) != null && !EvictionInterceptor.this.canIgnoreEvent(fqn, NodeEventType.ADD_NODE_EVENT)) {
                return new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT, 0);
            }
            return null;
        }
    }

    protected class PutKeyEvictionMethodHandler
    implements EvictionMethodHandler {
        protected PutKeyEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            Object key = args[2];
            if (fqn != null && key != null && !EvictionInterceptor.this.canIgnoreEvent(fqn, NodeEventType.ADD_ELEMENT_EVENT)) {
                return new EvictedEventNode(fqn, NodeEventType.ADD_ELEMENT_EVENT, 1);
            }
            return null;
        }
    }

    protected class PutDataEraseEvictionMethodHandler
    implements EvictionMethodHandler {
        protected PutDataEraseEvictionMethodHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            Map putData = (Map)args[2];
            Boolean resetElementCount = (Boolean)args[4];
            if (fqn != null && !EvictionInterceptor.this.canIgnoreEvent(fqn, NodeEventType.ADD_NODE_EVENT)) {
                int size;
                if (putData == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Putting null data under fqn " + fqn + "."));
                    }
                    return null;
                }
                Map map = putData;
                synchronized (map) {
                    size = putData.size();
                }
                EvictedEventNode event = new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT, size);
                event.setResetElementCount(resetElementCount);
                return event;
            }
            return null;
        }
    }

    protected class PutDataEvictionMethodHandler
    implements EvictionMethodHandler {
        protected PutDataEvictionMethodHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            Map putData = (Map)args[2];
            if (fqn != null && !EvictionInterceptor.this.canIgnoreEvent(fqn, NodeEventType.ADD_NODE_EVENT)) {
                int size;
                if (putData == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Putting null data under fqn " + fqn + "."));
                    }
                    return null;
                }
                Map map = putData;
                synchronized (map) {
                    size = putData.size();
                }
                return new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT, size);
            }
            return null;
        }
    }

    protected class RemoveKeyEvictionMethodHandler
    implements EvictionMethodHandler {
        protected RemoveKeyEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            if (retVal == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No event added. Element does not exist");
                }
                return null;
            }
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            Object key = args[2];
            if (fqn != null && key != null && !EvictionInterceptor.this.canIgnoreEvent(fqn, NodeEventType.REMOVE_ELEMENT_EVENT)) {
                return new EvictedEventNode(fqn, NodeEventType.REMOVE_ELEMENT_EVENT, 1);
            }
            return null;
        }
    }

    protected class RemoveNodeEvictionMethodHandler
    implements EvictionMethodHandler {
        protected RemoveNodeEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[1];
            if (fqn != null && !EvictionInterceptor.this.canIgnoreEvent(fqn, NodeEventType.REMOVE_NODE_EVENT)) {
                return new EvictedEventNode(fqn, NodeEventType.REMOVE_NODE_EVENT);
            }
            return null;
        }
    }

    protected class GetKeyEvictionMethodHandler
    implements EvictionMethodHandler {
        protected GetKeyEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            if (retVal == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No event added. Element does not exist");
                }
                return null;
            }
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[0];
            Object key = args[1];
            if (fqn != null && key != null && !EvictionInterceptor.this.canIgnoreEvent(fqn, NodeEventType.VISIT_NODE_EVENT)) {
                return new EvictedEventNode(fqn, NodeEventType.VISIT_NODE_EVENT);
            }
            return null;
        }
    }

    protected class GetNodeEvictionMethodHandler
    implements EvictionMethodHandler {
        protected GetNodeEvictionMethodHandler() {
        }

        public EvictedEventNode extractEvictedEventNode(MethodCall mc, Object retVal) {
            if (retVal == null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No event added. Node does not exist");
                }
                return null;
            }
            Object[] args = mc.getArgs();
            Fqn fqn = (Fqn)args[0];
            if (fqn != null && !EvictionInterceptor.this.canIgnoreEvent(fqn, NodeEventType.VISIT_NODE_EVENT) && fqn != null && !EvictionInterceptor.this.canIgnoreEvent(fqn, NodeEventType.VISIT_NODE_EVENT)) {
                return new EvictedEventNode(fqn, NodeEventType.VISIT_NODE_EVENT);
            }
            return null;
        }
    }
}

