/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Region;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.LRUQueue;
import org.jboss.cache.eviction.NodeEntry;

public class LRUAlgorithm
extends BaseEvictionAlgorithm
implements EvictionAlgorithm {
    private static final Log log = LogFactory.getLog(LRUAlgorithm.class);

    protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
        return new LRUQueue();
    }

    protected boolean shouldEvictNode(NodeEntry entry) {
        LRUConfiguration config = (LRUConfiguration)this.region.getEvictionPolicyConfig();
        if (config.getTimeToLiveSeconds() == 0 && config.getMaxAgeSeconds() == 0) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (config.getTimeToLiveSeconds() != 0) {
            long idleTime = currentTime - entry.getModifiedTimeStamp();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Node " + entry.getFqn() + " has been idle for " + idleTime + "ms"));
            }
            if (idleTime >= (long)(config.getTimeToLiveSeconds() * 1000)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Node " + entry.getFqn() + " should be evicted because of idle time"));
                }
                return true;
            }
        }
        if (config.getMaxAgeSeconds() != 0) {
            long objectLifeTime = currentTime - entry.getCreationTimeStamp();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Node " + entry.getFqn() + " has been alive for " + objectLifeTime + "ms"));
            }
            if (objectLifeTime >= (long)(config.getMaxAgeSeconds() * 1000)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Node " + entry.getFqn() + " should be evicted because of max age"));
                }
                return true;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Node " + entry.getFqn() + " should not be evicted"));
        }
        return false;
    }

    protected void evict(NodeEntry ne) {
        if (ne != null && !this.evictCacheNode(ne.getFqn())) {
            try {
                this.recycleQueue.put(ne.getFqn());
            }
            catch (InterruptedException e) {
                log.debug((Object)"InterruptedException", (Throwable)e);
            }
        }
    }

    protected void prune() throws EvictionException {
        int maxNodes;
        NodeEntry ne;
        LRUQueue lruQueue = (LRUQueue)this.evictionQueue;
        Iterator<NodeEntry> it = lruQueue.iterateLRUQueue();
        while (it.hasNext()) {
            ne = it.next();
            if (this.isNodeInUseAndNotTimedOut(ne)) continue;
            if (!this.shouldEvictNode(ne)) break;
            it.remove();
            lruQueue.removeNodeEntryFromMaxAge(ne);
            this.evict(ne);
        }
        it = lruQueue.iterateMaxAgeQueue();
        while (it.hasNext()) {
            ne = it.next();
            if (this.isNodeInUseAndNotTimedOut(ne)) continue;
            if (!this.shouldEvictNode(ne)) break;
            it.remove();
            lruQueue.removeNodeEntryFromLRU(ne);
            this.evict(ne);
        }
        if ((maxNodes = this.getConfiguration().getMaxNodes()) <= 0) {
            return;
        }
        it = lruQueue.iterateLRUQueue();
        while (this.evictionQueue.getNumberOfNodes() > maxNodes) {
            ne = it.next();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Node " + ne.getFqn() + " will be evicted because of exceeding the maxNode limit." + " maxNode: " + maxNodes + " but current queue size is: " + this.evictionQueue.getNumberOfNodes()));
            }
            if (this.isNodeInUseAndNotTimedOut(ne)) continue;
            it.remove();
            lruQueue.removeNodeEntryFromMaxAge(ne);
            this.evict(ne);
        }
    }

    protected LRUConfiguration getConfiguration() {
        return (LRUConfiguration)this.region.getEvictionPolicyConfig();
    }
}

