/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import org.jboss.cache.optimistic.DataVersion;

public class Option
implements Cloneable {
    private boolean failSilently;
    private boolean cacheModeLocal;
    private DataVersion dataVersion;
    private boolean suppressLocking;
    private boolean forceDataGravitation;
    private boolean skipDataGravitation;
    private boolean forceWriteLock;
    private boolean skipCacheStatusCheck;

    public boolean isSuppressLocking() {
        return this.suppressLocking;
    }

    public void setSuppressLocking(boolean suppressLocking) {
        this.suppressLocking = suppressLocking;
    }

    public boolean isFailSilently() {
        return this.failSilently;
    }

    public void setFailSilently(boolean failSilently) {
        this.failSilently = failSilently;
    }

    public boolean isCacheModeLocal() {
        return this.cacheModeLocal;
    }

    public void setCacheModeLocal(boolean cacheModeLocal) {
        this.cacheModeLocal = cacheModeLocal;
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public boolean getForceDataGravitation() {
        return this.forceDataGravitation;
    }

    public void setForceDataGravitation(boolean enableDataGravitation) {
        this.forceDataGravitation = enableDataGravitation;
    }

    public boolean isSkipDataGravitation() {
        return this.skipDataGravitation;
    }

    public void setSkipDataGravitation(boolean skipDataGravitation) {
        this.skipDataGravitation = skipDataGravitation;
    }

    public String toString() {
        return "Option{failSilently=" + this.failSilently + ", cacheModeLocal=" + this.cacheModeLocal + ", dataVersion=" + this.dataVersion + ", suppressLocking=" + this.suppressLocking + ", forceDataGravitation=" + this.forceDataGravitation + ", skipDataGravitation=" + this.skipDataGravitation + '}';
    }

    public Option clone() throws CloneNotSupportedException {
        return (Option)super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        if (this.skipDataGravitation != option.skipDataGravitation) {
            return false;
        }
        if (this.cacheModeLocal != option.cacheModeLocal) {
            return false;
        }
        if (this.failSilently != option.failSilently) {
            return false;
        }
        if (this.forceDataGravitation != option.forceDataGravitation) {
            return false;
        }
        if (this.suppressLocking != option.suppressLocking) {
            return false;
        }
        if (this.dataVersion != null ? !this.dataVersion.equals(option.dataVersion) : option.dataVersion != null) {
            return false;
        }
        return this.forceWriteLock == option.forceWriteLock;
    }

    public int hashCode() {
        int result = this.failSilently ? 1 : 0;
        result = 29 * result + (this.cacheModeLocal ? 1 : 0);
        result = 29 * result + (this.dataVersion != null ? this.dataVersion.hashCode() : 0);
        result = 29 * result + (this.suppressLocking ? 1 : 0);
        result = 29 * result + (this.forceDataGravitation ? 1 : 0);
        result = 29 * result + (this.skipDataGravitation ? 1 : 0);
        result = 29 * result + (this.forceWriteLock ? 0 : 1);
        return result;
    }

    public void reset() {
        this.skipDataGravitation = false;
        this.cacheModeLocal = false;
        this.failSilently = false;
        this.forceDataGravitation = false;
        this.suppressLocking = false;
        this.dataVersion = null;
        this.forceWriteLock = false;
    }

    public void setForceWriteLock(boolean forceWriteLock) {
        this.forceWriteLock = forceWriteLock;
    }

    public boolean isForceWriteLock() {
        return this.forceWriteLock;
    }

    public void setSkipCacheStatusCheck(boolean skipCacheStatusCheck) {
        this.skipCacheStatusCheck = skipCacheStatusCheck;
    }

    public boolean isSkipCacheStatusCheck() {
        return this.skipCacheStatusCheck;
    }
}

