/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.buddyreplication.BuddyLocator;
import org.jboss.cache.buddyreplication.BuddyNotInitException;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodCallFactory;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.cache.statetransfer.StateTransferManager;
import org.jboss.cache.util.ExposedByteArrayOutputStream;
import org.jboss.cache.util.concurrent.ConcurrentHashSet;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.View;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyManager {
    private static Log log = LogFactory.getLog(BuddyManager.class);
    final BuddyReplicationConfig config;
    BuddyLocator buddyLocator;
    private CacheImpl cache;
    BuddyGroup buddyGroup;
    final Map<Address, String> buddyPool = new ConcurrentHashMap<Address, String>();
    final Set<Address> nullBuddyPool = new ConcurrentHashSet<Address>();
    Map<String, BuddyGroup> buddyGroupsIParticipateIn = new ConcurrentHashMap<String, BuddyGroup>();
    private final BlockingQueue<MembershipChange> queue = new LinkedBlockingQueue<MembershipChange>();
    private AsyncViewChangeHandlerThread asyncViewChangeHandler = new AsyncViewChangeHandlerThread();
    public static final String BUDDY_BACKUP_SUBTREE = "_BUDDY_BACKUP_";
    public static final Fqn BUDDY_BACKUP_SUBTREE_FQN = Fqn.fromString("_BUDDY_BACKUP_");
    private static int UNINIT_BUDDIES_RETRIES = 5;
    private static final long[] UNINIT_BUDDIES_RETRY_NAPTIME = new long[]{500L, 1000L, 1500L, 2000L, 2500L};
    private final Object poolInfoNotifierLock = new Object();
    private CountDownLatch initialisationLatch = new CountDownLatch(1);
    private static final MembershipChange STOP_NOTIFIER = new MembershipChange(null, null);
    private ViewChangeListener viewChangeListener;

    public BuddyManager(BuddyReplicationConfig config) {
        this.config = config;
        BuddyReplicationConfig.BuddyLocatorConfig blc = config.getBuddyLocatorConfig();
        try {
            this.buddyLocator = blc == null ? this.createDefaultBuddyLocator() : this.createBuddyLocator(blc);
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception instantiating buddy locator", (Throwable)e);
            log.error((Object)("Unable to instantiate specified buddyLocatorClass [" + blc + "].  Using default buddyLocator [" + NextMemberBuddyLocator.class.getName() + "] instead, with default properties."));
            this.buddyLocator = this.createDefaultBuddyLocator();
        }
        if (blc != this.buddyLocator.getConfig()) {
            config.setBuddyLocatorConfig(this.buddyLocator.getConfig());
        }
    }

    public BuddyReplicationConfig getConfig() {
        return this.config;
    }

    protected BuddyLocator createBuddyLocator(BuddyReplicationConfig.BuddyLocatorConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        BuddyLocator bl = (BuddyLocator)Class.forName(config.getBuddyLocatorClass()).newInstance();
        bl.init(config);
        return bl;
    }

    protected BuddyLocator createDefaultBuddyLocator() {
        NextMemberBuddyLocator bl = new NextMemberBuddyLocator();
        bl.init(null);
        return bl;
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public String getBuddyPoolName() {
        return this.config.getBuddyPoolName();
    }

    public static String getGroupNameFromAddress(Object address) {
        String s = address.toString();
        return s.replace(':', '_');
    }

    public void stop() {
        if (this.cache != null) {
            this.cache.removeCacheListener(this.viewChangeListener);
        }
        try {
            this.queue.clear();
            this.queue.put(STOP_NOTIFIER);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void init(CacheImpl cache) throws CacheException {
        log.debug((Object)"Starting buddy manager");
        this.cache = cache;
        this.buddyGroup = new BuddyGroup();
        this.buddyGroup.setDataOwner(cache.getLocalAddress());
        this.buddyGroup.setGroupName(BuddyManager.getGroupNameFromAddress(cache.getLocalAddress()));
        if (this.config.getBuddyPoolName() != null) {
            this.buddyPool.put(this.buddyGroup.getDataOwner(), this.config.getBuddyPoolName());
        }
        this.broadcastBuddyPoolMembership();
        this.initialisationLatch.countDown();
        this.viewChangeListener = new ViewChangeListener();
        cache.addCacheListener(this.viewChangeListener);
        this.reassignBuddies(cache.getMembers());
        this.asyncViewChangeHandler.start();
    }

    public boolean isAutoDataGravitation() {
        return this.config.isAutoDataGravitation();
    }

    public boolean isDataGravitationRemoveOnFind() {
        return this.config.isDataGravitationRemoveOnFind();
    }

    public boolean isDataGravitationSearchBackupTrees() {
        return this.config.isDataGravitationSearchBackupTrees();
    }

    public int getBuddyCommunicationTimeout() {
        return this.config.getBuddyCommunicationTimeout();
    }

    private synchronized void enqueueViewChange(List<Address> oldMembers, List<Address> newMembers) {
        try {
            if (this.queue.peek() != STOP_NOTIFIER) {
                this.queue.clear();
                MembershipChange mc = new MembershipChange(oldMembers, newMembers);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Enqueueing " + mc + " for async processing"));
                }
                this.queue.put(mc);
            }
        }
        catch (InterruptedException e) {
            log.warn((Object)"Caught interrupted exception trying to enqueue a view change event", (Throwable)e);
        }
    }

    private void reassignBuddies(List<Address> members) throws CacheException {
        List<Address> newBuddies;
        List<Address> unreachableBuddies;
        ArrayList<Address> membership = new ArrayList<Address>(members);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Data owner address " + this.cache.getLocalAddress()));
            log.debug((Object)("Entering updateGroup.  Current group: " + this.buddyGroup + ".  Current View membership: " + membership));
        }
        if (!(unreachableBuddies = this.checkBuddyStatus(newBuddies = this.buddyLocator.locateBuddies(this.buddyPool, membership, this.buddyGroup.getDataOwner()))).isEmpty()) {
            membership.removeAll(unreachableBuddies);
            newBuddies = this.buddyLocator.locateBuddies(this.buddyPool, membership, this.buddyGroup.getDataOwner());
        }
        ArrayList<Address> uninitialisedBuddies = new ArrayList<Address>();
        List<Address> originalBuddies = this.buddyGroup.getBuddies();
        for (Address newBuddy : newBuddies) {
            if (originalBuddies.contains(newBuddy)) continue;
            uninitialisedBuddies.add(newBuddy);
        }
        ArrayList<Address> obsoleteBuddies = new ArrayList<Address>();
        for (Address origBuddy : originalBuddies) {
            if (newBuddies.contains(origBuddy)) continue;
            obsoleteBuddies.add(origBuddy);
        }
        boolean buddyGroupMutated = false;
        if (!obsoleteBuddies.isEmpty()) {
            this.removeFromGroup(obsoleteBuddies);
            buddyGroupMutated = true;
        } else {
            log.trace((Object)"No obsolete buddies found, nothing to announce.");
        }
        if (!uninitialisedBuddies.isEmpty()) {
            this.addBuddies(newBuddies);
            buddyGroupMutated = true;
        } else {
            log.trace((Object)"No uninitialized buddies found, nothing to announce.");
        }
        if (buddyGroupMutated) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Buddy group members have changed. New buddy group: " + this.buddyGroup));
            }
            this.cache.getConfiguration().getRuntimeConfig().setBuddyGroup(this.buddyGroup);
        } else {
            log.debug((Object)"Nothing has changed; new buddy list is identical to the old one.");
        }
    }

    private List<Address> checkBuddyStatus(List<Address> members) {
        Channel ch = this.cache.getConfiguration().getRuntimeConfig().getChannel();
        View currentView = ch.getView();
        LinkedList<Address> deadBuddies = new LinkedList<Address>();
        for (Address a : members) {
            if (currentView.containsMember(a)) continue;
            deadBuddies.add(a);
        }
        return deadBuddies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePoolNameBroadcast(Address address, String poolName) {
        Object object;
        if (log.isDebugEnabled()) {
            log.debug((Object)("BuddyManager@" + Integer.toHexString(this.hashCode()) + ": received announcement that cache instance " + address + " is in buddy pool " + poolName));
        }
        if (poolName != null) {
            this.buddyPool.put(address, poolName);
        } else {
            object = this.nullBuddyPool;
            synchronized (object) {
                if (!this.nullBuddyPool.contains(address)) {
                    this.nullBuddyPool.add(address);
                }
            }
        }
        object = this.poolInfoNotifierLock;
        synchronized (object) {
            log.trace((Object)"Notifying any waiting view change threads that we have received buddy pool info.");
            this.poolInfoNotifierLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoveFromBuddyGroup(String groupName) throws BuddyNotInitException {
        try {
            if (!this.initialisationLatch.await(0L, TimeUnit.NANOSECONDS)) {
                throw new BuddyNotInitException("Not yet initialised");
            }
        }
        catch (InterruptedException e) {
            log.debug((Object)"Caught InterruptedException", (Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing self from buddy group " + groupName));
        }
        this.buddyGroupsIParticipateIn.remove(groupName);
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing backup data for group " + groupName));
        }
        try {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.cache.remove(new Fqn<Object>(BUDDY_BACKUP_SUBTREE_FQN, new Object[]{groupName}));
        }
        catch (CacheException e) {
            log.error((Object)("Unable to remove backup data for group " + groupName), (Throwable)e);
        }
        finally {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAssignToBuddyGroup(BuddyGroup newGroup, Map<Fqn, byte[]> state) throws Exception {
        try {
            if (!this.initialisationLatch.await(0L, TimeUnit.NANOSECONDS)) {
                throw new BuddyNotInitException("Not yet initialised");
            }
        }
        catch (InterruptedException e) {
            log.debug((Object)"Caught InterruptedException", (Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Assigning self to buddy group " + newGroup));
        }
        this.buddyGroupsIParticipateIn.put(newGroup.getGroupName(), newGroup);
        Fqn<Object> integrationBase = new Fqn<Object>(BUDDY_BACKUP_SUBTREE_FQN, new Object[]{newGroup.getGroupName()});
        StateTransferManager stateMgr = this.cache.getStateTransferManager();
        for (Map.Entry<Fqn, byte[]> entry : state.entrySet()) {
            Fqn fqn = entry.getKey();
            if (this.cache.getRegionManager().isInactive(fqn)) continue;
            Fqn<Object> integrationRoot = new Fqn<Object>(integrationBase, fqn);
            byte[] stateBuffer = entry.getValue();
            MarshalledValueInputStream in = null;
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(stateBuffer);
                in = new MarshalledValueInputStream((InputStream)bais);
                stateMgr.setState((ObjectInputStream)in, integrationRoot);
            }
            catch (Throwable t) {
                if (t instanceof CacheException) {
                    log.debug((Object)t);
                    continue;
                }
                log.error((Object)("State for fqn " + fqn + " could not be transferred to a buddy at " + this.cache.getLocalAddress()), t);
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    public static Fqn getBackupFqn(Address dataOwnerAddress, Fqn origFqn) {
        return BuddyManager.getBackupFqn(BuddyManager.getGroupNameFromAddress(dataOwnerAddress), origFqn);
    }

    public static Fqn getBackupFqn(String buddyGroupName, Fqn origFqn) {
        if (BuddyManager.isBackupFqn(origFqn)) {
            throw new CacheException("Cannot make a backup Fqn from a backup Fqn! Attempting to create a backup of " + origFqn);
        }
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(BUDDY_BACKUP_SUBTREE);
        elements.add(buddyGroupName);
        elements.addAll(origFqn.peekElements());
        return new Fqn(elements);
    }

    public static Fqn getBackupFqn(Fqn buddyGroupRoot, Fqn origFqn) {
        if (origFqn.isChildOf(buddyGroupRoot)) {
            return origFqn;
        }
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(BUDDY_BACKUP_SUBTREE);
        elements.add((String)buddyGroupRoot.get(1));
        elements.addAll(origFqn.peekElements());
        return new Fqn(elements);
    }

    public static boolean isBackupFqn(Fqn name) {
        return name != null && name.hasElement(BUDDY_BACKUP_SUBTREE);
    }

    public List<Address> getBuddyAddresses() {
        return this.buddyGroup.getBuddies();
    }

    public MethodCall transformFqns(MethodCall call) {
        return this.transformFqns(call, call.getMethodId() != 34);
    }

    public MethodCall transformFqns(MethodCall call, boolean transformForCurrentCall) {
        if (call != null && call.getArgs() != null) {
            MethodCall call2 = MethodCallFactory.create(call.getMethod(), (Object[])call.getArgs().clone());
            this.handleArgs(call2.getArgs(), transformForCurrentCall);
            return call2;
        }
        return call;
    }

    private void removeFromGroup(List<Address> buddies) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing obsolete buddies from buddy group [" + this.buddyGroup.getGroupName() + "].  Obsolete buddies are " + buddies));
        }
        this.buddyGroup.removeBuddies(buddies);
        MethodCall membershipCall = MethodCallFactory.create(MethodDeclarations.remoteRemoveFromBuddyGroupMethod, this.buddyGroup.getGroupName());
        MethodCall replicateCall = MethodCallFactory.create(MethodDeclarations.replicateMethod, new Object[]{membershipCall});
        int attemptsLeft = UNINIT_BUDDIES_RETRIES;
        int currentAttempt = 0;
        while (attemptsLeft-- > 0) {
            try {
                this.makeRemoteCall(buddies, replicateCall, true);
                break;
            }
            catch (Exception e) {
                if (e instanceof BuddyNotInitException || e.getCause() instanceof BuddyNotInitException) {
                    if (attemptsLeft > 0) {
                        log.info((Object)"One of the buddies have not been initialised.  Will retry after a short nap.");
                        try {
                            Thread.sleep(UNINIT_BUDDIES_RETRY_NAPTIME[currentAttempt++]);
                        }
                        catch (InterruptedException e1) {
                            log.trace((Object)"Thread interrupted while sleeping/waiting for a retry", (Throwable)e1);
                        }
                        continue;
                    }
                    throw new BuddyNotInitException("Unable to contact buddy after " + UNINIT_BUDDIES_RETRIES + " retries");
                }
                log.error((Object)"Unable to communicate with Buddy for some reason", (Throwable)e);
            }
        }
        log.trace((Object)"removeFromGroup notification complete");
    }

    private void addBuddies(List<Address> buddies) throws CacheException {
        byte[] state;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Assigning new buddies to buddy group [" + this.buddyGroup.getGroupName() + "].  New buddies are " + buddies));
        }
        this.buddyGroup.addBuddies(buddies);
        HashMap<Fqn, byte[]> stateMap = new HashMap<Fqn, byte[]>();
        if (this.cache.getConfiguration().isUseRegionBasedMarshalling()) {
            List<Region> regions = this.cache.getRegionManager().getAllRegions(Region.Type.MARSHALLING);
            if (regions.size() > 0) {
                for (Region r : regions) {
                    Fqn f = r.getFqn();
                    state = this.acquireState(f);
                    if (state == null) continue;
                    stateMap.put(f, state);
                }
            } else if (!this.cache.getConfiguration().isInactiveOnStartup() && (state = this.acquireState(Fqn.ROOT)) != null) {
                stateMap.put(Fqn.ROOT, state);
            }
        } else {
            state = this.acquireState(Fqn.ROOT);
            if (state != null) {
                stateMap.put(Fqn.ROOT, state);
            }
        }
        MethodCall membershipCall = MethodCallFactory.create(MethodDeclarations.remoteAssignToBuddyGroupMethod, this.buddyGroup, stateMap);
        MethodCall replicateCall = MethodCallFactory.create(MethodDeclarations.replicateMethod, new Object[]{membershipCall});
        int attemptsLeft = UNINIT_BUDDIES_RETRIES;
        int currentAttempt = 0;
        while (attemptsLeft-- > 0) {
            try {
                this.makeRemoteCall(buddies, replicateCall, true);
                break;
            }
            catch (Exception e) {
                if (e instanceof BuddyNotInitException || e.getCause() instanceof BuddyNotInitException) {
                    if (attemptsLeft > 0) {
                        log.info((Object)"One of the buddies have not been initialised.  Will retry after a short nap.");
                        try {
                            Thread.sleep(UNINIT_BUDDIES_RETRY_NAPTIME[currentAttempt++]);
                        }
                        catch (InterruptedException e1) {
                            log.trace((Object)"Thread interrupted while sleeping/waiting for a retry", (Throwable)e1);
                        }
                        continue;
                    }
                    throw new BuddyNotInitException("Unable to contact buddy after " + UNINIT_BUDDIES_RETRIES + " retries");
                }
                log.error((Object)"Unable to communicate with Buddy for some reason", (Throwable)e);
            }
        }
        log.trace((Object)"addToGroup notification complete");
    }

    private byte[] acquireState(Fqn fqn) throws CacheException {
        long[] timeouts = new long[]{400L, 800L, 1600L};
        TimeoutException timeoutException = null;
        boolean trace = log.isTraceEnabled();
        for (int i = 0; i < timeouts.length; ++i) {
            timeoutException = null;
            boolean force = i == timeouts.length - 1;
            try {
                byte[] state = this.generateState(fqn, timeouts[i], force, false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"acquireState(): got state");
                }
                return state;
            }
            catch (TimeoutException t) {
                timeoutException = t;
                if (!trace) continue;
                log.trace((Object)"acquireState(): got a TimeoutException");
                continue;
            }
            catch (Exception e) {
                throw new CacheException("Error acquiring state", e);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (timeoutException != null) {
            throw new CacheException("acquireState(): Failed getting state due to timeout", timeoutException);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"acquireState(): Unable to give state");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateState(Fqn fqn, long timeout, boolean force, boolean suppressErrors) throws Throwable {
        MarshalledValueOutputStream out = null;
        byte[] result = null;
        try {
            ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(16384);
            out = new MarshalledValueOutputStream((OutputStream)baos);
            this.cache.getStateTransferManager().getState((ObjectOutputStream)out, fqn, timeout, force, suppressErrors);
            result = baos.getRawBuffer();
        }
        catch (Throwable throwable) {
            Util.close(out);
            throw throwable;
        }
        Util.close((OutputStream)out);
        return result;
    }

    private void broadcastBuddyPoolMembership() {
        this.broadcastBuddyPoolMembership(null);
    }

    private void broadcastBuddyPoolMembership(List<Address> recipients) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instance " + this.buddyGroup.getDataOwner() + " broadcasting membership in buddy pool " + this.config.getBuddyPoolName() + " to recipients " + recipients));
        }
        MethodCall membershipCall = MethodCallFactory.create(MethodDeclarations.remoteAnnounceBuddyPoolNameMethod, this.buddyGroup.getDataOwner(), this.config.getBuddyPoolName());
        MethodCall replicateCall = MethodCallFactory.create(MethodDeclarations.replicateMethod, new Object[]{membershipCall});
        try {
            this.makeRemoteCall(recipients, replicateCall, true);
        }
        catch (Exception e) {
            log.error((Object)"Problems broadcasting buddy pool membership info to cluster", (Throwable)e);
        }
    }

    private void makeRemoteCall(List<Address> recipients, MethodCall call, boolean sync) throws Exception {
        if (recipients != null) {
            Iterator<Address> recipientsIt = recipients.iterator();
            List<Address> members = this.cache.getMembers();
            while (recipientsIt.hasNext()) {
                if (members.contains(recipientsIt.next())) continue;
                recipientsIt.remove();
            }
        }
        this.cache.getRPCManager().callRemoteMethods(recipients, call, sync, true, this.config.getBuddyCommunicationTimeout());
    }

    private void handleArgs(Object[] args, boolean transformForCurrentCall) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof MethodCall) {
                MethodCall call = (MethodCall)((Object)args[i]);
                boolean transformFqns = true;
                if (call.getMethodId() == 34) {
                    transformFqns = false;
                }
                args[i] = this.transformFqns((MethodCall)((Object)args[i]), transformFqns);
            }
            if (args[i] instanceof List && args[i] != null) {
                Object[] asArray = ((List)args[i]).toArray();
                this.handleArgs(asArray, transformForCurrentCall);
                ArrayList<Object> newList = new ArrayList<Object>(asArray.length);
                newList.addAll(Arrays.asList(asArray));
                args[i] = newList;
            }
            if (!(args[i] instanceof Fqn)) continue;
            Fqn fqn = (Fqn)args[i];
            if (!transformForCurrentCall) continue;
            args[i] = this.getBackupFqn(fqn);
        }
    }

    public Fqn getBackupFqn(Fqn originalFqn) {
        return BuddyManager.getBackupFqn(this.buddyGroup == null || this.buddyGroup.getGroupName() == null ? "null" : this.buddyGroup.getGroupName(), originalFqn);
    }

    public static Fqn getActualFqn(Fqn fqn) {
        if (!BuddyManager.isBackupFqn(fqn)) {
            return fqn;
        }
        return fqn.getSubFqn(2, fqn.size());
    }

    @CacheListener
    public class ViewChangeListener {
        private Vector<Address> oldMembers;

        @ViewChanged
        public void handleViewChange(ViewChangedEvent event) {
            View newView = event.getNewView();
            if (log.isTraceEnabled()) {
                log.trace((Object)("BuddyManager CacheListener - got view change with new view " + newView));
            }
            Vector newMembers = newView.getMembers();
            if (BuddyManager.this.config.getBuddyPoolName() == null) {
                BuddyManager.this.enqueueViewChange(null, newMembers);
            } else {
                BuddyManager.this.enqueueViewChange(this.oldMembers == null ? null : new Vector<Address>(this.oldMembers), new Vector(newMembers));
                if (this.oldMembers == null) {
                    this.oldMembers = new Vector();
                }
                this.oldMembers.clear();
                this.oldMembers.addAll(newMembers);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncViewChangeHandlerThread
    implements Runnable {
        private Thread t;
        private boolean isRunning = true;

        private AsyncViewChangeHandlerThread() {
        }

        public void start() {
            if (this.t == null || !this.t.isAlive()) {
                this.t = new Thread(this);
                this.t.setName("AsyncViewChangeHandlerThread," + BuddyManager.this.cache.getLocalAddress());
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        @Override
        public void run() {
            try {
                BuddyManager.this.initialisationLatch.await();
            }
            catch (InterruptedException e) {
                log.debug((Object)"Caught InterruptedException", (Throwable)e);
            }
            while (!Thread.interrupted() && this.isRunning) {
                try {
                    this.handleEnqueuedViewChange();
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (Throwable t) {
                    log.error((Object)"Caught exception handling view change", t);
                }
            }
            log.trace((Object)"Exiting run()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleEnqueuedViewChange() throws Exception {
            log.trace((Object)"Waiting for enqueued view change events");
            MembershipChange members = (MembershipChange)BuddyManager.this.queue.take();
            if (members == STOP_NOTIFIER) {
                this.isRunning = false;
                return;
            }
            if (members.newMembers.size() == 1 && members.newMembers.get(0).equals(BuddyManager.this.cache.getLocalAddress())) {
                log.info((Object)"Ignoring membership change event since it only contains self.");
                return;
            }
            this.broadcastPoolMembership(members);
            boolean rebroadcast = false;
            while (!this.buddyPoolInfoAvailable(members.newMembers)) {
                rebroadcast = true;
                Object object = BuddyManager.this.poolInfoNotifierLock;
                synchronized (object) {
                    log.trace((Object)"Not received necessary buddy pool info for all new members yet; waiting on poolInfoNotifierLock.");
                    BuddyManager.this.poolInfoNotifierLock.wait();
                }
            }
            if (rebroadcast) {
                this.broadcastPoolMembership(members);
            }
            BuddyManager.this.reassignBuddies(members.newMembers);
        }

        private void broadcastPoolMembership(MembershipChange members) {
            log.trace((Object)"Broadcasting pool membership details, triggered by view change.");
            if (members.oldMembers == null) {
                BuddyManager.this.broadcastBuddyPoolMembership();
            } else {
                ArrayList<Address> delta = new ArrayList<Address>();
                delta.addAll(members.newMembers);
                delta.removeAll(members.oldMembers);
                BuddyManager.this.broadcastBuddyPoolMembership(delta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean buddyPoolInfoAvailable(List<Address> newMembers) {
            boolean infoReceived = true;
            for (Address address : newMembers) {
                Set<Address> set = BuddyManager.this.nullBuddyPool;
                synchronized (set) {
                    infoReceived = infoReceived && (address.equals(BuddyManager.this.cache.getLocalAddress()) || BuddyManager.this.buddyPool.keySet().contains(address) || BuddyManager.this.nullBuddyPool.contains(address));
                }
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(BuddyManager.this.buddyGroup.getDataOwner() + " received buddy pool info for new members " + newMembers + "?  " + infoReceived));
            }
            return infoReceived;
        }

        public void stop() {
            if (this.t != null) {
                this.t.interrupt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MembershipChange {
        List<Address> oldMembers;
        List<Address> newMembers;

        public MembershipChange(List<Address> oldMembers, List<Address> newMembers) {
            this.oldMembers = oldMembers;
            this.newMembers = newMembers;
        }

        public String toString() {
            return "MembershipChange: Old members = " + this.oldMembers + " New members = " + this.newMembers;
        }
    }
}

