/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.InterceptorMBean;
import org.jboss.cache.marshall.JBCMethodCall;
import org.jgroups.blocks.MethodCall;

public abstract class Interceptor
implements InterceptorMBean {
    Interceptor next = null;
    TreeCache cache = null;
    Log log = LogFactory.getLog(this.getClass());
    boolean statsEnabled = true;

    public void setNext(Interceptor i) {
        this.next = i;
    }

    public Interceptor getNext() {
        return this.next;
    }

    public void setCache(TreeCache cache) {
        this.cache = cache;
    }

    public Object invoke(MethodCall m) throws Throwable {
        return this.next.invoke(m);
    }

    public boolean getStatisticsEnabled() {
        return this.statsEnabled;
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.statsEnabled = enabled;
    }

    public Map dumpStatistics() {
        return new HashMap();
    }

    public void resetStatistics() {
    }

    protected boolean isActive(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 0;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    protected boolean isPreparing(Transaction tx) {
        if (tx == null) {
            return false;
        }
        int status = -1;
        try {
            status = tx.getStatus();
            return status == 7;
        }
        catch (SystemException e) {
            this.log.error((Object)"failed getting transaction status", (Throwable)e);
            return false;
        }
    }

    protected boolean isValid(Transaction tx) {
        return this.isActive(tx) || this.isPreparing(tx);
    }

    public void setInvocationContext(InvocationContext invocationContext) {
        this.cache.setInvocationContext(invocationContext);
    }

    public InvocationContext getInvocationContext() {
        return this.cache.getInvocationContext();
    }

    protected boolean isOnePhaseCommitPrepareMehod(JBCMethodCall m) {
        switch (m.getMethodId()) {
            case 10: {
                return (Boolean)m.getArgs()[3];
            }
            case 18: {
                return (Boolean)m.getArgs()[4];
            }
        }
        return false;
    }

    protected boolean isTransactionLifecycleMethod(JBCMethodCall mc) {
        int id = mc.getMethodId();
        return id == 11 || id == 12 || id == 10 || id == 18;
    }

    protected boolean isBuddyGroupOrganisationMethod(JBCMethodCall mc) {
        int id = mc.getMethodId();
        return id == 28 || id == 29 || id == 30;
    }
}

