/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericEntity<T> {
    final Class<?> rawType;
    final Type type;
    final T entity;

    protected GenericEntity(T entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity must not be null");
        }
        this.entity = entity;
        this.type = GenericEntity.getSuperclassTypeParameter(this.getClass());
        this.rawType = entity.getClass();
    }

    private static Type getSuperclassTypeParameter(Class<?> subclass) {
        Type superclass = subclass.getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        return parameterized.getActualTypeArguments()[0];
    }

    public final Class<?> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    public final T getEntity() {
        return this.entity;
    }
}

