/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.text.ParseException;
import javax.ws.rs.core.ApiMessages;
import javax.ws.rs.ext.HeaderProvider;
import javax.ws.rs.ext.ProviderFactory;

public class EntityTag {
    private String value;
    private boolean weak;
    private static final HeaderProvider<EntityTag> tagProvider = ProviderFactory.getInstance().createHeaderProvider(EntityTag.class);

    public EntityTag(String value) {
        this.value = value;
        this.weak = false;
    }

    public EntityTag(String value, boolean weak) {
        this.value = value;
        this.weak = weak;
    }

    public static EntityTag parse(String value) throws IllegalArgumentException {
        try {
            return tagProvider.fromString(value);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ApiMessages.ETAG_INVALID(value), ex);
        }
    }

    public boolean isWeak() {
        return this.weak;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityTag)) {
            return super.equals(obj);
        }
        EntityTag other = (EntityTag)obj;
        return this.value.equals(other.getValue()) && this.weak == other.isWeak();
    }

    public String toString() {
        return tagProvider.toString(this);
    }
}

