/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.ApiMessages;
import javax.ws.rs.ext.HeaderProvider;
import javax.ws.rs.ext.ProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaType {
    private String type;
    private String subtype;
    private Map<String, String> parameters;
    private static final HeaderProvider<MediaType> mediaTypeProvider = ProviderFactory.getInstance().createHeaderProvider(MediaType.class);
    public static final String MEDIA_TYPE_WILDCARD = "*";
    private static final Map<String, String> emptyMap = Collections.emptyMap();

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters == null ? emptyMap : Collections.unmodifiableMap(parameters);
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, null);
    }

    public MediaType(String type) throws IllegalArgumentException {
        try {
            MediaType mediaType = mediaTypeProvider.fromString(type);
            this.type = mediaType.type;
            this.subtype = mediaType.subtype;
            this.parameters = mediaType.parameters;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ApiMessages.MEDIA_TYPE_INVALID(type), ex);
        }
    }

    public MediaType() {
        this(MEDIA_TYPE_WILDCARD, MEDIA_TYPE_WILDCARD);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isCompatible(MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.type.equals(MEDIA_TYPE_WILDCARD) || other.type.equals(MEDIA_TYPE_WILDCARD)) {
            return true;
        }
        if (this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(MEDIA_TYPE_WILDCARD) || other.subtype.equals(MEDIA_TYPE_WILDCARD))) {
            return true;
        }
        return this.equals(other);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode();
    }

    public String toString() {
        return mediaTypeProvider.toString(this);
    }
}

