/*
 * Decompiled with CFR 0.152.
 */
package javax.websocket.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfiguration;

public class DefaultServerConfiguration
implements ServerEndpointConfiguration {
    private String path;
    private Class<?> endpointClass;
    private List<String> subprotocols = Collections.unmodifiableList(new ArrayList());
    private List<Extension> extensions = Collections.unmodifiableList(new ArrayList());
    private List<Encoder> encoders = Collections.unmodifiableList(new ArrayList());
    private List<Decoder> decoders = Collections.unmodifiableList(new ArrayList());

    private DefaultServerConfiguration() {
    }

    @Override
    public Class<?> getEndpointClass() {
        return this.endpointClass;
    }

    public DefaultServerConfiguration(Class<? extends Endpoint> endpointClass, String path) {
        this.path = path;
        this.endpointClass = endpointClass;
    }

    public DefaultServerConfiguration setEncoders(List<Encoder> encoders) {
        this.encoders = Collections.unmodifiableList(encoders);
        return this;
    }

    public DefaultServerConfiguration setDecoders(List<Decoder> decoders) {
        this.decoders = Collections.unmodifiableList(decoders);
        return this;
    }

    public DefaultServerConfiguration setSubprotocols(List<String> subprotocols) {
        this.subprotocols = Collections.unmodifiableList(subprotocols);
        return this;
    }

    public DefaultServerConfiguration setExtensions(List<Extension> extensions) {
        this.extensions = Collections.unmodifiableList(extensions);
        return this;
    }

    @Override
    public List<Encoder> getEncoders() {
        return this.encoders;
    }

    @Override
    public List<Decoder> getDecoders() {
        return this.decoders;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getNegotiatedSubprotocol(List<String> requestedSubprotocols) {
        throw new RuntimeException("To implement");
    }

    @Override
    public List<Extension> getNegotiatedExtensions(List<Extension> requestedExtensions) {
        throw new RuntimeException("To implement");
    }

    @Override
    public boolean checkOrigin(String originHeaderValue) {
        throw new RuntimeException("To implement");
    }

    @Override
    public boolean matchesURI(URI uri) {
        return this.path.equals(uri.toString());
    }

    @Override
    public void modifyHandshake(HandshakeRequest request, HandshakeResponse response) {
    }
}

