/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.toplink.essentials.expressions.Expression;

public class FetchGroup
implements Serializable {
    private String name = "";
    private Set attributes = new TreeSet();
    private List fetchGroupAttributeExpressions;

    public FetchGroup() {
        this("");
    }

    public FetchGroup(String name) {
        this.name = name;
        this.fetchGroupAttributeExpressions = new ArrayList();
    }

    public Set getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String attrName) {
        this.attributes.add(attrName);
    }

    public void addAttributes(Set newAttributes) {
        this.attributes.addAll(newAttributes);
    }

    public void removeAttribute(String attrName) {
        this.attributes.remove(attrName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isSupersetOf(FetchGroup anotherGroup) {
        return anotherGroup != null && this.getAttributes().containsAll(anotherGroup.getAttributes());
    }

    public List getFetchGroupAttributeExpressions() {
        return this.fetchGroupAttributeExpressions;
    }

    public void setFetchGroupAttributeExpressions(List fetchGroupAttributeExpressions) {
        this.fetchGroupAttributeExpressions = fetchGroupAttributeExpressions;
    }

    public boolean hasFetchGroupAttributeExpressions() {
        return !this.fetchGroupAttributeExpressions.isEmpty();
    }

    public void addFetchGroupAttribute(Expression attributeExpression) {
        this.getFetchGroupAttributeExpressions().add(attributeExpression);
    }
}

