/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

public abstract class MetadataAccessibleObject {
    private String m_name;
    private Class m_rawClass;
    private Type m_relationType;
    private String m_attributeName;
    private Class m_referenceClass;
    private AnnotatedElement m_annotatedElement;

    public MetadataAccessibleObject(AnnotatedElement annotatedElement) {
        this.m_annotatedElement = annotatedElement;
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.m_annotatedElement;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public String getName() {
        return this.m_name;
    }

    public Class getRawClass() {
        if (this.m_rawClass == null) {
            this.m_rawClass = MetadataHelper.isGenericCollectionType(this.m_relationType) ? MetadataHelper.getRawClassFromGeneric(this.m_relationType) : (Class)this.m_relationType;
        }
        return this.m_rawClass;
    }

    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = MetadataHelper.isGenericCollectionType(this.m_relationType) ? MetadataHelper.getReturnTypeFromGeneric(this.m_relationType) : (Class)this.m_relationType;
        }
        return this.m_referenceClass;
    }

    public Type getRelationType() {
        return this.m_relationType;
    }

    protected void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.m_annotatedElement = annotatedElement;
    }

    protected void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    public void setReferenceClass(Class referenceClass) {
        this.m_referenceClass = referenceClass;
    }

    protected void setRelationType(Type relationType) {
        this.m_relationType = relationType;
    }
}

