/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Blob;
import java.sql.Clob;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.TimestampLockingPolicy;
import oracle.toplink.essentials.descriptors.VersionLockingPolicy;
import oracle.toplink.essentials.indirection.ValueHolderInterface;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.columns.AnnotationsColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataLogger;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataProject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataValidator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataGeneratedValue;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataSequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.sequencing.MetadataTableGenerator;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.AggregateObjectMapping;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.mappings.converters.EnumTypeConverter;
import oracle.toplink.essentials.mappings.converters.SerializedObjectConverter;
import oracle.toplink.essentials.mappings.converters.TypeConversionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataProcessor {
    protected ClassLoader m_loader;
    protected MetadataLogger m_logger;
    protected MetadataValidator m_validator;
    protected AbstractSession m_session;
    protected HashMap m_metadataDescriptors;
    protected boolean m_enableLazyForOneToOne;
    protected HashSet m_relatedEntities;
    protected MetadataProject m_metadataProject;

    protected void addJoinColumnDefault(List joinColumns, String sourceTableName, String targetTableName, MetadataDescriptor md) {
        if (joinColumns.isEmpty()) {
            MetadataJoinColumn mjc = new MetadataJoinColumn();
            mjc.getPrimaryKeyField().setTableName(sourceTableName);
            mjc.getForeignKeyField().setTableName(targetTableName);
            joinColumns.add(mjc);
        }
    }

    protected void addManyToManyRelationKeyFields(List relationKeys, ManyToManyMapping mapping, MetadataAccessor accessor, String defaultFieldName, MetadataDescriptor md, boolean isSource) {
        String FK_CTX;
        String PK_CTX;
        if (md.hasCompositePrimaryKey()) {
            if (relationKeys.size() != md.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompleteJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
            }
        } else {
            this.addJoinColumnDefault(relationKeys, md.getPrimaryTableName(), mapping.getRelationTableQualifiedName(), md);
        }
        if (isSource) {
            PK_CTX = "metadata_default_source_pk_column";
            FK_CTX = "metadata_default_source_fk_column";
        } else {
            PK_CTX = "metadata_default_target_pk_column";
            FK_CTX = "metadata_default_target_fk_column";
        }
        if (!this.handlePotentialPartialManyToManyRelationshipMapping(mapping, isSource, relationKeys)) {
            for (MetadataJoinColumn mjc : relationKeys) {
                String defaultPKFieldName = md.getPrimaryKeyFieldName();
                DatabaseField pkField = mjc.getPrimaryKeyField();
                if (mapping.requiresCompletion() && !isSource) {
                    pkField.setName(mapping.getXMLPKNameAttribute());
                }
                pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX, accessor));
                DatabaseField fkField = mjc.getForeignKeyField();
                String defaultFKFieldName = defaultFieldName + "_" + defaultPKFieldName;
                if (mapping.requiresCompletion() && !isSource) {
                    fkField.setName(mapping.getXMLFKNameAttribute());
                }
                fkField.setName(this.getName(fkField, defaultFKFieldName, FK_CTX, accessor));
                if (isSource) {
                    mapping.addSourceRelationKeyField(fkField, pkField);
                    continue;
                }
                mapping.addTargetRelationKeyField(fkField, pkField);
            }
        }
    }

    protected void addMultipleTableKeyField(MetadataJoinColumn mjc, String PK_CTX, String FK_CTX, MetadataDescriptor md) {
        String defaultPKFieldName = md.getPrimaryKeyFieldName();
        DatabaseField pkField = mjc.getPrimaryKeyField();
        pkField.setName(this.getName(pkField, defaultPKFieldName, PK_CTX, md));
        DatabaseField fkField = mjc.getForeignKeyField();
        fkField.setName(this.getName(fkField, pkField.getName(), FK_CTX, md));
        if (fkField.getName().equals(pkField.getName())) {
            md.addMultipleTablePrimaryKeyField(pkField, fkField);
        } else {
            md.addMultipleTableForeignKeyField(pkField, fkField);
        }
    }

    protected DatabaseTable buildDefaultJoinTable(MetadataAccessor accessor) {
        return this.buildJoinTable("", "", "", accessor);
    }

    protected void buildDefaultPrimaryTable(MetadataDescriptor md) {
        this.buildPrimaryTable("", "", "", md);
    }

    protected DatabaseTable buildJoinTable(String name, String catalog, String schema, MetadataAccessor accessor) {
        String sourceName = Helper.getShortClassName(accessor.getJavaClassName()).toUpperCase();
        String targetName = Helper.getShortClassName(accessor.getReferenceClassName()).toUpperCase();
        String defaultName = sourceName + "_" + targetName;
        AnnotatedElement element = accessor.getAnnotatedElement();
        name = this.getName(name, defaultName, "metadata_default_join_table_name", element);
        return this.buildTable(name, catalog, "metadata_default_join_table_catalog", schema, "metadata_default_join_table_schema", element, accessor.getMetadataDescriptor());
    }

    protected DatabaseTable buildPrimaryTable(String name, String catalog, String schema, MetadataDescriptor descriptor) {
        DatabaseTable dbTable = this.buildTable(name, catalog, schema, descriptor);
        descriptor.setPrimaryTable(dbTable);
        return dbTable;
    }

    protected DatabaseTable buildTable(String name, String catalog, String schema, MetadataDescriptor md) {
        name = this.getName(name, md.getDefaultTableName(), "metadata_default_table_name", md.getJavaClass());
        return this.buildTable(name, catalog, "metadata_default_table_catalog", schema, "metadata_default_table_schema", md.getJavaClass(), md);
    }

    protected DatabaseTable buildTable(String name, String catalog, String catalogContext, String schema, String schemaContext, Object element, MetadataDescriptor md) {
        catalog = this.getName(catalog, md.getCatalog(), catalogContext, element);
        schema = this.getName(schema, md.getSchema(), schemaContext, element);
        return new DatabaseTable(MetadataHelper.getFullyQualifiedTableName(name, catalog, schema));
    }

    protected DatabaseField getDatabaseField(MetadataAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getMetadataDescriptor();
        if (descriptor.hasAttributeOverrideFor(accessor)) {
            return descriptor.getAttributeOverrideFor(accessor).getDatabaseField();
        }
        return this.processColumn(accessor).getDatabaseField();
    }

    public abstract MetadataLogger getLogger();

    public abstract MetadataDescriptor getMetadataDescriptor(Class var1);

    public MetadataProject getMetadataProject() {
        return this.m_metadataProject;
    }

    protected String getName(DatabaseField field, String defaultName, String context, MetadataAccessor accessor) {
        String name = field.getName();
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return name;
        }
        this.getLogger().logConfigMessage(context, accessor.getAnnotatedElement(), (Object)defaultName);
        this.handlePotentialDefaultPrimaryKeyUsage(field, accessor, defaultName, context);
        return defaultName;
    }

    protected String getName(DatabaseField field, String defaultName, String context, MetadataDescriptor md) {
        String name = field.getName();
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return name;
        }
        this.getLogger().logConfigMessage(context, md.getJavaClass(), (Object)defaultName);
        if (defaultName.equals(md.getPrimaryKeyFieldName())) {
            this.handlePotentialDefaultPrimaryKeyUsage(field, md);
        }
        return defaultName;
    }

    protected String getName(String name, String defaultName, String context, Object element) {
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return name;
        }
        this.getLogger().logConfigMessage(context, element, (Object)defaultName);
        return defaultName;
    }

    protected DatabaseMapping getOwningMapping(MetadataAccessor accessor) {
        String ownerAttributeName = accessor.getMappedBy();
        MetadataDescriptor ownerDmd = accessor.getReferenceMetadataDescriptor();
        DatabaseMapping mapping = ownerDmd.getMappingForAttributeName(ownerAttributeName);
        if (mapping == null) {
            this.getValidator().throwNoMappedByAttributeFound(ownerDmd.getJavaClass(), ownerAttributeName, accessor.getJavaClass(), accessor.getAttributeName());
        }
        return mapping;
    }

    public abstract MetadataValidator getValidator();

    protected abstract void handlePotentialDefaultPrimaryKeyUsage(DatabaseField var1, MetadataAccessor var2, String var3, String var4);

    protected abstract void handlePotentialDefaultPrimaryKeyUsage(DatabaseField var1, MetadataDescriptor var2);

    protected abstract boolean handlePotentialPartialManyToManyRelationshipMapping(ManyToManyMapping var1, boolean var2, List var3);

    protected abstract boolean handlePotentialPartialOneToOneRelationshipMapping(OneToOneMapping var1, List var2);

    protected OneToOneMapping initOneToOneMapping(MetadataAccessor accessor) {
        DatabaseMapping existingMapping = accessor.getMetadataDescriptor().m_descriptor.getMappingForAttributeName(accessor.getAttributeName());
        if (existingMapping != null) {
            return (OneToOneMapping)existingMapping;
        }
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(false);
        mapping.setIsOptional(accessor.isOptional());
        mapping.setAttributeName(accessor.getAttributeName());
        mapping.setReferenceClassName(accessor.getReferenceClassName());
        boolean usesIndirection = this.m_enableLazyForOneToOne ? accessor.usesIndirection() : false;
        mapping.setUsesIndirection(usesIndirection);
        this.setAccessorMethods(mapping, accessor);
        this.processCascadeType(mapping, accessor);
        return mapping;
    }

    protected void populateCollectionMapping(CollectionMapping mapping, MetadataAccessor accessor) {
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(false);
        mapping.setAttributeName(accessor.getAttributeName());
        this.setAccessorMethods(mapping, accessor);
        this.processCascadeType(mapping, accessor);
        accessor.setReferenceClass(accessor.getTargetEntity(), "metadata_default_one_to_many_reference_class");
        mapping.setReferenceClassName(accessor.getReferenceClassName());
        this.processOrderBy(mapping, accessor);
        String mapKey = this.processMapKey(mapping, accessor);
        MetadataHelper.setIndirectionPolicy(accessor, mapping, mapKey);
    }

    protected void processAccessor(MetadataAccessor accessor) {
        accessor.store();
        this.processTableGenerator(accessor);
        this.processSequenceGenerator(accessor);
        if (accessor.isEmbedded()) {
            this.processEmbedded(false, accessor);
        } else if (accessor.isEmbeddedId()) {
            this.processEmbeddedId(accessor);
        } else if (accessor.isRelationship()) {
            this.m_relatedEntities.add(accessor.getMetadataDescriptor());
        } else {
            DatabaseField field = this.getDatabaseField(accessor);
            if (accessor.isVersion()) {
                if (accessor.getMetadataDescriptor().usesOptimisticLocking()) {
                    this.getLogger().logWarningMessage(MetadataLogger.IGNORE_VERSION_LOCKING, accessor);
                } else {
                    this.processVersion(field, accessor);
                }
            } else {
                this.processId(field, accessor);
            }
            if (accessor.getMetadataDescriptor().hasMappingForAccessor(accessor)) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_MAPPING, accessor);
            } else {
                this.processDirectToFieldMapping(field, accessor);
            }
        }
    }

    protected void processAccessors(MetadataDescriptor descriptor) {
        this.processAccessors(descriptor.getJavaClass(), descriptor.usesPropertyAccess(), descriptor);
    }

    protected abstract void processAccessors(Class var1, boolean var2, MetadataDescriptor var3);

    protected abstract void processAssociationOverrides(AggregateObjectMapping var1, MetadataAccessor var2);

    protected void processAttributeOverride(AggregateObjectMapping mapping, MetadataColumn column, MetadataAccessor accessor) {
        String attributeName = column.getAttributeName();
        MetadataDescriptor descriptor = accessor.getMetadataDescriptor();
        MetadataDescriptor aggregateDescriptor = accessor.getReferenceMetadataDescriptor();
        DatabaseMapping aggregateMapping = aggregateDescriptor.getMappingForAttributeName(attributeName);
        if (aggregateMapping == null) {
            this.getValidator().throwInvalidEmbeddableAttribute(descriptor.getJavaClass(), mapping.getAttributeName(), aggregateDescriptor.getJavaClass(), attributeName);
        }
        DatabaseField field = descriptor.hasAttributeOverrideFor(attributeName) ? descriptor.getAttributeOverrideFor(attributeName).getDatabaseField() : column.getDatabaseField();
        mapping.addFieldNameTranslation(field.getQualifiedName(), aggregateMapping.getField().getName());
    }

    protected void processAssociationOverrides(Class cls, MetadataDescriptor descriptor) {
        AssociationOverride associationOverride;
        AssociationOverrides associationOverrides = (AssociationOverrides)AnnotationsHelper.getAnnotation(AssociationOverrides.class, cls, descriptor);
        if (associationOverrides != null) {
            for (AssociationOverride associationOverride2 : associationOverrides.value()) {
                descriptor.addAssociationOverride(associationOverride2.name(), associationOverride2.joinColumns());
            }
        }
        if ((associationOverride = (AssociationOverride)AnnotationsHelper.getAnnotation(AssociationOverride.class, cls, descriptor)) != null) {
            descriptor.addAssociationOverride(associationOverride.name(), associationOverride.joinColumns());
        }
    }

    protected abstract void processAttributeOverrides(AggregateObjectMapping var1, MetadataAccessor var2);

    protected void processAttributeOverrides(Class cls, MetadataDescriptor descriptor) {
        AttributeOverride attributeOverride;
        AnnotationsColumn column;
        AttributeOverrides attributeOverrides = (AttributeOverrides)AnnotationsHelper.getAnnotation(AttributeOverrides.class, cls, descriptor);
        if (attributeOverrides != null) {
            for (AttributeOverride attributeOverride2 : attributeOverrides.value()) {
                column = new AnnotationsColumn(attributeOverride2.column(), attributeOverride2.name(), descriptor.getPrimaryTableName(), cls);
                this.processColumnDefaults(column);
                descriptor.addAttributeOverride(column);
            }
        }
        if ((attributeOverride = (AttributeOverride)AnnotationsHelper.getAnnotation(AttributeOverride.class, cls, descriptor)) != null) {
            column = new AnnotationsColumn(attributeOverride.column(), attributeOverride.name(), descriptor.getPrimaryTableName(), cls);
            this.processColumnDefaults(column);
            descriptor.addAttributeOverride(column);
        }
    }

    protected abstract void processBasic(DirectToFieldMapping var1, MetadataAccessor var2);

    protected abstract void processCascadeType(ForeignReferenceMapping var1, MetadataAccessor var2);

    protected abstract MetadataColumn processColumn(MetadataAccessor var1);

    protected MetadataColumn processColumnDefaults(MetadataColumn column) {
        column.setTable(this.getName(column.getTable(), column.getPrimaryTable(), "metadata_default_table_name", column.getAnnotatedElement()));
        column.setName(this.getName(column.getName(), column.getUpperCaseAttributeName(), "metadata_default_column", column.getAnnotatedElement()));
        return column;
    }

    protected void processDirectToFieldMapping(DatabaseField field, MetadataAccessor accessor) {
        DirectToFieldMapping mapping = new DirectToFieldMapping();
        mapping.setField(field);
        mapping.setIsReadOnly(field.isReadOnly());
        mapping.setAttributeName(accessor.getAttributeName());
        this.setAccessorMethods(mapping, accessor);
        this.processBasic(mapping, accessor);
        if (accessor.isEnumerated()) {
            this.processEnumerated(mapping, accessor);
        } else if (accessor.isLob()) {
            this.processLob(mapping, accessor);
        } else if (accessor.isTemporal()) {
            this.processTemporal(mapping, accessor);
        } else if (accessor.isSerialized()) {
            this.processSerialized(mapping, accessor);
        }
        accessor.getMetadataDescriptor().addMapping(mapping);
    }

    protected void processDiscriminatorColumn(String name, String columnDefinition, int length, String discriminatorType, MetadataDescriptor metadataDescriptor) {
        DatabaseField field = new DatabaseField();
        field.setTableName(metadataDescriptor.getPrimaryTableName());
        field.setLength(length);
        field.setColumnDefinition(columnDefinition);
        field.setType(MetadataHelper.getDiscriminatorType(discriminatorType));
        field.setName(this.getName(name, "DTYPE", "metadata_default_discriminator_column", metadataDescriptor.getJavaClass()));
        metadataDescriptor.setClassIndicatorField(field);
    }

    protected void processDiscriminatorValue(MetadataDescriptor metadataDescriptor) {
        Class entityClass = metadataDescriptor.getJavaClass();
        if (!Modifier.isAbstract(entityClass.getModifiers())) {
            String discriminatorValue = metadataDescriptor.getDiscriminatorValue();
            if (discriminatorValue == null) {
                metadataDescriptor.addClassIndicator(entityClass, Helper.getShortClassName(entityClass.getName()));
            } else {
                metadataDescriptor.addClassIndicator(entityClass, discriminatorValue);
            }
        }
    }

    protected MetadataDescriptor processEmbeddableClass(boolean isEmbeddedId, MetadataAccessor accessor) {
        Class referenceClass = accessor.getReferenceClass();
        MetadataDescriptor descriptor = this.getMetadataDescriptor(referenceClass);
        MetadataDescriptor owningDescriptor = accessor.getMetadataDescriptor();
        if (!descriptor.isProcessed()) {
            descriptor.setDescriptorIsEmbeddable();
            this.processAccessors(descriptor);
        }
        if (isEmbeddedId && !descriptor.ignoreIDAnnotations()) {
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                DatabaseField field = (DatabaseField)mapping.getField().clone();
                field.setTableName(owningDescriptor.getPrimaryTableName());
                owningDescriptor.addPrimaryKeyField(field);
            }
        }
        return descriptor;
    }

    protected void processEmbedded(boolean isEmbeddedId, MetadataAccessor accessor) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        MetadataDescriptor referenceDmd = this.processEmbeddableClass(isEmbeddedId, accessor);
        md.addAggregateDmd(referenceDmd);
        if (md.hasMappingForAccessor(accessor)) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_MAPPING, md, accessor);
        } else {
            AggregateObjectMapping mapping = new AggregateObjectMapping();
            mapping.setIsReadOnly(false);
            mapping.setIsNullAllowed(true);
            mapping.setReferenceClassName(accessor.getReferenceClassName());
            mapping.setAttributeName(accessor.getAttributeName());
            this.setAccessorMethods(mapping, accessor);
            this.processAttributeOverrides(mapping, accessor);
            this.processAssociationOverrides(mapping, accessor);
            md.addMapping(mapping);
        }
    }

    protected void processEmbeddedId(MetadataAccessor accessor) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        if (md.ignoreIDAnnotations()) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_EMBEDDED_ID, accessor);
        } else {
            if (md.hasEmbeddedIdAttribute()) {
                this.getValidator().throwMultipleEmbeddedIdsFound(md.getJavaClass(), accessor.getAttributeName(), md.getEmbeddedIdAttributeName());
            }
            if (md.hasPrimaryKeyFields()) {
                this.getValidator().throwEmbeddedIdAndIdFound(md.getJavaClass(), accessor.getAttributeName(), md.getIdAttributeName());
            }
            md.setPKClass(accessor.getReferenceClass());
            md.setEmbeddedIdAttributeName(accessor.getAttributeName());
        }
        this.processEmbedded(true, accessor);
    }

    protected void processEntity(String alias, MetadataDescriptor descriptor) {
        if (descriptor.getAlias().equals("")) {
            ClassDescriptor d;
            if (alias.equals("")) {
                alias = Helper.getShortClassName(descriptor.getJavaClassName());
                this.getLogger().logConfigMessage("metadata_default_alias", descriptor, (Object)alias);
            }
            if ((d = this.m_session.getProject().getDescriptorForAlias(alias)) != null) {
                this.getValidator().throwNonUniqueEntityName(d.getJavaClassName(), descriptor.getJavaClassName(), alias);
            }
            descriptor.setAlias(alias);
            this.m_session.getProject().addAlias(alias, descriptor.getDescriptor());
        }
        if (descriptor.isInheritanceSubclass(this.m_metadataDescriptors)) {
            Class rootClass = descriptor.getInheritanceRootClass();
            MetadataDescriptor rootDescriptor = this.getMetadataDescriptor(rootClass);
            rootDescriptor.setIsInheritanceRoot(true);
            if (!rootDescriptor.isProcessed()) {
                this.processEntityClass(rootClass);
            }
            if (!rootDescriptor.hasInheritance()) {
                this.processInheritanceRoot(rootDescriptor);
            }
            descriptor.setInheritanceRootDmd(rootDescriptor);
            this.m_relatedEntities.add(descriptor);
        }
    }

    protected abstract void processEntityClass(Class var1);

    protected void processEnumerated(DirectToFieldMapping mapping, boolean isOrdinal, MetadataAccessor accessor) {
        Class referenceClass = accessor.getReferenceClass();
        if (accessor.hasEnumerated() && !MetadataHelper.isValidEnumeratedType(referenceClass)) {
            this.getValidator().throwInvalidTypeForEnumeratedAttribute(accessor.getJavaClass(), mapping.getAttributeName(), referenceClass);
        }
        mapping.setConverter(new EnumTypeConverter(mapping, accessor.getReferenceClassName(), isOrdinal));
    }

    protected abstract void processEnumerated(DirectToFieldMapping var1, MetadataAccessor var2);

    protected abstract void processGeneratedValue(Object var1, DatabaseField var2, MetadataDescriptor var3);

    protected void processGeneratedValue(MetadataGeneratedValue generatedValue, DatabaseField sequenceNumberField, MetadataDescriptor descriptor) {
        DatabaseField existingSequenceNumberField = descriptor.getSequenceNumberField();
        if (existingSequenceNumberField == null) {
            descriptor.setSequenceNumberField(sequenceNumberField);
            this.m_metadataProject.addGeneratedValue(generatedValue, descriptor.getJavaClass());
        } else {
            this.getValidator().throwOnlyOneGeneratedValueIsAllowed(descriptor.getJavaClass(), existingSequenceNumberField.getQualifiedName(), sequenceNumberField.getQualifiedName());
        }
    }

    protected abstract void processId(DatabaseField var1, MetadataAccessor var2);

    protected void processId(DatabaseField field, Object generatedValue, MetadataAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getMetadataDescriptor();
        if (descriptor.ignoreIDAnnotations()) {
            MetadataLogger metadataLogger = this.getLogger();
            this.getLogger();
            metadataLogger.logWarningMessage(MetadataLogger.IGNORE_PRIMARY_KEY, accessor);
        } else {
            String attributeName = accessor.getAttributeName();
            if (descriptor.hasEmbeddedIdAttribute()) {
                this.getValidator().throwEmbeddedIdAndIdFound(descriptor.getJavaClass(), descriptor.getEmbeddedIdAttributeName(), attributeName);
            }
            descriptor.validatePKClassId(attributeName, accessor.getReferenceClass());
            descriptor.addIdAttributeName(attributeName);
            descriptor.addPrimaryKeyField(field);
            if (generatedValue != null) {
                this.processGeneratedValue(generatedValue, field, descriptor);
            }
        }
    }

    protected void processIdClass(Class pkClass, MetadataDescriptor metadataDescriptor) {
        block6: {
            if (pkClass == null) break block6;
            metadataDescriptor.setPKClass(pkClass);
            if (metadataDescriptor.ignoreIDAnnotations()) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_ID_CLASS, metadataDescriptor, pkClass);
            } else if (metadataDescriptor.usesPropertyAccess()) {
                Method[] methods = MetadataHelper.getDeclaredMethods(pkClass);
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    String methodName = method.getName();
                    if (!MetadataHelper.isValidPersistenceMethodName(methodName)) continue;
                    metadataDescriptor.addPKClassId(MetadataHelper.getAttributeNameFromMethodName(methodName), MetadataHelper.getGenericReturnType(method));
                }
            } else {
                Field[] fields = MetadataHelper.getFields(pkClass);
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    metadataDescriptor.addPKClassId(field.getName(), MetadataHelper.getGenericType(field));
                }
            }
        }
    }

    protected abstract void processInheritanceRoot(MetadataDescriptor var1);

    protected void processInheritanceSubclass(MetadataDescriptor descriptor) {
        if (descriptor.ignoreInheritanceAnnotations()) {
            this.getLogger().logWarningMessage(MetadataLogger.IGNORE_INHERITANCE, descriptor);
        } else {
            if (descriptor.hasInheritanceTag(descriptor.getJavaClass())) {
                this.getLogger().logWarningMessage(MetadataLogger.IGNORE_INHERITANCE, descriptor);
            }
            descriptor.setParentClass();
            MetadataDescriptor rootDescriptor = descriptor.getInheritanceRootDmd();
            if (rootDescriptor.usesSingleTableInheritanceStrategy()) {
                descriptor.setSingleTableInheritanceStrategy();
            } else {
                for (MetadataJoinColumn mjc : this.processPrimaryKeyJoinColumns(rootDescriptor.getPrimaryTableName(), descriptor.getPrimaryTableName(), descriptor.getJavaClass(), descriptor)) {
                    this.getLogger();
                    this.getLogger();
                    this.addMultipleTableKeyField(mjc, "metadata_default_inheritance_pk_column", "metadata_default_inheritance_fk_column", descriptor);
                }
            }
            this.processDiscriminatorValue(descriptor);
            if (rootDescriptor.hasCompositePrimaryKey()) {
                descriptor.setPKClass(rootDescriptor.getPKClassName());
            }
        }
    }

    protected MetadataJoinColumn processJoinColumn(String targetTable, String fkFieldName, String pkFieldName, String columnDefinition, String table, boolean isUnique, boolean isNullable, boolean isInsertable, boolean isUpdatable, MetadataAccessor accessor, MetadataDescriptor sourceMd) {
        if (sourceMd.hasCompositePrimaryKey() && (pkFieldName.equals("") || fkFieldName.equals(""))) {
            this.getValidator().throwIncompleteJoinColumnsSpecified(accessor.getJavaClass(), accessor.getAnnotatedElement());
        }
        MetadataJoinColumn mjc = new MetadataJoinColumn();
        DatabaseField pkField = new DatabaseField();
        pkField.setName(pkFieldName);
        pkField.setTableName(sourceMd.getPrimaryTableName());
        mjc.setPrimaryKeyField(pkField);
        DatabaseField fkField = new DatabaseField();
        fkField.setName(fkFieldName);
        mjc.setForeignKeyField(fkField);
        fkField.setUnique(isUnique);
        fkField.setNullable(isNullable);
        fkField.setInsertable(isInsertable);
        fkField.setUpdatable(isUpdatable);
        fkField.setColumnDefinition(columnDefinition);
        if (table.equals("")) {
            if (targetTable != null) {
                fkField.setTableName(targetTable);
            }
        } else {
            fkField.setTableName(table);
        }
        return mjc;
    }

    protected abstract List processJoinColumns(MetadataAccessor var1);

    protected abstract void processJoinTable(ManyToManyMapping var1, MetadataAccessor var2);

    protected void processJoinTable(ManyToManyMapping mapping, List sourceKeys, List targetKeys, MetadataAccessor accessor) {
        Class sourceClass = accessor.getJavaClass();
        String defaultSourceFieldName = accessor.getReferenceMetadataDescriptor().hasManyToManyAccessorFor(sourceClass) ? accessor.getReferenceMetadataDescriptor().getManyToManyAccessor(sourceClass).getAttributeName() : Helper.getShortClassName(sourceClass.getName());
        String defaultTargetFieldName = accessor.getAttributeName();
        this.addManyToManyRelationKeyFields(sourceKeys, mapping, accessor, defaultSourceFieldName, accessor.getMetadataDescriptor(), true);
        this.addManyToManyRelationKeyFields(targetKeys, mapping, accessor, defaultTargetFieldName, accessor.getReferenceMetadataDescriptor(), false);
    }

    protected void processLob(DirectToFieldMapping mapping, MetadataAccessor accessor) {
        Class referenceClass = accessor.getReferenceClass();
        mapping.setConverter(new TypeConversionConverter(mapping));
        if (MetadataHelper.isValidClobType(referenceClass)) {
            mapping.setFieldClassification(Clob.class);
        } else if (MetadataHelper.isValidBlobType(referenceClass)) {
            mapping.setFieldClassification(Blob.class);
        } else {
            this.getValidator().throwInvalidTypeForLOBAttribute(accessor.getJavaClass(), mapping.getAttributeName(), referenceClass);
        }
    }

    protected void processManyToMany(MetadataAccessor accessor) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        ManyToManyMapping mapping = new ManyToManyMapping();
        mapping.setIsPrivateOwned(false);
        mapping.setAttributeName(accessor.getAttributeName());
        this.setAccessorMethods(mapping, accessor);
        accessor.setReferenceClass(accessor.getTargetEntity(), "metadata_default_many_to_many_reference_class");
        mapping.setReferenceClassName(accessor.getReferenceClassName());
        this.processOrderBy(mapping, accessor);
        String mapKey = this.processMapKey(mapping, accessor);
        MetadataHelper.setIndirectionPolicy(accessor, mapping, mapKey);
        this.processCascadeType(mapping, accessor);
        if (accessor.getMappedBy().equals("")) {
            this.processJoinTable(mapping, accessor);
        } else {
            mapping.setIsReadOnly(true);
            ManyToManyMapping ownerMapping = (ManyToManyMapping)this.getOwningMapping(accessor);
            if (ownerMapping == null) {
                mapping.setRequiresCompletion(true);
                mapping.setMappedBy(accessor.getMappedBy());
            } else {
                if (ownerMapping.requiresCompletion()) {
                    MetadataAccessor owningAccessor = accessor.getReferenceMetadataDescriptor().getAccessorFor(ownerMapping.getAttributeName());
                    this.processJoinTable(ownerMapping, owningAccessor);
                }
                mapping.setRelationTableName(ownerMapping.getRelationTableName());
                mapping.setSourceKeyFields(ownerMapping.getTargetKeyFields());
                mapping.setSourceRelationKeyFields(ownerMapping.getTargetRelationKeyFields());
                mapping.setTargetKeyFields(ownerMapping.getSourceKeyFields());
                mapping.setTargetRelationKeyFields(ownerMapping.getSourceRelationKeyFields());
            }
        }
        md.addMapping(mapping);
    }

    protected void processManyToOne(MetadataAccessor accessor) {
        accessor.setReferenceClass(accessor.getTargetEntity(), "metadata_default_many_to_one_reference_class");
        OneToOneMapping mapping = this.initOneToOneMapping(accessor);
        this.processOwningMappingKeys(mapping, accessor);
        accessor.getMetadataDescriptor().addMapping(mapping);
    }

    protected String processMapKey(CollectionMapping mapping, MetadataAccessor accessor) {
        String mapKey = null;
        if (accessor.isMapCollectionAccessor()) {
            MetadataDescriptor referenceDmd = accessor.getReferenceMetadataDescriptor();
            if (!accessor.getMapKey().equals("") || !referenceDmd.hasCompositePrimaryKey()) {
                String string = accessor.getMapKey();
                String string2 = referenceDmd.getIdAttributeName();
                this.getLogger();
                String fieldOrPropertyName = this.getName(string, string2, "metadata_default_map_key_attribute_name", (Object)accessor);
                MetadataAccessor referenceAccessor = referenceDmd.getAccessorFor(fieldOrPropertyName);
                if (referenceAccessor == null) {
                    this.getValidator().throwCouldNotFindMapKey(fieldOrPropertyName, referenceDmd.getJavaClass(), mapping);
                }
                mapKey = referenceAccessor.getName();
            }
        }
        return mapKey;
    }

    protected void processMappedSuperclasses(MetadataDescriptor descriptor) {
        Class entityClass = descriptor.getJavaClass();
        this.processAttributeOverrides(entityClass, descriptor);
        this.processAssociationOverrides(entityClass, descriptor);
        for (Class mappedSuperclass : descriptor.getMappedSuperclasses()) {
            this.processNamedQueries(mappedSuperclass, descriptor);
            this.processNamedNativeQueries(mappedSuperclass, descriptor);
            this.processSqlResultSetMappings(mappedSuperclass, descriptor);
            this.processAccessors(mappedSuperclass, descriptor.usesPropertyAccess(), descriptor);
            this.processAttributeOverrides(mappedSuperclass, descriptor);
            this.processAssociationOverrides(entityClass, descriptor);
        }
    }

    protected abstract void processNamedNativeQueries(Class var1, MetadataDescriptor var2);

    protected abstract void processNamedQueries(Class var1, MetadataDescriptor var2);

    protected void processOneToMany(MetadataAccessor accessor) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        String mappedBy = accessor.getMappedBy();
        if (accessor.getElement() == null || mappedBy.equals("")) {
            if (accessor.hasJoinColumn() || accessor.hasJoinColumns()) {
                this.getValidator().throwUniDirectionalOneToManyHasJoinColumnSpecified(md.getJavaClass(), accessor.getAttributeName());
            }
            ManyToManyMapping mapping = new ManyToManyMapping();
            this.populateCollectionMapping(mapping, accessor);
            this.processJoinTable(mapping, accessor);
            md.addMapping(mapping);
        } else {
            OneToManyMapping mapping = new OneToManyMapping();
            this.populateCollectionMapping(mapping, accessor);
            OneToOneMapping ownerMapping = (OneToOneMapping)this.getOwningMapping(accessor);
            if (ownerMapping == null) {
                mapping.setRequiresCompletion(true);
                mapping.setMappedBy(mappedBy);
            } else {
                if (ownerMapping.requiresCompletion()) {
                    MetadataAccessor owningAccessor = accessor.getReferenceMetadataDescriptor().getAccessorFor(ownerMapping.getAttributeName());
                    this.processOwningMappingKeys(ownerMapping, owningAccessor);
                }
                Map keys = ownerMapping.getSourceToTargetKeyFields();
                for (DatabaseField fkField : keys.keySet()) {
                    mapping.addTargetForeignKeyField(fkField, (DatabaseField)keys.get(fkField));
                }
            }
            md.addMapping(mapping);
        }
    }

    protected void processOneToOne(MetadataAccessor accessor) {
        accessor.setReferenceClass(accessor.getTargetEntity(), "metadata_default_one_to_one_reference_class");
        OneToOneMapping mapping = this.initOneToOneMapping(accessor);
        String mappedBy = accessor.getMappedBy();
        if (mappedBy.equals("")) {
            this.processOwningMappingKeys(mapping, accessor);
        } else {
            OneToOneMapping ownerMapping = (OneToOneMapping)this.getOwningMapping(accessor);
            if (ownerMapping == null) {
                mapping.setRequiresCompletion(true);
                mapping.setMappedBy(mappedBy);
            } else {
                if (ownerMapping.requiresCompletion()) {
                    MetadataAccessor owningAccessor = accessor.getReferenceMetadataDescriptor().getAccessorFor(ownerMapping.getAttributeName());
                    this.processOwningMappingKeys(ownerMapping, owningAccessor);
                }
                mapping.setSourceToTargetKeyFields(ownerMapping.getTargetToSourceKeyFields());
                mapping.setTargetToSourceKeyFields(ownerMapping.getSourceToTargetKeyFields());
            }
        }
        accessor.getMetadataDescriptor().addMapping(mapping);
    }

    protected void processOrderBy(CollectionMapping mapping, MetadataAccessor accessor) {
        block10: {
            if (!accessor.hasOrderBy()) break block10;
            MetadataDescriptor referenceDmd = accessor.getReferenceMetadataDescriptor();
            String orderBy = accessor.getOrderBy();
            if (orderBy.equals("")) {
                List<String> orderByAttributes = referenceDmd.getIdOrderByAttributeNames();
                if (referenceDmd.hasEmbeddedIdAttribute()) {
                    String embeddedIdAttributeName = referenceDmd.getEmbeddedIdAttributeName();
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addAggregateOrderBy(embeddedIdAttributeName, orderByAttribute, false);
                    }
                } else {
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addOrderBy(orderByAttribute, false);
                    }
                }
            } else {
                StringTokenizer commaTokenizer = new StringTokenizer(orderBy, ",");
                while (commaTokenizer.hasMoreTokens()) {
                    String ordering;
                    StringTokenizer spaceTokenizer = new StringTokenizer(commaTokenizer.nextToken());
                    String propertyOrFieldName = spaceTokenizer.nextToken();
                    MetadataAccessor referenceAccessor = referenceDmd.getAccessorFor(propertyOrFieldName);
                    if (referenceAccessor == null) {
                        this.getValidator().throwInvalidOrderByValue(accessor.getJavaClass(), propertyOrFieldName, referenceDmd.getJavaClass(), accessor.getName());
                    }
                    String attributeName = referenceAccessor.getAttributeName();
                    String string = ordering = spaceTokenizer.hasMoreTokens() ? spaceTokenizer.nextToken() : "ASC";
                    if (referenceAccessor.isEmbedded()) {
                        for (String orderByAttributeName : referenceDmd.getOrderByAttributeNames()) {
                            mapping.addAggregateOrderBy(attributeName, orderByAttributeName, ordering.equals("DESC"));
                        }
                        continue;
                    }
                    mapping.addOrderBy(attributeName, ordering.equals("DESC"));
                }
            }
        }
    }

    protected void processOwningMappingKeys(OneToOneMapping mapping, MetadataAccessor accessor) {
        List joinColumns;
        String defaultFKFieldName;
        String defaultPKFieldName;
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        MetadataDescriptor referenceDmd = accessor.getReferenceMetadataDescriptor();
        if (accessor.isOneToOnePrimaryKeyRelationship()) {
            defaultPKFieldName = referenceDmd.getPrimaryKeyFieldName();
            defaultFKFieldName = md.getPrimaryKeyFieldName();
            joinColumns = this.processPrimaryKeyJoinColumns(referenceDmd.getPrimaryTableName(), md.getPrimaryTableName(), accessor.getAnnotatedElement(), md);
        } else {
            defaultPKFieldName = referenceDmd.getPrimaryKeyFieldName();
            defaultFKFieldName = accessor.getUpperCaseAttributeName() + "_" + defaultPKFieldName;
            joinColumns = this.processJoinColumns(accessor);
        }
        if (!this.handlePotentialPartialOneToOneRelationshipMapping(mapping, joinColumns)) {
            for (MetadataJoinColumn mjc : joinColumns) {
                DatabaseField pkField = mjc.getPrimaryKeyField();
                if (mapping.requiresCompletion()) {
                    pkField.setName(mapping.getXMLPKNameAttribute());
                }
                pkField.setName(this.getName(pkField, defaultPKFieldName, "metadata_default_pk_column", accessor));
                DatabaseField fkField = mjc.getForeignKeyField();
                if (mapping.requiresCompletion()) {
                    fkField.setName(mapping.getXMLFKNameAttribute());
                }
                fkField.setName(this.getName(fkField, defaultFKFieldName, "metadata_default_fk_column", accessor));
                mapping.addForeignKeyField(fkField, pkField);
                if (!accessor.isOneToOnePrimaryKeyRelationship() && !fkField.isReadOnly()) continue;
                mapping.setIsReadOnly(true);
            }
        }
    }

    protected MetadataJoinColumn processPrimaryKeyJoinColumn(String name, String referencedColumnName, String columnDefinition, String sourceTableName, String targetTableName, MetadataDescriptor md) {
        MetadataJoinColumn mjc = new MetadataJoinColumn();
        String fkFieldName = name;
        String pkFieldName = referencedColumnName;
        if (md.hasCompositePrimaryKey() && (pkFieldName.equals("") || fkFieldName.equals(""))) {
            this.getValidator().throwIncompletePrimaryKeyJoinColumnsSpecified(md.getJavaClass());
        }
        DatabaseField pkField = new DatabaseField();
        pkField.setName(pkFieldName);
        pkField.setTableName(sourceTableName);
        mjc.setPrimaryKeyField(pkField);
        DatabaseField fkField = new DatabaseField();
        fkField.setName(name);
        fkField.setTableName(targetTableName);
        fkField.setColumnDefinition(columnDefinition);
        mjc.setForeignKeyField(fkField);
        return mjc;
    }

    protected abstract List processPrimaryKeyJoinColumns(Object[] var1, String var2, String var3, MetadataDescriptor var4);

    protected abstract List<MetadataJoinColumn> processPrimaryKeyJoinColumns(String var1, String var2, Object var3, MetadataDescriptor var4);

    public void processRelationshipAccessor(MetadataAccessor accessor) {
        if (accessor.needsProcessing()) {
            if (accessor.getMetadataDescriptor().hasMappingForAccessor(accessor)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logWarningMessage(MetadataLogger.IGNORE_MAPPING, accessor);
            } else {
                if (accessor.hasColumn()) {
                    this.getValidator().throwRelationshipHasColumnSpecified(accessor.getJavaClass(), accessor.getAttributeName());
                }
                if (accessor.getTargetEntity() == ValueHolderInterface.class || accessor.getTargetEntity() == Void.TYPE && accessor.getReferenceClass() == ValueHolderInterface.class) {
                    return;
                }
                if (accessor.isManyToOne()) {
                    this.processManyToOne(accessor);
                } else if (accessor.isManyToMany()) {
                    this.processManyToMany(accessor);
                } else if (accessor.isOneToMany()) {
                    this.processOneToMany(accessor);
                } else if (accessor.isOneToOne()) {
                    this.processOneToOne(accessor);
                }
            }
            accessor.setNeedsProcessing(false);
        }
    }

    protected DatabaseTable processSecondaryTable(String name, String catalog, String schema, Object[] pkJoinCols, MetadataDescriptor descriptor) {
        DatabaseTable secondaryTable = this.buildTable(name, catalog, schema, descriptor);
        descriptor.addTable(secondaryTable);
        String primaryTableName = descriptor.getPrimaryTableName();
        String secondaryTableName = secondaryTable.getQualifiedName();
        List metadataJoinColumns = this.processPrimaryKeyJoinColumns(pkJoinCols, primaryTableName, secondaryTableName, descriptor);
        if (descriptor.hasCompositePrimaryKey()) {
            if (metadataJoinColumns.size() != descriptor.getPrimaryKeyFields().size()) {
                this.getValidator().throwIncompletePrimaryKeyJoinColumnsSpecified(descriptor.getJavaClass());
            }
        } else {
            this.addJoinColumnDefault(metadataJoinColumns, primaryTableName, secondaryTableName, descriptor);
        }
        for (MetadataJoinColumn mjc : metadataJoinColumns) {
            this.addMultipleTableKeyField(mjc, "metadata_default_secondary_table_pk_column", "metadata_default_secondary_table_fk_column", descriptor);
        }
        return secondaryTable;
    }

    protected abstract void processSequenceGenerator(MetadataAccessor var1);

    protected void processSequenceGenerator(MetadataSequenceGenerator sequenceGenerator) {
        String name = sequenceGenerator.getName();
        if (this.m_metadataProject.hasConflictingSequenceGenerator(sequenceGenerator)) {
            MetadataSequenceGenerator otherSequenceGenerator = this.m_metadataProject.getSequenceGenerator(name);
            if (sequenceGenerator.loadedFromAnnotations() && otherSequenceGenerator.loadedFromXML()) {
                return;
            }
            this.getValidator().throwConflictingSequenceGeneratorsSpecified(name, sequenceGenerator.getLocation(), otherSequenceGenerator.getLocation());
        }
        if (this.m_metadataProject.hasTableGenerator(name)) {
            MetadataTableGenerator otherTableGenerator = this.m_metadataProject.getTableGenerator(name);
            this.getValidator().throwConflictingSequenceAndTableGeneratorsSpecified(name, sequenceGenerator.getLocation(), otherTableGenerator.getLocation());
        }
        for (MetadataTableGenerator otherTableGenerator : this.m_metadataProject.getTableGenerators()) {
            if (!otherTableGenerator.getPkColumnValue().equals(sequenceGenerator.getSequenceName())) continue;
            this.getValidator().throwConflictingSequenceNameAndTablePkColumnValueSpecified(sequenceGenerator.getSequenceName(), sequenceGenerator.getLocation(), otherTableGenerator.getLocation());
        }
        this.m_metadataProject.addSequenceGenerator(sequenceGenerator);
    }

    protected void processSerialized(DirectToFieldMapping mapping, MetadataAccessor accessor) {
        Class referenceClass = accessor.getReferenceClass();
        if (Helper.classImplementsInterface(referenceClass, Serializable.class)) {
            mapping.setConverter(new SerializedObjectConverter(mapping));
        } else {
            this.getValidator().throwInvalidTypeForSerializedAttribute(accessor.getJavaClass(), mapping.getAttributeName(), referenceClass);
        }
    }

    protected abstract void processSqlResultSetMappings(Class var1, MetadataDescriptor var2);

    protected void processTableAnnotation(MetadataDescriptor descriptor) {
        if (descriptor.ignoreTableAnnotations()) {
            this.getLogger().logWarningMessage(AnnotationsLogger.IGNORE_TABLE, descriptor.getJavaClass());
        } else {
            Table table = (Table)AnnotationsHelper.getAnnotation(Table.class, descriptor);
            if (table != null) {
                DatabaseTable dbTable = this.buildPrimaryTable(table.name(), table.catalog(), table.schema(), descriptor);
                this.processUniqueConstraints(table.uniqueConstraints(), dbTable);
            } else {
                this.buildDefaultPrimaryTable(descriptor);
            }
        }
    }

    protected abstract void processTableGenerator(MetadataAccessor var1);

    protected void processTableGenerator(MetadataTableGenerator tableGenerator) {
        String name = tableGenerator.getName();
        if (this.m_metadataProject.hasConflictingTableGenerator(tableGenerator)) {
            MetadataTableGenerator otherTableGenerator = this.m_metadataProject.getTableGenerator(name);
            if (tableGenerator.loadedFromAnnotations() && otherTableGenerator.loadedFromXML()) {
                return;
            }
            this.getValidator().throwConflictingTableGeneratorsSpecified(name, tableGenerator.getLocation(), otherTableGenerator.getLocation());
        }
        if (this.m_metadataProject.hasSequenceGenerator(tableGenerator.getName())) {
            MetadataSequenceGenerator otherSequenceGenerator = this.m_metadataProject.getSequenceGenerator(name);
            this.getValidator().throwConflictingSequenceAndTableGeneratorsSpecified(name, otherSequenceGenerator.getLocation(), tableGenerator.getLocation());
        }
        for (MetadataSequenceGenerator otherSequenceGenerator : this.m_metadataProject.getSequenceGenerators()) {
            if (!otherSequenceGenerator.getSequenceName().equals(tableGenerator.getPkColumnValue())) continue;
            this.getValidator().throwConflictingSequenceNameAndTablePkColumnValueSpecified(otherSequenceGenerator.getSequenceName(), otherSequenceGenerator.getLocation(), tableGenerator.getLocation());
        }
        this.m_metadataProject.addTableGenerator(tableGenerator);
    }

    protected void processTemporal(DirectToFieldMapping mapping, MetadataAccessor accessor) {
        Class entityClass = accessor.getJavaClass();
        Class referenceClass = accessor.getReferenceClass();
        String attributeName = accessor.getAttributeName();
        if (MetadataHelper.isValidTemporalType(referenceClass)) {
            mapping.setConverter(new TypeConversionConverter(mapping));
            mapping.setFieldClassification(MetadataHelper.getFieldClassification(accessor.getTemporalType()));
        } else {
            this.getValidator().throwInvalidTypeForTemporalAttribute(entityClass, attributeName, referenceClass);
        }
    }

    protected void processUniqueConstraints(UniqueConstraint[] uniqueConstraints, DatabaseTable table) {
        for (UniqueConstraint uniqueConstraint : uniqueConstraints) {
            table.addUniqueConstraints(uniqueConstraint.columnNames());
        }
    }

    protected void processVersion(DatabaseField field, MetadataAccessor accessor) {
        Class lockType = accessor.getRawClass();
        field.setType(lockType);
        if (MetadataHelper.isValidVersionLockingType(lockType)) {
            accessor.getMetadataDescriptor().setOptimisticLockingPolicy(new VersionLockingPolicy(field));
        } else if (MetadataHelper.isValidTimstampVersionLockingType(lockType)) {
            accessor.getMetadataDescriptor().setOptimisticLockingPolicy(new TimestampLockingPolicy(field));
        } else {
            this.getValidator().throwInvalidTypeForVersionAttribute(accessor.getJavaClass(), accessor.getAttributeName(), lockType);
        }
    }

    protected void setAccessorMethods(DatabaseMapping mapping, MetadataAccessor accessor) {
        MetadataDescriptor md = accessor.getMetadataDescriptor();
        if (md.usesPropertyAccess()) {
            mapping.setGetMethodName(accessor.getName());
            mapping.setSetMethodName(accessor.getSetMethodName());
        }
    }

    protected void setCascadeType(String type, ForeignReferenceMapping mapping) {
        if (type.equals("cascade-all") || type.equals("ALL")) {
            mapping.setCascadeAll(true);
        } else if (type.equals("cascade-merge") || type.equals("MERGE")) {
            mapping.setCascadeMerge(true);
        } else if (type.equals("cascade-persist") || type.equals("PERSIST")) {
            mapping.setCascadePersist(true);
        } else if (type.equals("cascade-refresh") || type.equals("REFRESH")) {
            mapping.setCascadeRefresh(true);
        } else if (type.equals("cascade-remove") || type.equals("REMOVE")) {
            mapping.setCascadeRemove(true);
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public void updateClassesInMetadata() {
        if (this.m_metadataDescriptors == null) {
            return;
        }
        HashMap<Class, MetadataDescriptor> newMetadataDescriptors = new HashMap<Class, MetadataDescriptor>(this.m_metadataDescriptors.size());
        for (MetadataDescriptor md : this.m_metadataDescriptors.values()) {
            Class newClass = md.getDescriptor().getJavaClass();
            md.setJavaClass(newClass);
            md.setInheritanceRootClass(null);
            newMetadataDescriptors.put(newClass, md);
        }
        this.m_metadataDescriptors = newMetadataDescriptors;
    }
}

