/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.RelationalDescriptor;
import oracle.toplink.essentials.descriptors.VersionLockingPolicy;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.base.CMP3Policy;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataEntityListener;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataDescriptor {
    protected ClassDescriptor m_descriptor;
    protected Class m_javaClass;
    protected Class m_inheritanceRootClass;
    protected MetadataDescriptor m_inheritanceRootDmd;
    protected boolean m_isProcessed;
    protected boolean m_isInheritanceRoot;
    protected boolean m_ignoreIDAnnotations;
    protected boolean m_ignoreTableAnnotations;
    protected boolean m_ignoreInheritanceAnnotations;
    protected boolean m_usesSingleTableInheritanceStrategy;
    protected String m_primaryTableName;
    protected String m_embeddedIdAttributeName;
    protected Map m_accessors;
    protected Map<String, Type> m_pkClassIDs;
    protected Map<String, MetadataColumn> m_attributeOverrides;
    protected Map m_associationOverrides;
    protected Map m_manyToManyAccessors;
    protected Map<String, MetadataAccessor> m_relationshipAccessors;
    protected List<Class> m_mappedSuperclasses;
    protected List<MetadataDescriptor> m_aggregateDmds;
    protected List<String> m_idAttributeNames;
    protected List<String> m_orderByAttributeNames;
    protected List<String> m_idOrderByAttributeNames;
    protected Boolean m_isXmlPropertyAccess;
    protected Boolean m_isCascadePersistSet;
    protected boolean m_ignoreAnnotations;
    protected String m_xmlCatalog;
    protected String m_xmlSchema;
    protected boolean m_isDefaultPrimaryKeySet;
    protected List m_fieldsWithDefaultPrimaryKeySet;
    protected List m_fieldsWithComplexDefaultPrimaryKeySet;

    public MetadataDescriptor(Class javaClass) {
        this.init();
        this.m_descriptor = new RelationalDescriptor();
        this.m_descriptor.setExistenceChecking("Check database");
        this.m_descriptor.setAlias("");
        this.setJavaClass(javaClass);
    }

    public MetadataDescriptor(ClassDescriptor descriptor, Class javaClass) {
        this.init();
        this.m_descriptor = descriptor;
        this.setJavaClass(javaClass);
    }

    public MetadataDescriptor(MetadataDescriptor md) {
        this.m_isProcessed = false;
        this.m_descriptor = md.m_descriptor;
        this.m_javaClass = md.m_javaClass;
        this.m_primaryTableName = md.m_primaryTableName;
        this.m_inheritanceRootClass = null;
        this.m_inheritanceRootDmd = null;
        this.m_isInheritanceRoot = md.m_isInheritanceRoot;
        this.m_ignoreIDAnnotations = md.m_ignoreIDAnnotations;
        this.m_ignoreTableAnnotations = md.m_ignoreTableAnnotations;
        this.m_ignoreInheritanceAnnotations = md.m_ignoreInheritanceAnnotations;
        this.m_usesSingleTableInheritanceStrategy = md.m_usesSingleTableInheritanceStrategy;
        this.m_attributeOverrides = md.m_attributeOverrides;
        this.m_associationOverrides = md.m_associationOverrides;
        this.m_accessors = md.m_accessors;
        this.m_manyToManyAccessors = md.m_manyToManyAccessors;
        this.m_relationshipAccessors = md.m_relationshipAccessors;
        this.m_pkClassIDs = md.m_pkClassIDs;
        this.m_idAttributeNames = md.m_idAttributeNames;
        this.m_orderByAttributeNames = md.m_orderByAttributeNames;
        this.m_idOrderByAttributeNames = md.m_idOrderByAttributeNames;
        this.m_embeddedIdAttributeName = md.m_embeddedIdAttributeName;
        this.m_aggregateDmds = md.m_aggregateDmds;
        this.m_mappedSuperclasses = md.m_mappedSuperclasses;
        this.m_isCascadePersistSet = md.m_isCascadePersistSet;
        this.m_ignoreAnnotations = md.m_ignoreAnnotations;
        this.m_xmlCatalog = md.m_xmlCatalog;
        this.m_xmlSchema = md.m_xmlSchema;
        this.m_isXmlPropertyAccess = md.m_isXmlPropertyAccess;
        this.m_isDefaultPrimaryKeySet = md.m_isDefaultPrimaryKeySet;
        this.m_fieldsWithDefaultPrimaryKeySet = md.m_fieldsWithDefaultPrimaryKeySet;
        this.m_fieldsWithComplexDefaultPrimaryKeySet = md.m_fieldsWithComplexDefaultPrimaryKeySet;
    }

    public void addAccessor(MetadataAccessor accessor) {
        this.m_accessors.put(accessor.getAttributeName(), accessor);
        if (accessor.isRelationship()) {
            this.m_relationshipAccessors.put(accessor.getAttributeName(), accessor);
        }
        if (accessor.isManyToMany()) {
            this.m_manyToManyAccessors.put(accessor.getReferenceClass(), accessor);
        }
    }

    public void addAggregateDmd(MetadataDescriptor aggregateDmd) {
        this.m_aggregateDmds.add(aggregateDmd);
    }

    public void addAssociationOverride(String attributeName, Object[] joinColumns) {
        this.m_associationOverrides.put(attributeName, joinColumns);
    }

    public void addAttributeOverride(MetadataColumn column) {
        String attributeName = column.getAttributeName();
        if (column.loadedFromXML()) {
            this.m_attributeOverrides.put(attributeName, column);
        } else {
            MetadataColumn existingColumn = this.getAttributeOverrideFor(attributeName);
            if (existingColumn == null || !existingColumn.loadedFromXML()) {
                this.m_attributeOverrides.put(attributeName, column);
            }
        }
    }

    public void addClassIndicator(Class entityClass, String value) {
        if (this.isInheritanceSubclass()) {
            this.getInheritanceRootDmd().addClassIndicator(entityClass, value);
        } else {
            this.m_descriptor.getInheritancePolicy().addClassNameIndicator(entityClass.getName(), value);
        }
    }

    public void addDefaultEventListener(MetadataEntityListener listener) {
        this.m_descriptor.getEventManager().addDefaultEventListener(listener);
    }

    public void addEntityListenerEventListener(MetadataEntityListener listener) {
        this.m_descriptor.getEventManager().addEntityListenerEventListener(listener);
    }

    public void addIdAttributeName(String idAttributeName) {
        this.m_idAttributeNames.add(idAttributeName);
    }

    public void addMapping(DatabaseMapping mapping) {
        this.m_descriptor.addMapping(mapping);
    }

    public void addMultipleTableForeignKeyField(DatabaseField pkField, DatabaseField fkField) {
        this.m_descriptor.addMultipleTableForeignKeyField(pkField, fkField);
    }

    public void addMultipleTablePrimaryKeyField(DatabaseField pkField, DatabaseField fkField) {
        this.m_descriptor.addMultipleTablePrimaryKeyField(pkField, fkField);
    }

    public void addPKClassId(String attributeName, Type type) {
        this.m_pkClassIDs.put(attributeName, type);
    }

    public void addPrimaryKeyField(DatabaseField field) {
        this.m_descriptor.addPrimaryKeyField(field);
    }

    public void addTable(DatabaseTable table) {
        this.m_descriptor.addTable(table);
    }

    public boolean excludeSuperclassListeners() {
        return this.m_descriptor.getEventManager().excludeSuperclassListeners();
    }

    public MetadataAccessor getAccessorFor(String fieldOrPropertyName) {
        MetadataAccessor accessor = (MetadataAccessor)this.m_accessors.get(fieldOrPropertyName);
        if (accessor == null && (accessor = (MetadataAccessor)this.m_accessors.get(MetadataHelper.getAttributeNameFromMethodName(fieldOrPropertyName))) == null && this.isInheritanceSubclass()) {
            accessor = this.getInheritanceRootDmd().getAccessorFor(fieldOrPropertyName);
        }
        return accessor;
    }

    public String getAlias() {
        return this.m_descriptor.getAlias();
    }

    public Object[] getAssociationOverrideFor(MetadataAccessor accessor) {
        return (Object[])this.m_associationOverrides.get(accessor.getAttributeName());
    }

    public MetadataColumn getAttributeOverrideFor(MetadataAccessor accessor) {
        return this.getAttributeOverrideFor(accessor.getAttributeName());
    }

    public MetadataColumn getAttributeOverrideFor(String attributeName) {
        return this.m_attributeOverrides.get(attributeName);
    }

    public DatabaseField getClassIndicatorField() {
        if (this.getInheritanceRootDmd() != null) {
            return this.getInheritanceRootDmd().getDescriptor().getInheritancePolicy().getClassIndicatorField();
        }
        if (this.getDescriptor().hasInheritance()) {
            return this.getDescriptor().getInheritancePolicy().getClassIndicatorField();
        }
        return null;
    }

    public Vector getDefaultEventListeners() {
        return this.m_descriptor.getEventManager().getDefaultEventListeners();
    }

    public String getDefaultTableName() {
        String defaultTableName = this.getAlias().toUpperCase();
        if (this.isInheritanceSubclass() && this.m_inheritanceRootDmd.usesSingleTableInheritanceStrategy()) {
            defaultTableName = this.m_inheritanceRootDmd.getPrimaryTableName();
        }
        return defaultTableName;
    }

    public abstract String getDiscriminatorValue();

    public ClassDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public String getCatalog() {
        return this.m_xmlCatalog;
    }

    public String getEmbeddedIdAttributeName() {
        return this.m_embeddedIdAttributeName;
    }

    public MetadataEntityListener getEntityEventListener() {
        return (MetadataEntityListener)this.m_descriptor.getEventManager().getEntityEventListener();
    }

    public Vector getEntityListenerEventListeners() {
        return this.m_descriptor.getEventManager().getEntityListenerEventListeners();
    }

    public List getFieldsWithComplexDefaultPrimaryKeySet() {
        if (this.m_fieldsWithComplexDefaultPrimaryKeySet == null) {
            this.m_fieldsWithComplexDefaultPrimaryKeySet = new ArrayList();
        }
        return this.m_fieldsWithComplexDefaultPrimaryKeySet;
    }

    public List getFieldsWithDefaultPrimaryKeySet() {
        if (this.m_fieldsWithDefaultPrimaryKeySet == null) {
            this.m_fieldsWithDefaultPrimaryKeySet = new ArrayList();
        }
        return this.m_fieldsWithDefaultPrimaryKeySet;
    }

    public String getIdAttributeName() {
        if (this.getIdAttributeNames().isEmpty()) {
            if (this.isInheritanceSubclass()) {
                return this.getInheritanceRootDmd().getIdAttributeName();
            }
            return "";
        }
        return this.getIdAttributeNames().get(0);
    }

    public List<String> getIdAttributeNames() {
        return this.m_idAttributeNames;
    }

    public List<String> getIdOrderByAttributeNames() {
        if (this.m_idOrderByAttributeNames.isEmpty()) {
            this.m_idOrderByAttributeNames = this.m_idAttributeNames.isEmpty() ? (this.isInheritanceSubclass() ? this.m_inheritanceRootDmd.getIdAttributeNames() : this.getAccessorFor(this.getEmbeddedIdAttributeName()).getReferenceMetadataDescriptor().getOrderByAttributeNames()) : this.m_idAttributeNames;
        }
        return this.m_idOrderByAttributeNames;
    }

    public MetadataAccessor getManyToManyAccessor(Class cls) {
        return (MetadataAccessor)this.m_manyToManyAccessors.get(cls);
    }

    public List<String> getOrderByAttributeNames() {
        if (this.m_orderByAttributeNames.isEmpty()) {
            for (DatabaseMapping mapping : this.getMappings()) {
                if (!mapping.isDirectToFieldMapping()) continue;
                this.m_orderByAttributeNames.add(mapping.getAttributeName());
            }
        }
        return this.m_orderByAttributeNames;
    }

    public Class getInheritanceRootClass() {
        return this.m_inheritanceRootClass;
    }

    public MetadataDescriptor getInheritanceRootDmd() {
        return this.m_inheritanceRootDmd;
    }

    public Class getJavaClass() {
        return this.m_javaClass;
    }

    public String getJavaClassName() {
        return this.m_javaClass.getName();
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName) {
        MetadataAccessor accessor = this.getAccessorFor(attributeName);
        if (accessor != null) {
            if (accessor.isRelationship()) {
                accessor.process();
            }
            return this.m_descriptor.getMappingForAttributeName(attributeName);
        }
        for (MetadataDescriptor aggregateDmd : this.m_aggregateDmds) {
            DatabaseMapping mapping = aggregateDmd.getMappingForAttributeName(attributeName);
            if (mapping == null) continue;
            return mapping;
        }
        if (this.isInheritanceSubclass()) {
            return this.getInheritanceRootDmd().getMappingForAttributeName(attributeName);
        }
        return null;
    }

    public List<DatabaseMapping> getMappings() {
        return this.m_descriptor.getMappings();
    }

    public String getPKClassName() {
        String pkClassName = null;
        if (this.m_descriptor.hasCMPPolicy()) {
            pkClassName = ((CMP3Policy)this.m_descriptor.getCMPPolicy()).getPKClassName();
        }
        return pkClassName;
    }

    public String getPrimaryKeyFieldName() {
        if (this.getPrimaryKeyFields() == null || !this.getPrimaryKeyFields().iterator().hasNext()) {
            return "";
        }
        return ((DatabaseField)this.getPrimaryKeyFields().iterator().next()).getName();
    }

    public List getPrimaryKeyFields() {
        List primaryKeyFields = this.m_descriptor.getPrimaryKeyFields();
        if (primaryKeyFields.isEmpty() && this.isInheritanceSubclass()) {
            primaryKeyFields = this.getInheritanceRootDmd().getPrimaryKeyFields();
        }
        return primaryKeyFields;
    }

    public String getPrimaryTableName() {
        Vector tables = this.m_descriptor.getTables();
        if (this.m_primaryTableName == null && !tables.isEmpty()) {
            this.m_primaryTableName = ((DatabaseTable)tables.firstElement()).getQualifiedName();
        } else if (this.m_primaryTableName == null && tables.isEmpty()) {
            this.m_primaryTableName = "";
        }
        return this.m_primaryTableName;
    }

    public Collection<MetadataAccessor> getRelationshipAccessors() {
        return this.m_relationshipAccessors.values();
    }

    public String getSchema() {
        return this.m_xmlSchema;
    }

    public DatabaseField getSequenceNumberField() {
        return this.m_descriptor.getSequenceNumberField();
    }

    public boolean hasAssociationOverrideFor(MetadataAccessor accessor) {
        return this.m_associationOverrides.containsKey(accessor.getAttributeName());
    }

    public boolean hasAttributeOverrideFor(MetadataAccessor accessor) {
        return this.hasAttributeOverrideFor(accessor.getAttributeName());
    }

    public boolean hasAttributeOverrideFor(MetadataColumn column) {
        return this.hasAttributeOverrideFor(column.getAttributeName());
    }

    public boolean hasAttributeOverrideFor(String attributeName) {
        return this.m_attributeOverrides.containsKey(attributeName);
    }

    public boolean hasCompositePrimaryKey() {
        return this.getPrimaryKeyFields().size() > 1 || this.getPKClassName() != null;
    }

    public boolean hasEntityEventListener() {
        return this.m_descriptor.getEventManager().hasEntityEventListener();
    }

    public boolean hasEntityListenerEventListeners() {
        return this.m_descriptor.getEventManager().hasEntityListenerEventListeners();
    }

    public boolean hasEmbeddedIdAttribute() {
        return this.m_embeddedIdAttributeName != null;
    }

    protected abstract boolean hasEntityTag(Class var1);

    protected boolean hasInheritance() {
        return this.m_descriptor.hasInheritance();
    }

    protected abstract boolean hasInheritanceTag(Class var1);

    public boolean hasManyToManyAccessorFor(Class cls) {
        return this.m_manyToManyAccessors.containsKey(cls);
    }

    protected boolean hasMappedSuperclassAnnotation(Class cls) {
        return AnnotationsHelper.isAnnotationPresent(MappedSuperclass.class, cls, this);
    }

    public boolean hasMappingForAccessor(MetadataAccessor accessor) {
        return this.hasMappingForAttributeName(accessor.getAttributeName());
    }

    public boolean hasMappingForAttributeName(String attributeName) {
        return this.m_descriptor.getMappingForAttributeName(attributeName) != null;
    }

    public List<Class> getMappedSuperclasses() {
        if (this.m_mappedSuperclasses == null) {
            this.m_mappedSuperclasses = new ArrayList<Class>();
            for (Class parent = this.m_javaClass.getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
                if (!this.hasMappedSuperclassAnnotation(parent)) continue;
                this.m_mappedSuperclasses.add(parent);
            }
        }
        return this.m_mappedSuperclasses;
    }

    public boolean hasPrimaryKeyFields() {
        return this.m_descriptor.getPrimaryKeyFields().size() > 0;
    }

    public abstract boolean hasPrimaryKeyJoinColumns();

    public boolean ignoreIDAnnotations() {
        return this.m_ignoreIDAnnotations;
    }

    public boolean ignoreInheritanceAnnotations() {
        return this.m_ignoreInheritanceAnnotations;
    }

    public boolean ignoreTableAnnotations() {
        return this.m_ignoreTableAnnotations;
    }

    private void init() {
        this.m_isProcessed = false;
        this.m_isInheritanceRoot = false;
        this.m_ignoreIDAnnotations = false;
        this.m_ignoreTableAnnotations = false;
        this.m_ignoreInheritanceAnnotations = false;
        this.m_pkClassIDs = new HashMap<String, Type>();
        this.m_accessors = new HashMap();
        this.m_idAttributeNames = new ArrayList<String>();
        this.m_orderByAttributeNames = new ArrayList<String>();
        this.m_idOrderByAttributeNames = new ArrayList<String>();
        this.m_aggregateDmds = new ArrayList<MetadataDescriptor>();
        this.m_attributeOverrides = new HashMap<String, MetadataColumn>();
        this.m_associationOverrides = new HashMap();
        this.m_manyToManyAccessors = new HashMap();
        this.m_relationshipAccessors = new HashMap<String, MetadataAccessor>();
        this.m_xmlSchema = "";
        this.m_xmlCatalog = "";
        this.m_isXmlPropertyAccess = null;
        this.m_isCascadePersistSet = null;
        this.m_ignoreAnnotations = false;
        this.m_isDefaultPrimaryKeySet = false;
    }

    public boolean isAggregate() {
        return this.m_descriptor.isAggregateDescriptor() || this.m_javaClass.isAnnotationPresent(Embeddable.class);
    }

    public Boolean isCascadePersistSet() {
        return this.m_isCascadePersistSet != null;
    }

    public boolean isDefaultPrimaryKeySet() {
        return this.m_isDefaultPrimaryKeySet;
    }

    public boolean isXmlFieldAccess() {
        return this.m_isXmlPropertyAccess != null && this.m_isXmlPropertyAccess == false;
    }

    public boolean isXmlPropertyAccess() {
        return this.m_isXmlPropertyAccess != null && this.m_isXmlPropertyAccess == true;
    }

    public boolean isInheritanceRoot() {
        return this.m_isInheritanceRoot;
    }

    public boolean isInheritanceSubclass() {
        return this.getInheritanceRootClass() != null;
    }

    public boolean isInheritanceSubclass(HashMap m_metadataDescriptors) {
        Class lastParent = null;
        for (Class parent = this.m_javaClass.getSuperclass(); parent != Object.class; parent = parent.getSuperclass()) {
            if (!this.hasInheritanceTag(parent) && !m_metadataDescriptors.containsKey(parent)) continue;
            lastParent = parent;
        }
        this.m_inheritanceRootClass = lastParent;
        return this.isInheritanceSubclass();
    }

    public boolean isProcessed() {
        return this.m_isProcessed;
    }

    public boolean pkClassWasNotValidated() {
        return !this.m_pkClassIDs.isEmpty();
    }

    public void setAlias(String alias) {
        this.m_descriptor.setAlias(alias);
    }

    public void setCatalog(String xmlCatalog) {
        this.m_xmlCatalog = xmlCatalog;
    }

    public void setClassIndicatorField(DatabaseField field) {
        this.m_descriptor.getInheritancePolicy().setClassIndicatorField(field);
    }

    public void setDefaultPrimaryKey() {
        this.m_isDefaultPrimaryKeySet = true;
    }

    public void setDescriptor(RelationalDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public void setDescriptorIsEmbeddable() {
        this.m_descriptor.descriptorIsAggregate();
    }

    public void setEmbeddedIdAttributeName(String embeddedIdAttributeName) {
        this.m_embeddedIdAttributeName = embeddedIdAttributeName;
    }

    public void setEntityEventListener(MetadataEntityListener listener) {
        this.m_descriptor.getEventManager().setEntityEventListener(listener);
    }

    public void setExcludeDefaultListeners(boolean excludeDefaultListeners) {
        this.m_descriptor.getEventManager().setExcludeDefaultListeners(excludeDefaultListeners);
    }

    public void setExcludeSuperclassListeners(boolean excludeSuperclassListeners) {
        this.m_descriptor.getEventManager().setExcludeSuperclassListeners(excludeSuperclassListeners);
    }

    public void setIgnoreFlags() {
        this.m_ignoreInheritanceAnnotations = this.m_descriptor.hasInheritance();
        this.m_ignoreTableAnnotations = this.m_descriptor.getTableNames().size() > 0;
        this.m_ignoreIDAnnotations = this.m_descriptor.getPrimaryKeyFieldNames().size() > 0 && !this.isDefaultPrimaryKeySet();
    }

    public void setInheritanceRootDmd(MetadataDescriptor inheritanceRootDmd) {
        this.m_inheritanceRootDmd = inheritanceRootDmd;
    }

    public void setInheritanceRootClass(Class rootClass) {
        this.m_inheritanceRootClass = rootClass;
    }

    public void setInheritanceStrategy(String inheritanceStrategy) {
        if (inheritanceStrategy.equals("TABLE_PER_CLASS")) {
            throw ValidationException.tablePerClassInheritanceNotSupported(this.m_javaClass);
        }
        this.m_usesSingleTableInheritanceStrategy = inheritanceStrategy.equals("SINGLE_TABLE");
    }

    public void setIsInheritanceRoot(boolean isInheritanceRoot) {
        this.m_isInheritanceRoot = isInheritanceRoot;
    }

    public void setIsProcessed(boolean isProcessed) {
        this.m_isProcessed = isProcessed;
    }

    public void setIsXmlFieldAccess() {
        this.m_isXmlPropertyAccess = new Boolean(false);
    }

    public void setIsXmlPropertyAccess() {
        this.m_isXmlPropertyAccess = new Boolean(true);
    }

    public void setJavaClass(Class javaClass) {
        this.m_javaClass = javaClass;
        if (this.m_javaClass != null && this.m_descriptor != null) {
            this.m_descriptor.setJavaClassName(this.m_javaClass.getName());
        } else if (this.m_descriptor != null) {
            this.m_descriptor.setJavaClassName(null);
        }
    }

    public void setOptimisticLockingPolicy(VersionLockingPolicy policy) {
        policy.storeInObject();
        this.m_descriptor.setOptimisticLockingPolicy(policy);
    }

    public void setParentClass() {
        Class parent;
        for (parent = this.m_javaClass.getSuperclass(); parent != Object.class && !this.hasEntityTag(parent); parent = parent.getSuperclass()) {
        }
        this.setParentClass(parent);
    }

    public void setParentClass(Class parent) {
        this.m_descriptor.getInheritancePolicy().setParentClassName(parent.getName());
    }

    public void setPKClass(Class pkClass) {
        this.setPKClass(pkClass.getName());
    }

    public void setPKClass(String pkClassName) {
        CMP3Policy policy = new CMP3Policy();
        policy.setPrimaryKeyClassName(pkClassName);
        this.m_descriptor.setCMPPolicy(policy);
    }

    public void setPrimaryTable(DatabaseTable primaryTable) {
        this.addTable(primaryTable);
        this.m_primaryTableName = primaryTable.getQualifiedName();
    }

    public void setSchema(String xmlSchema) {
        this.m_xmlSchema = xmlSchema;
    }

    public void setSequenceNumberField(DatabaseField field) {
        this.m_descriptor.setSequenceNumberField(field);
    }

    public void setSequenceNumberName(String name) {
        this.m_descriptor.setSequenceNumberName(name);
    }

    public void setShouldIgnoreAnnotations(boolean ignoreAnnotations) {
        this.m_ignoreAnnotations = ignoreAnnotations;
    }

    public void setShouldUseCascadePersist(boolean isCascadePersistSet) {
        this.m_isCascadePersistSet = isCascadePersistSet;
    }

    public void setSingleTableInheritanceStrategy() {
        this.m_descriptor.getInheritancePolicy().setSingleTableStrategy();
    }

    public boolean shouldIgnoreAnnotations() {
        return this.m_ignoreAnnotations;
    }

    public boolean usesOptimisticLocking() {
        return this.m_descriptor.usesOptimisticLocking();
    }

    public boolean usesPropertyAccess() {
        if (this.isInheritanceSubclass()) {
            return MetadataHelper.usesPropertyAccess(this.getInheritanceRootDmd());
        }
        return MetadataHelper.usesPropertyAccess(this);
    }

    public boolean usesSingleTableInheritanceStrategy() {
        return this.m_usesSingleTableInheritanceStrategy;
    }

    public void validatePKClassId(String attributeName, Type type) {
        if (this.m_pkClassIDs.containsKey(attributeName)) {
            Type expectedType = this.m_pkClassIDs.get(attributeName);
            if (type == expectedType) {
                this.m_pkClassIDs.remove(attributeName);
            } else {
                throw ValidationException.invalidCompositePKAttribute(this.m_javaClass, this.getPKClassName(), attributeName, expectedType, type);
            }
        }
    }
}

