/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.exceptions;

import java.util.Collection;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.i18n.ExceptionMessageGenerator;

public class EJBQLException
extends TopLinkException {
    public static final int recognitionException = 8001;
    public static final int generalParsingException = 8002;
    public static final int classNotFoundException = 8003;
    public static final int aliasResolutionException = 8004;
    public static final int resolutionClassNotFoundException = 8005;
    public static final int missingDescriptorException = 8006;
    public static final int missingMappingException = 8007;
    public static final int invalidContextKeyException = 8008;
    public static final int expressionNotSupported = 8009;
    public static final int generalParsingException2 = 8010;
    public static final int invalidCollectionMemberDecl = 8011;
    public static final int notYetImplemented = 8012;
    public static final int constructorClassNotFound = 8013;
    public static final int invalidSizeArgument = 8014;
    public static final int invalidEnumLiteral = 8015;
    public static final int invalidSelectForGroupByQuery = 8016;
    public static final int invalidHavingExpression = 8017;
    public static final int invalidMultipleUseOfSameParameter = 8018;
    public static final int multipleVariableDeclaration = 8019;
    public static final int invalidFunctionArgument = 8020;
    public static final int expectedOrderableOrderByItem = 8021;
    public static final int invalidExpressionArgument = 8022;
    public static final int syntaxError = 8023;
    public static final int syntaxErrorAt = 8024;
    public static final int unexpectedToken = 8025;
    public static final int unexpectedChar = 8026;
    public static final int expectedCharFound = 8027;
    public static final int unexpectedEOF = 8028;
    public static final int invalidNavigation = 8029;
    public static final int unknownAttribute = 8030;
    public Collection internalExceptions = null;

    protected EJBQLException() {
    }

    protected EJBQLException(String theMessage) {
        super(theMessage);
    }

    protected EJBQLException(String message, Exception internalException) {
        super(message, internalException);
    }

    protected EJBQLException(String message, Exception internalException, int theErrorCode) {
        this(message, internalException);
        this.setErrorCode(theErrorCode);
    }

    public static EJBQLException recognitionException(String theEjbql, String theMessage) {
        Object[] args = new Object[]{theEjbql, theMessage};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8001, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8001);
        return exception;
    }

    public static EJBQLException generalParsingException(String theEjbql, Exception theException) {
        Object[] args = new Object[]{theEjbql, theException.getMessage()};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8002, args);
        EJBQLException exception = new EJBQLException(message, theException, 8002);
        exception.setErrorCode(8002);
        return exception;
    }

    public static EJBQLException generalParsingException(String theEjbql) {
        Object[] args = new Object[]{theEjbql};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8010, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8002);
        return exception;
    }

    public static EJBQLException classNotFoundException(String theClassName, String theMessage, Exception theException) {
        Object[] args = new Object[]{theClassName, theMessage};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8003, args);
        EJBQLException exception = new EJBQLException(message, theException, 8003);
        exception.setErrorCode(8003);
        return exception;
    }

    public static EJBQLException resolutionClassNotFoundException(String theClassName) {
        Object[] args = new Object[]{theClassName};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8005, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8005);
        return exception;
    }

    public static EJBQLException missingDescriptorException(String theClassName) {
        Object[] args = new Object[]{theClassName};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8006, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8006);
        return exception;
    }

    public static EJBQLException missingMappingException(String theAttributeName) {
        Object[] args = new Object[]{theAttributeName};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8007, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8007);
        return exception;
    }

    public static EJBQLException aliasResolutionException(String theAlias) {
        Object[] args = new Object[]{theAlias};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8004, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8004);
        return exception;
    }

    public static EJBQLException invalidContextKeyException(String theKey) {
        Object[] args = new Object[]{theKey};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8008, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8008);
        return exception;
    }

    public static EJBQLException expressionNotSupported(String unsupportedExpression) {
        Object[] args = new Object[]{unsupportedExpression};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8009, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8009);
        return exception;
    }

    public static EJBQLException invalidCollectionMemberDecl(String attributeName) {
        Object[] args = new Object[]{attributeName};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8011, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8011);
        return exception;
    }

    public static EJBQLException notYetImplemented(String detail) {
        Object[] args = new Object[]{detail};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8012, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8012);
        return exception;
    }

    public static EJBQLException constructorClassNotFound(String className) {
        Object[] args = new Object[]{className};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8013, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8013);
        return exception;
    }

    public static EJBQLException invalidSizeArgument(String attributeName) {
        Object[] args = new Object[]{attributeName};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8014, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8014);
        return exception;
    }

    public static EJBQLException invalidEnumLiteral(String enumType, String constant) {
        Object[] args = new Object[]{enumType, constant};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8015, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8015);
        return exception;
    }

    public static EJBQLException invalidSelectForGroupByQuery(String select, String groupBy) {
        Object[] args = new Object[]{select, groupBy};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8016, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8016);
        return exception;
    }

    public static EJBQLException invalidHavingExpression(String having, String groupBy) {
        Object[] args = new Object[]{having, groupBy};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8017, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8017);
        return exception;
    }

    public static EJBQLException invalidMultipleUseOfSameParameter(String parameter, String oldType, String newType) {
        Object[] args = new Object[]{parameter, oldType, newType};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8018, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8018);
        return exception;
    }

    public static EJBQLException multipleVariableDeclaration(String variable, String oldDecl) {
        Object[] args = new Object[]{variable, oldDecl};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8019, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8019);
        return exception;
    }

    public static EJBQLException invalidFunctionArgument(String functionName, String attributeName, String type) {
        Object[] args = new Object[]{functionName, attributeName, type};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8020, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8020);
        return exception;
    }

    public static EJBQLException invalidExpressionArgument(String functionName, String attributeName, String type) {
        Object[] args = new Object[]{functionName, attributeName, type};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8022, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8022);
        return exception;
    }

    public static EJBQLException expectedOrderableOrderByItem(String item, String type) {
        Object[] args = new Object[]{item, type};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8021, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8021);
        return exception;
    }

    public static EJBQLException syntaxError(String query) {
        Object[] args = new Object[]{query};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8023, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8023);
        return exception;
    }

    public static EJBQLException syntaxErrorAt(String query, String token) {
        Object[] args = new Object[]{query, token};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8024, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8024);
        return exception;
    }

    public static EJBQLException unexpectedToken(String query, String token) {
        Object[] args = new Object[]{query, token};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8025, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8025);
        return exception;
    }

    public static EJBQLException unexpectedChar(String query, String unexpected) {
        Object[] args = new Object[]{query, unexpected};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8026, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8026);
        return exception;
    }

    public static EJBQLException expectedCharFound(String query, String expected, String found) {
        Object[] args = new Object[]{query, expected, found};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8027, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8027);
        return exception;
    }

    public static EJBQLException unexpectedEOF(String query) {
        Object[] args = new Object[]{query};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8028, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8028);
        return exception;
    }

    public static EJBQLException invalidNavigation(String expr, String lhs, String type) {
        Object[] args = new Object[]{expr, lhs, type};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8029, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8029);
        return exception;
    }

    public static EJBQLException unknownAttribute(String type, String name) {
        Object[] args = new Object[]{type, name};
        String message = ExceptionMessageGenerator.buildMessage(EJBQLException.class, 8030, args);
        EJBQLException exception = new EJBQLException(message);
        exception.setErrorCode(8030);
        return exception;
    }

    public Object addInternalException(Object theException) {
        this.getInternalExceptions().add(theException);
        return theException;
    }

    public boolean hasInternalExceptions() {
        return !this.getInternalExceptions().isEmpty();
    }

    public Collection getInternalExceptions() {
        if (this.internalExceptions == null) {
            this.setInternalExceptions(new Vector());
        }
        return this.internalExceptions;
    }

    public void setInternalExceptions(Collection theExceptions) {
        this.internalExceptions = theExceptions;
    }

    public void printFullStackTrace() {
        if (this.hasInternalExceptions()) {
            for (Throwable error : this.getInternalExceptions()) {
                error.printStackTrace();
            }
        }
    }
}

