/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.ejb.cmp3.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.toplink.essentials.ejb.cmp3.persistence.SEPersistenceUnitInfo;
import oracle.toplink.essentials.exceptions.PersistenceUnitLoadingException;
import oracle.toplink.essentials.exceptions.XMLParseException;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.PersistenceContentHandler;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.XMLException;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.parser.XMLExceptionHandler;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitProcessor {
    public static List<SEPersistenceUnitInfo> getPersistenceUnits(URL url, ClassLoader loader) {
        return PersistenceUnitProcessor.processPersistenceArchive(url, loader);
    }

    protected static List<SEPersistenceUnitInfo> processPersistenceArchveFromUnconvertableURL(URL baseURL, ClassLoader loader) {
        InputStream stream = null;
        try {
            stream = baseURL.openStream();
            List<SEPersistenceUnitInfo> list = PersistenceUnitProcessor.processPersistenceXML(baseURL, stream, loader);
            return list;
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromUrl(baseURL, exc);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException exc) {}
        }
    }

    private static List<SEPersistenceUnitInfo> processDirectory(URL baseURL, File file, ClassLoader loader) {
        FileInputStream inputStream = null;
        try {
            String filePath = file.getPath();
            File persistenceXMLFile = new File(filePath + File.separator + "META-INF" + File.separator + "persistence.xml");
            if (!persistenceXMLFile.exists()) {
                persistenceXMLFile = new File(filePath + File.separator + "meta-inf" + File.separator + "persistence.xml");
            }
            if (persistenceXMLFile.exists()) {
                inputStream = new FileInputStream(persistenceXMLFile);
                List<SEPersistenceUnitInfo> list = PersistenceUnitProcessor.processPersistenceXML(baseURL, inputStream, loader);
                return list;
            }
            List<SEPersistenceUnitInfo> list = null;
            return list;
        }
        catch (FileNotFoundException exc) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromDirectory(file, exc);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException exc) {}
        }
    }

    protected static List<SEPersistenceUnitInfo> processJarFile(URL baseURL, File file, ClassLoader loader) {
        JarFile jarFile = null;
        InputStream stream = null;
        try {
            jarFile = new JarFile(file);
            ZipEntry entry = jarFile.getEntry("META-INF/persistence.xml");
            if (entry == null) {
                entry = jarFile.getEntry("meta-inf/persistence.xml");
            }
            if (entry != null) {
                stream = jarFile.getInputStream(entry);
                List<SEPersistenceUnitInfo> list = PersistenceUnitProcessor.processPersistenceXML(baseURL, stream, loader);
                return list;
            }
            List<SEPersistenceUnitInfo> list = null;
            return list;
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromJar(file, exc);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException exc) {}
        }
    }

    private static List<SEPersistenceUnitInfo> processPersistenceArchive(URL url, ClassLoader loader) {
        File file = null;
        try {
            URL tempURL = PersistenceUnitProcessor.truncateURL(url);
            file = new File(PersistenceUnitProcessor.convertURLToURI(tempURL));
            if (file.isFile()) {
                return PersistenceUnitProcessor.processJarFile(tempURL, file, loader);
            }
            if (file.isDirectory()) {
                return PersistenceUnitProcessor.processDirectory(tempURL, file, loader);
            }
        }
        catch (IllegalArgumentException e) {
            return PersistenceUnitProcessor.processPersistenceArchveFromUnconvertableURL(url, loader);
        }
        return null;
    }

    public static InputStream createInputStreamForFileInPersistenceUnit(String fileName, PersistenceUnitInfo persistenceUnitInfo, ClassLoader classLoader) throws IOException {
        File file = null;
        try {
            file = new File(PersistenceUnitProcessor.convertURLToURI(persistenceUnitInfo.getPersistenceUnitRootUrl()));
            if (file.isFile()) {
                return PersistenceUnitProcessor.createInputStreamForJarFile(fileName, file);
            }
            if (file.isDirectory()) {
                return PersistenceUnitProcessor.createInputStreamForDirectory(fileName, file);
            }
        }
        catch (IllegalArgumentException e) {
            return PersistenceUnitProcessor.createInputStreamForUnconvertableURL(fileName, persistenceUnitInfo.getPersistenceUnitRootUrl(), classLoader);
        }
        return null;
    }

    public static InputStream createInputStreamForJarFile(String fileName, File inputFile) throws IOException {
        JarFile jarFile = null;
        Object stream = null;
        jarFile = new JarFile(inputFile);
        ZipEntry entry = jarFile.getEntry(fileName);
        if (entry != null) {
            return jarFile.getInputStream(entry);
        }
        return null;
    }

    public static InputStream createInputStreamForDirectory(String fileName, File inputFile) throws IOException {
        File xmlFile;
        String filePath = inputFile.getPath();
        String tempFileName = fileName;
        if (!filePath.endsWith(File.separator) && !fileName.startsWith(File.separator)) {
            tempFileName = File.separator + tempFileName;
        }
        if ((xmlFile = new File(filePath + tempFileName)).exists()) {
            return new FileInputStream(xmlFile);
        }
        return null;
    }

    public static InputStream createInputStreamForUnconvertableURL(String fileName, URL url, ClassLoader loader) throws IOException {
        String persistenceUnitRoolUrlString = url.toString();
        Enumeration<URL> resources = loader.getResources(fileName);
        while (resources.hasMoreElements()) {
            URL mappingFileResource = resources.nextElement();
            String mappingFileResourceString = mappingFileResource.toString();
            if (!mappingFileResourceString.contains(persistenceUnitRoolUrlString)) continue;
            return url.openStream();
        }
        return null;
    }

    public static List<SEPersistenceUnitInfo> processPersistenceXML(URL baseURL, InputStream input, ClassLoader loader) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(true);
        XMLReader xmlReader = null;
        SAXParser sp = null;
        XMLExceptionHandler xmlErrorHandler = new XMLExceptionHandler();
        try {
            sp = spf.newSAXParser();
            sp.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (ParserConfigurationException exc) {
            throw XMLParseException.exceptionCreatingSAXParser(baseURL, exc);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingSAXParser(baseURL, exc);
        }
        try {
            xmlReader = sp.getXMLReader();
            xmlReader.setErrorHandler(xmlErrorHandler);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingXMLReader(baseURL, exc);
        }
        URL schemaURL = loader.getResource("persistence_1_0.xsd");
        if (schemaURL != null) {
            try {
                sp.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaURL.toString());
            }
            catch (SAXException exc) {
                throw XMLParseException.exceptionSettingSchemaSource(baseURL, schemaURL, exc);
            }
        }
        PersistenceContentHandler myContentHandler = new PersistenceContentHandler();
        xmlReader.setContentHandler(myContentHandler);
        InputSource inputSource = new InputSource(input);
        try {
            xmlReader.parse(inputSource);
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, exc);
        }
        catch (SAXException exc) {
            // empty catch block
        }
        XMLException xmlError = xmlErrorHandler.getXMLException();
        if (xmlError != null) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML(baseURL, xmlError);
        }
        for (SEPersistenceUnitInfo info : myContentHandler.getPersistenceUnits()) {
            info.setPersistenceUnitRootUrl(baseURL);
        }
        return myContentHandler.getPersistenceUnits();
    }

    private static URL truncateURL(URL url) {
        try {
            String newURLString = url.toString().substring(0, url.toString().length() - 25);
            if (newURLString.endsWith("!")) {
                newURLString = newURLString.substring(0, newURLString.length() - 1);
            }
            if (newURLString.startsWith("jar:")) {
                newURLString = newURLString.substring(4, newURLString.length());
            }
            return new URL(newURLString);
        }
        catch (MalformedURLException exc) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromUrl(url, exc);
        }
    }

    public static String buildClassNameFromEntryString(String classEntryString) {
        String classNameForLoader = classEntryString;
        if (classEntryString.endsWith(".class")) {
            classNameForLoader = classNameForLoader.substring(0, classNameForLoader.length() - 6);
            classNameForLoader = classNameForLoader.replace("/", ".");
        }
        return classNameForLoader;
    }

    public static Set<String> buildClassSet(PersistenceUnitInfo persistenceUnitInfo) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(persistenceUnitInfo.getManagedClassNames());
        Iterator<URL> i = persistenceUnitInfo.getJarFileUrls().iterator();
        while (i.hasNext()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL(i.next()));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl()));
        }
        return set;
    }

    public static Set<String> buildPersistentClassSet(PersistenceUnitInfo persistenceUnitInfo, ClassLoader loader) {
        HashSet<String> set = new HashSet<String>();
        for (String className : persistenceUnitInfo.getManagedClassNames()) {
            if (!PersistenceUnitProcessor.isClassPersistent(className, loader)) continue;
            set.add(className);
        }
        Iterator<URL> i = persistenceUnitInfo.getJarFileUrls().iterator();
        while (i.hasNext()) {
            set.addAll(PersistenceUnitProcessor.getPersistentClassNamesFromURL(i.next(), loader));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            set.addAll(PersistenceUnitProcessor.getPersistentClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl(), loader));
        }
        return set;
    }

    protected static List<String> findClassesInDirectory(File directory, int leadingCharactersToRemove) {
        File[] files;
        Vector<String> classes = new Vector<String>();
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(PersistenceUnitProcessor.findClassesInDirectory(file, leadingCharactersToRemove));
            }
            if (!file.isFile() || !file.getName().endsWith(".class")) continue;
            String className = file.getPath().substring(leadingCharactersToRemove + 1, file.getPath().length() - 6);
            className = className.replace("/", ".");
            className = className.replace("\\", ".");
            classes.add(className);
        }
        return classes;
    }

    public static Set<URL> findPersistenceArchives() {
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        return PersistenceUnitProcessor.findPersistenceArchives(threadLoader);
    }

    public static Set<URL> findPersistenceArchives(ClassLoader loader) {
        HashSet<URL> parURLs = new HashSet<URL>();
        try {
            Enumeration<URL> resources = loader.getResources("META-INF/persistence.xml");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                parURLs.add(url);
            }
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources(loader, exc);
        }
        return parURLs;
    }

    private static List<String> getClassNamesFromJar(File file) {
        Vector<String> persistentClasses = new Vector<String>();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String classNameForLoader = PersistenceUnitProcessor.buildClassNameFromEntryString(entry.getName());
                if (!entry.getName().endsWith(".class")) continue;
                persistentClasses.add(classNameForLoader);
            }
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionSearchingForEntities(file, exc);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException exc) {}
        }
        return persistentClasses;
    }

    private static List<String> getClassNamesFromURL(URL url) {
        File file = new File(PersistenceUnitProcessor.convertURLToURI(url));
        if (file.isDirectory()) {
            return PersistenceUnitProcessor.getClassNamesFromDirectory(file);
        }
        return PersistenceUnitProcessor.getClassNamesFromJar(file);
    }

    private static List<String> getClassNamesFromDirectory(File file) {
        List<String> classList = null;
        if (!file.isDirectory()) {
            return null;
        }
        int initialDirectoryNameLength = file.getPath().length();
        classList = PersistenceUnitProcessor.findClassesInDirectory(file, initialDirectoryNameLength);
        return classList;
    }

    public static List<String> getPersistentClassNamesFromDirectory(File file, ClassLoader loader) {
        Vector<String> persistentClasses = new Vector<String>();
        List<String> classList = PersistenceUnitProcessor.getClassNamesFromDirectory(file);
        for (String className : classList) {
            if (!PersistenceUnitProcessor.isClassPersistent(className, loader)) continue;
            persistentClasses.add(className);
        }
        return persistentClasses;
    }

    public static List getPersistentClassNamesFromURL(URL url, ClassLoader loader) {
        File file = new File(PersistenceUnitProcessor.convertURLToURI(url));
        if (file.isDirectory()) {
            return PersistenceUnitProcessor.getPersistentClassNamesFromDirectory(file, loader);
        }
        return PersistenceUnitProcessor.getPersistentClassNamesFromJar(file, loader);
    }

    public static List<String> getPersistentClassNamesFromJar(File file, ClassLoader loader) {
        Vector<String> persistentClasses = new Vector<String>();
        List<String> classList = PersistenceUnitProcessor.getClassNamesFromJar(file);
        for (String className : classList) {
            if (!PersistenceUnitProcessor.isClassPersistent(className, loader)) continue;
            persistentClasses.add(className);
        }
        return persistentClasses;
    }

    public static boolean isClassPersistent(String className, ClassLoader loader) {
        Class<?> candidateClass = null;
        try {
            candidateClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException exc) {
            throw PersistenceUnitLoadingException.exceptionLoadingClassWhileLookingForAnnotations(className, exc);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            AbstractSessionLog.getLog().log(6, "no_class_def_found_error", noClassDefFoundError.getClass().getName(), className);
            return false;
        }
        return PersistenceUnitProcessor.isClassPersistent(candidateClass);
    }

    public static boolean isClassPersistent(Class candidateClass) {
        return candidateClass.isAnnotationPresent(Entity.class) || candidateClass.isAnnotationPresent(Embeddable.class);
    }

    private static URI convertURLToURI(URL url) {
        String filePath = url.getFile();
        if (filePath.equals("") || filePath == null) {
            throw PersistenceUnitLoadingException.filePathMissingException(filePath);
        }
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceUnit(url, e);
        }
        return uri;
    }
}

