/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class OutputMessageRenderer
extends HtmlBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        String currentValue = null;
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since rendered attribute is set to false");
            }
            return;
        }
        Object currentObj = ((ValueHolder)component).getValue();
        if (currentObj != null) {
            currentValue = currentObj instanceof String ? (String)currentObj : currentObj.toString();
        } else {
            return;
        }
        ArrayList<Object> parameterList = new ArrayList<Object>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            parameterList.add(((UIParameter)kid).getValue());
        }
        String message = null;
        message = parameterList.size() > 0 ? MessageFormat.format(currentValue, parameterList.toArray(new Object[parameterList.size()])) : currentValue;
        boolean wroteSpan = false;
        if (null != styleClass || null != style || RenderKitUtils.hasPassThruAttributes(component) || this.shouldWriteIdAttribute(component)) {
            writer.startElement("span", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            wroteSpan = true;
            if (null != styleClass) {
                writer.writeAttribute("class", (Object)styleClass, "styleClass");
            }
            RenderKitUtils.renderPassThruAttributes(context, writer, component);
        }
        Boolean escape = Boolean.TRUE;
        Object val = component.getAttributes().get("escape");
        if (val != null) {
            if (val instanceof Boolean) {
                escape = (Boolean)val;
            } else if (val instanceof String) {
                try {
                    escape = Boolean.valueOf((String)val);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        if (escape.booleanValue()) {
            writer.writeText((Object)message, component, "value");
        } else {
            writer.write(message);
        }
        if (wroteSpan) {
            writer.endElement("span");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }
}

