/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.util.MessageFactory;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

public abstract class HtmlBasicRenderer
extends Renderer {
    protected static final Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.renderkit");
    public static final String SCRIPT_ELEMENT = "script";
    public static final String SCRIPT_LANGUAGE = "language";
    public static final String SCRIPT_TYPE = "type";
    public static final String SCRIPT_LANGUAGE_JAVASCRIPT = "JavaScript";
    public static final String CLEAR_HIDDEN_FIELD_FN_NAME = "clearFormHiddenParams";
    static final String DID_RENDER_SCRIPT = "com.sun.faces.didRenderScript";
    static final String RENDERED_HIDDEN_FIELDS = "com.sun.faces.renderedHiddenFields";

    public void addGenericErrorMessage(FacesContext facesContext, UIComponent component, String messageId, String param) {
        Object[] params = new Object[3];
        params[0] = param;
        facesContext.addMessage(component.getClientId(facesContext), MessageFactory.getMessage(facesContext, messageId, params));
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin decoding component " + component.getId());
        }
        if (!(component instanceof UIInput)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIInput");
            }
            return;
        }
        if (Util.componentIsDisabledOrReadonly(component)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No decoding necessary since the component " + component.getId() + " is disabled");
            }
            return;
        }
        String clientId = component.getClientId(context);
        assert (clientId != null);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        if (requestMap.containsKey(clientId)) {
            String newValue = (String)requestMap.get(clientId);
            this.setSubmittedValue(component, newValue);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("new value after decoding" + newValue);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End decoding component " + component.getId());
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String currentValue = null;
        ResponseWriter writer = null;
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("End encoding component " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        writer = context.getResponseWriter();
        assert (writer != null);
        currentValue = this.getCurrentValue(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Value to be rendered " + currentValue);
        }
        this.getEndTextToRender(context, component, currentValue);
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator kids = this.getChildren(component);
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                this.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }

    protected Iterator getChildren(UIComponent component) {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            return new RenderedChildIterator(component.getChildren().iterator());
        }
        return Collections.EMPTY_LIST.iterator();
    }

    protected String getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof UIInput && (submittedValue = ((UIInput)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        String currentValue = null;
        Object currentObj = this.getValue(component);
        if (currentObj != null) {
            currentValue = this.getFormattedValue(context, component, currentObj);
        }
        return currentValue;
    }

    protected Object getValue(UIComponent component) {
        throw new UnsupportedOperationException();
    }

    protected void getEndTextToRender(FacesContext context, UIComponent component, String currentValue) throws IOException {
    }

    protected void setSubmittedValue(UIComponent component, Object value) {
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        String result = null;
        if (!(component instanceof ValueHolder)) {
            if (currentValue != null) {
                result = currentValue.toString();
            }
            return result;
        }
        Converter converter = null;
        converter = ((ValueHolder)component).getConverter();
        if (converter == null && currentValue == null) {
            return "";
        }
        if (converter == null) {
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = Util.getConverterForClass(converterType, context);
            if (converter == null) {
                result = currentValue.toString();
                return result;
            }
        }
        return converter.getAsString(context, component, currentValue);
    }

    public String convertClientId(FacesContext context, String clientId) {
        return clientId;
    }

    protected Iterator getMessageIter(FacesContext context, String forComponent, UIComponent component) {
        UIComponent result;
        Iterator messageIter = null;
        messageIter = null != forComponent ? (forComponent.length() == 0 ? context.getMessages(null) : ((result = this.getForComponent(context, forComponent, component)) == null ? Collections.EMPTY_LIST.iterator() : context.getMessages(result.getClientId(context)))) : context.getMessages();
        return messageIter;
    }

    protected UIComponent getForComponent(FacesContext context, String forComponent, UIComponent component) {
        if (null == forComponent || forComponent.length() == 0) {
            return null;
        }
        UIComponent result = null;
        try {
            for (UIComponent currentParent = component; currentParent != null && (result = currentParent.findComponent(forComponent)) == null; currentParent = currentParent.getParent()) {
            }
            if (result == null) {
                result = this.findUIComponentBelow((UIComponent)context.getViewRoot(), forComponent);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (result == null && logger.isLoggable(Level.WARNING)) {
            logger.warning(MessageUtils.getExceptionMessageString("com.sun.faces.COMPONENT_NOT_FOUND_IN_VIEW_WARNING", forComponent));
        }
        return result;
    }

    private UIComponent findUIComponentBelow(UIComponent startPoint, String forComponent) {
        UIComponent retComp = null;
        List children = startPoint.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            UIComponent comp = (UIComponent)children.get(i);
            if (comp instanceof NamingContainer) {
                try {
                    retComp = comp.findComponent(forComponent);
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
            }
            if (retComp == null && comp.getChildCount() > 0) {
                retComp = this.findUIComponentBelow(comp, forComponent);
            }
            if (retComp != null) break;
        }
        return retComp;
    }

    protected UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = component.getFacet(name);
        if (facet != null && !facet.isRendered()) {
            facet = null;
        }
        return facet;
    }

    protected boolean shouldWriteIdAttribute(UIComponent component) {
        String id = component.getId();
        return null != id && !id.startsWith("j_id");
    }

    protected String writeIdAttributeIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component) {
        String id;
        block3: {
            id = null;
            if (this.shouldWriteIdAttribute(component)) {
                try {
                    id = component.getClientId(context);
                    writer.writeAttribute("id", (Object)id, "id");
                }
                catch (IOException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    String message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_WRITE_ID_ATTRIBUTE", e.getMessage());
                    logger.warning(message);
                }
            }
        }
        return id;
    }

    protected Param[] getParamList(FacesContext context, UIComponent command) {
        ArrayList<Param> parameterList = new ArrayList<Param>();
        for (UIComponent kid : command.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            UIParameter uiParam = (UIParameter)kid;
            Object value = uiParam.getValue();
            Param param = new Param(uiParam.getName(), value == null ? null : value.toString());
            parameterList.add(param);
        }
        return parameterList.toArray(new Param[parameterList.size()]);
    }

    private static class RenderedChildIterator
    implements Iterator {
        Iterator childIterator;
        boolean hasNext;
        Object child;

        private RenderedChildIterator(Iterator childIterator) {
            this.childIterator = childIterator;
            this.update();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Object next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Object temp = this.child;
            this.update();
            return temp;
        }

        private void update() {
            while (this.childIterator.hasNext()) {
                UIComponent comp = (UIComponent)this.childIterator.next();
                if (!comp.isRendered()) continue;
                this.child = comp;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
            this.child = null;
        }
    }

    protected static class Param {
        private String name;
        private String value;

        public Param(String name, String value) {
            this.set(name, value);
        }

        public void set(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

