/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.spi.ManagedBeanFactory;
import com.sun.faces.util.Util;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class WebappLifecycleListener
implements ServletRequestListener,
HttpSessionListener,
ServletRequestAttributeListener,
HttpSessionAttributeListener,
ServletContextAttributeListener,
ServletContextListener {
    private static final Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.application");
    private ServletContext servletContext;

    public void requestDestroyed(ServletRequestEvent event) {
        ServletRequest request = event.getServletRequest();
        Enumeration e = request.getAttributeNames();
        while (e.hasMoreElements()) {
            String beanName = (String)e.nextElement();
            this.handleAttributeEvent(beanName, request.getAttribute(beanName), ManagedBeanFactory.Scope.REQUEST);
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String beanName = (String)e.nextElement();
            this.handleAttributeEvent(beanName, session.getAttribute(beanName), ManagedBeanFactory.Scope.SESSION);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent srae) {
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        this.handleAttributeEvent(event.getName(), event.getValue(), ManagedBeanFactory.Scope.REQUEST);
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        String attrName = event.getName();
        Object newValue = event.getServletRequest().getAttribute(attrName);
        if (event.getValue() != newValue) {
            this.handleAttributeEvent(attrName, event.getValue(), ManagedBeanFactory.Scope.REQUEST);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent se) {
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        this.handleAttributeEvent(event.getName(), event.getValue(), ManagedBeanFactory.Scope.SESSION);
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        HttpSession session = event.getSession();
        String attrName = event.getName();
        Object newValue = session.getAttribute(attrName);
        if (event.getValue() != newValue) {
            this.handleAttributeEvent(attrName, event.getValue(), ManagedBeanFactory.Scope.SESSION);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent scab) {
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        this.handleAttributeEvent(event.getName(), event.getValue(), ManagedBeanFactory.Scope.APPLICATION);
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        ServletContext context = event.getServletContext();
        String attrName = event.getName();
        Object newValue = context.getAttribute(attrName);
        if (event.getValue() != newValue) {
            this.handleAttributeEvent(attrName, event.getValue(), ManagedBeanFactory.Scope.APPLICATION);
        }
    }

    private void handleAttributeEvent(String beanName, Object bean, ManagedBeanFactory.Scope scope) {
        block6: {
            ApplicationAssociate associate = ApplicationAssociate.getInstance(this.servletContext);
            try {
                if (associate != null) {
                    associate.handlePreDestroy(beanName, bean, scope);
                }
            }
            catch (Exception e) {
                String className = e.getClass().getName();
                String message = e.getMessage();
                if (e instanceof InvocationTargetException) {
                    Throwable root = ((InvocationTargetException)e).getTargetException();
                    className = root.getClass().getName();
                    message = root.getMessage();
                }
                if (message == null) {
                    message = "";
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "jsf.config.listener.predestroy.error", new Object[]{className, beanName, scope, message});
                }
                if (!LOGGER.isLoggable(Level.FINE)) break block6;
                FastStringWriter writer = new FastStringWriter(128);
                e.printStackTrace(new PrintWriter(writer));
                LOGGER.fine(writer.toString());
            }
        }
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.servletContext = sce.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent event) {
        Enumeration e = this.servletContext.getAttributeNames();
        while (e.hasMoreElements()) {
            String beanName = (String)e.nextElement();
            this.handleAttributeEvent(beanName, this.servletContext.getAttribute(beanName), ManagedBeanFactory.Scope.APPLICATION);
        }
    }
}

