/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.util.Util;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.faces.FacesException;

public final class ByteArrayGuard {
    private static final Logger logger = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.renderkit");
    private static final int DEFAULT_IV_LENGTH = 8;
    private static final int DEFAULT_KEY_LENGTH = 24;
    private static final int DEFAULT_MAC_LENGTH = 20;
    private final Object decLock = new Object();
    private final Object encLock = new Object();
    private final int ivLength;
    private final int keyLength;
    private final int macLength;
    private Cipher decryptCipher = null;
    private Cipher encryptCipher = null;
    private SecretKeyFactory keygen = null;
    private SecureRandom prng = null;
    private byte[] PASSWORD_KEY = null;
    private byte[] iVector = null;

    private ByteArrayGuard(int keyLength, int macLength, int ivLength, String password) {
        this.keyLength = keyLength;
        this.macLength = macLength;
        this.ivLength = ivLength;
        if (password != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Client state saving encryption enabled.");
            }
            this.PASSWORD_KEY = this.convertPasswordToKey(password.getBytes());
            try {
                this.prng = SecureRandom.getInstance("SHA1PRNG");
                this.keygen = SecretKeyFactory.getInstance("DESede");
                this.encryptCipher = this.getBlockCipherForEncryption(this.PASSWORD_KEY);
                this.iVector = this.encryptCipher.getIV();
                this.decryptCipher = this.getBlockCipherForDecryption(this.PASSWORD_KEY, this.iVector);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", e);
                }
                this.PASSWORD_KEY = null;
                this.keygen = null;
                this.encryptCipher = null;
                this.decryptCipher = null;
                this.iVector = null;
                this.prng = null;
            }
        }
    }

    public static ByteArrayGuard newInstance() {
        return new ByteArrayGuard(24, 20, 8, null);
    }

    public static ByteArrayGuard newInstance(String password) {
        return new ByteArrayGuard(24, 20, 8, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] securedata) {
        if (this.PASSWORD_KEY != null) {
            try {
                byte[] macBytes = new byte[this.macLength];
                System.arraycopy(securedata, 0, macBytes, 0, macBytes.length);
                byte[] iv = new byte[this.ivLength];
                System.arraycopy(securedata, macBytes.length, iv, 0, iv.length);
                byte[] encdata = new byte[securedata.length - macBytes.length - iv.length];
                System.arraycopy(securedata, macBytes.length + iv.length, encdata, 0, encdata.length);
                Mac mac = this.getMac(this.PASSWORD_KEY);
                mac.update(encdata);
                byte[] macBytesCalculated = mac.doFinal();
                if (Arrays.equals(macBytes, macBytesCalculated)) {
                    Object object = this.decLock;
                    synchronized (object) {
                        return this.decryptCipher.doFinal(encdata);
                    }
                }
                throw new IOException("Could not Decrypt Secure View State, passwords did not match.");
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, e.getMessage(), e.getCause());
                }
                throw new FacesException((Throwable)e);
            }
        }
        return securedata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] plaindata) {
        if (this.PASSWORD_KEY != null) {
            try {
                byte[] encdata;
                Object object = this.encLock;
                synchronized (object) {
                    encdata = this.encryptCipher.doFinal(plaindata);
                }
                Mac mac = this.getMac(this.PASSWORD_KEY);
                mac.update(encdata);
                byte[] macBytes = mac.doFinal();
                byte[] tmp = ByteArrayGuard.concatBytes(macBytes, this.iVector);
                return ByteArrayGuard.concatBytes(tmp, encdata);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, e.getMessage(), e.getCause());
                }
                throw new FacesException((Throwable)e);
            }
        }
        return plaindata;
    }

    private static byte[] concatBytes(byte[] array1, byte[] array2) {
        byte[] cBytes = new byte[array1.length + array2.length];
        try {
            System.arraycopy(array1, 0, cBytes, 0, array1.length);
            System.arraycopy(array2, 0, cBytes, array1.length, array2.length);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        return cBytes;
    }

    private byte[] convertPasswordToKey(byte[] password) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] seed = md.digest(password);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(seed);
            byte[] rawkey = new byte[this.keyLength];
            random.nextBytes(rawkey);
            return rawkey;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private Cipher getBlockCipherForDecryption(byte[] rawKey, byte[] iv) {
        try {
            DESedeKeySpec keyspec = new DESedeKeySpec(rawKey);
            SecretKey key = this.keygen.generateSecret(keyspec);
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            cipher.init(2, (Key)key, ivspec, this.prng);
            return cipher;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private Cipher getBlockCipherForEncryption(byte[] rawKey) {
        try {
            DESedeKeySpec keyspec = new DESedeKeySpec(rawKey);
            SecretKey key = this.keygen.generateSecret(keyspec);
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            byte[] iv = new byte[this.ivLength];
            this.prng.nextBytes(iv);
            IvParameterSpec ivspec = new IvParameterSpec(iv);
            cipher.init(1, (Key)key, ivspec, this.prng);
            return cipher;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private Mac getMac(byte[] rawKey) {
        try {
            Mac lMac = Mac.getInstance("HmacSHA1");
            SecretKeySpec key = new SecretKeySpec(rawKey, 0, this.macLength, "HmacSHA1");
            lMac.init(key);
            return lMac;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }
}

