/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

class SessionMap
extends BaseContextMap {
    private final HttpServletRequest request;

    SessionMap(HttpServletRequest request) {
        this.request = request;
    }

    public void clear() {
        HttpSession session = this.getSession();
        String name = null;
        Enumeration e = this.getSession().getAttributeNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            session.removeAttribute(name);
        }
    }

    public void putAll(Map t) {
        HttpSession session = this.getSession();
        for (Map.Entry entry : t.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.getSession().getAttribute(key.toString());
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        String keyString = key.toString();
        HttpSession session = this.getSession();
        Object result = session.getAttribute(keyString);
        session.setAttribute(keyString, value);
        return result;
    }

    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        HttpSession session = this.getSession();
        Object result = session.getAttribute(keyString);
        session.removeAttribute(keyString);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SessionMap)) {
            return false;
        }
        return super.equals(obj);
    }

    private HttpSession getSession() {
        return this.request.getSession(true);
    }

    public int hashCode() {
        int hashCode = 7 * this.request.getSession().hashCode();
        Iterator<? extends Object> i = this.entrySet().iterator();
        while (i.hasNext()) {
            hashCode += i.next().hashCode();
        }
        return hashCode;
    }

    protected Iterator getEntryIterator() {
        return new BaseContextMap.EntryIterator(this.getSession().getAttributeNames());
    }

    protected Iterator getKeyIterator() {
        return new BaseContextMap.KeyIterator(this.getSession().getAttributeNames());
    }

    protected Iterator getValueIterator() {
        return new BaseContextMap.ValueIterator(this.getSession().getAttributeNames());
    }
}

