/**
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at
 * https://javaserverfaces.dev.java.net/CDDL.html or
 * legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permission and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * [Name of File] [ver.__] [Date]
 * 
 * Copyright 2006 Sun Microsystems Inc. All Rights Reserved
 */
package javax.faces.component.html;

import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

import javax.faces.context.FacesContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;


/*
 * ******* GENERATED CODE - DO NOT EDIT *******
 */


/**
 * <p>Represents an HTML <code>img</code> element, used to retrieve
 * and render a graphical image.</p>
 * <p>By default, the <code>rendererType</code> property must be set to "<code>javax.faces.Image</code>".
 * This value can be changed by calling the <code>setRendererType()</code> method.</p>
 */
public class HtmlGraphicImage extends javax.faces.component.UIGraphic {



    public HtmlGraphicImage() {
        super();
        setRendererType("javax.faces.Image");
    }


    /**
     * <p>The standard component type for this component.</p>
     */
    public static final String COMPONENT_TYPE = "javax.faces.HtmlGraphicImage";


    private java.lang.String alt;

    /**
     * <p>Return the value of the <code>alt</code> property.</p>
     * <p>Contents: Alternate textual description of the
     * element rendered by this component.
     */
    public java.lang.String getAlt() {
        if (null != this.alt) {
            return this.alt;
        }
        ValueExpression _ve = getValueExpression("alt");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>alt</code> property.</p>
     */
    public void setAlt(java.lang.String alt) {
        this.alt = alt;
    }


    private java.lang.String dir;

    /**
     * <p>Return the value of the <code>dir</code> property.</p>
     * <p>Contents: Direction indication for text that does not inherit directionality.
     * Valid values are "LTR" (left-to-right) and "RTL" (right-to-left).
     */
    public java.lang.String getDir() {
        if (null != this.dir) {
            return this.dir;
        }
        ValueExpression _ve = getValueExpression("dir");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>dir</code> property.</p>
     */
    public void setDir(java.lang.String dir) {
        this.dir = dir;
    }


    private java.lang.String height;

    /**
     * <p>Return the value of the <code>height</code> property.</p>
     * <p>Contents: Override for the height of this image.
     */
    public java.lang.String getHeight() {
        if (null != this.height) {
            return this.height;
        }
        ValueExpression _ve = getValueExpression("height");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>height</code> property.</p>
     */
    public void setHeight(java.lang.String height) {
        this.height = height;
    }


    private boolean ismap = false;
    private boolean ismap_set = false;

    /**
     * <p>Return the value of the <code>ismap</code> property.</p>
     * <p>Contents: Flag indicating that this image is to be used as a server side
     * image map.  Such an image must be enclosed within a hyperlink
     * ("a").  A value of false causes no attribute to be rendered,
     * while a value of true causes the attribute to be rendered as
     * ismap="ismap".
     */
    public boolean isIsmap() {
        if (this.ismap_set) {
            return this.ismap;
        }
        ValueExpression _ve = getValueExpression("ismap");
        if (_ve != null) {
            Object _result = _ve.getValue(getFacesContext().getELContext());
            if (_result == null) {
                return false;
            } else {
                return ((java.lang.Boolean) _result).booleanValue();
            }
        } else {
            return this.ismap;
        }
    }

    /**
     * <p>Set the value of the <code>ismap</code> property.</p>
     */
    public void setIsmap(boolean ismap) {
        this.ismap = ismap;
        this.ismap_set = true;
    }


    private java.lang.String lang;

    /**
     * <p>Return the value of the <code>lang</code> property.</p>
     * <p>Contents: Code describing the language used in the generated markup
     * for this component.
     */
    public java.lang.String getLang() {
        if (null != this.lang) {
            return this.lang;
        }
        ValueExpression _ve = getValueExpression("lang");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>lang</code> property.</p>
     */
    public void setLang(java.lang.String lang) {
        this.lang = lang;
    }


    private java.lang.String longdesc;

    /**
     * <p>Return the value of the <code>longdesc</code> property.</p>
     * <p>Contents: URI to a long description of the image
     * represented by this element.
     */
    public java.lang.String getLongdesc() {
        if (null != this.longdesc) {
            return this.longdesc;
        }
        ValueExpression _ve = getValueExpression("longdesc");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>longdesc</code> property.</p>
     */
    public void setLongdesc(java.lang.String longdesc) {
        this.longdesc = longdesc;
    }


    private java.lang.String onclick;

    /**
     * <p>Return the value of the <code>onclick</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * clicked over this element.
     */
    public java.lang.String getOnclick() {
        if (null != this.onclick) {
            return this.onclick;
        }
        ValueExpression _ve = getValueExpression("onclick");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onclick</code> property.</p>
     */
    public void setOnclick(java.lang.String onclick) {
        this.onclick = onclick;
    }


    private java.lang.String ondblclick;

    /**
     * <p>Return the value of the <code>ondblclick</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * double clicked over this element.
     */
    public java.lang.String getOndblclick() {
        if (null != this.ondblclick) {
            return this.ondblclick;
        }
        ValueExpression _ve = getValueExpression("ondblclick");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>ondblclick</code> property.</p>
     */
    public void setOndblclick(java.lang.String ondblclick) {
        this.ondblclick = ondblclick;
    }


    private java.lang.String onkeydown;

    /**
     * <p>Return the value of the <code>onkeydown</code> property.</p>
     * <p>Contents: Javascript code executed when a key is
     * pressed down over this element.
     */
    public java.lang.String getOnkeydown() {
        if (null != this.onkeydown) {
            return this.onkeydown;
        }
        ValueExpression _ve = getValueExpression("onkeydown");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onkeydown</code> property.</p>
     */
    public void setOnkeydown(java.lang.String onkeydown) {
        this.onkeydown = onkeydown;
    }


    private java.lang.String onkeypress;

    /**
     * <p>Return the value of the <code>onkeypress</code> property.</p>
     * <p>Contents: Javascript code executed when a key is
     * pressed and released over this element.
     */
    public java.lang.String getOnkeypress() {
        if (null != this.onkeypress) {
            return this.onkeypress;
        }
        ValueExpression _ve = getValueExpression("onkeypress");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onkeypress</code> property.</p>
     */
    public void setOnkeypress(java.lang.String onkeypress) {
        this.onkeypress = onkeypress;
    }


    private java.lang.String onkeyup;

    /**
     * <p>Return the value of the <code>onkeyup</code> property.</p>
     * <p>Contents: Javascript code executed when a key is
     * released over this element.
     */
    public java.lang.String getOnkeyup() {
        if (null != this.onkeyup) {
            return this.onkeyup;
        }
        ValueExpression _ve = getValueExpression("onkeyup");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onkeyup</code> property.</p>
     */
    public void setOnkeyup(java.lang.String onkeyup) {
        this.onkeyup = onkeyup;
    }


    private java.lang.String onmousedown;

    /**
     * <p>Return the value of the <code>onmousedown</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * pressed down over this element.
     */
    public java.lang.String getOnmousedown() {
        if (null != this.onmousedown) {
            return this.onmousedown;
        }
        ValueExpression _ve = getValueExpression("onmousedown");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmousedown</code> property.</p>
     */
    public void setOnmousedown(java.lang.String onmousedown) {
        this.onmousedown = onmousedown;
    }


    private java.lang.String onmousemove;

    /**
     * <p>Return the value of the <code>onmousemove</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * moved within this element.
     */
    public java.lang.String getOnmousemove() {
        if (null != this.onmousemove) {
            return this.onmousemove;
        }
        ValueExpression _ve = getValueExpression("onmousemove");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmousemove</code> property.</p>
     */
    public void setOnmousemove(java.lang.String onmousemove) {
        this.onmousemove = onmousemove;
    }


    private java.lang.String onmouseout;

    /**
     * <p>Return the value of the <code>onmouseout</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * moved away from this element.
     */
    public java.lang.String getOnmouseout() {
        if (null != this.onmouseout) {
            return this.onmouseout;
        }
        ValueExpression _ve = getValueExpression("onmouseout");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmouseout</code> property.</p>
     */
    public void setOnmouseout(java.lang.String onmouseout) {
        this.onmouseout = onmouseout;
    }


    private java.lang.String onmouseover;

    /**
     * <p>Return the value of the <code>onmouseover</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * moved onto this element.
     */
    public java.lang.String getOnmouseover() {
        if (null != this.onmouseover) {
            return this.onmouseover;
        }
        ValueExpression _ve = getValueExpression("onmouseover");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmouseover</code> property.</p>
     */
    public void setOnmouseover(java.lang.String onmouseover) {
        this.onmouseover = onmouseover;
    }


    private java.lang.String onmouseup;

    /**
     * <p>Return the value of the <code>onmouseup</code> property.</p>
     * <p>Contents: Javascript code executed when a pointer button is
     * released over this element.
     */
    public java.lang.String getOnmouseup() {
        if (null != this.onmouseup) {
            return this.onmouseup;
        }
        ValueExpression _ve = getValueExpression("onmouseup");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>onmouseup</code> property.</p>
     */
    public void setOnmouseup(java.lang.String onmouseup) {
        this.onmouseup = onmouseup;
    }


    private java.lang.String style;

    /**
     * <p>Return the value of the <code>style</code> property.</p>
     * <p>Contents: CSS style(s) to be applied when this component is rendered.
     */
    public java.lang.String getStyle() {
        if (null != this.style) {
            return this.style;
        }
        ValueExpression _ve = getValueExpression("style");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>style</code> property.</p>
     */
    public void setStyle(java.lang.String style) {
        this.style = style;
    }


    private java.lang.String styleClass;

    /**
     * <p>Return the value of the <code>styleClass</code> property.</p>
     * <p>Contents: Space-separated list of CSS style class(es) to be applied when
     * this element is rendered.  This value must be passed through
     * as the "class" attribute on generated markup.
     */
    public java.lang.String getStyleClass() {
        if (null != this.styleClass) {
            return this.styleClass;
        }
        ValueExpression _ve = getValueExpression("styleClass");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>styleClass</code> property.</p>
     */
    public void setStyleClass(java.lang.String styleClass) {
        this.styleClass = styleClass;
    }


    private java.lang.String title;

    /**
     * <p>Return the value of the <code>title</code> property.</p>
     * <p>Contents: Advisory title information about markup elements generated
     * for this component.
     */
    public java.lang.String getTitle() {
        if (null != this.title) {
            return this.title;
        }
        ValueExpression _ve = getValueExpression("title");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>title</code> property.</p>
     */
    public void setTitle(java.lang.String title) {
        this.title = title;
    }


    private java.lang.String usemap;

    /**
     * <p>Return the value of the <code>usemap</code> property.</p>
     * <p>Contents: The name of a client side image map (an HTML "map"
     * element) for which this element provides the image.
     */
    public java.lang.String getUsemap() {
        if (null != this.usemap) {
            return this.usemap;
        }
        ValueExpression _ve = getValueExpression("usemap");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>usemap</code> property.</p>
     */
    public void setUsemap(java.lang.String usemap) {
        this.usemap = usemap;
    }


    private java.lang.String width;

    /**
     * <p>Return the value of the <code>width</code> property.</p>
     * <p>Contents: Override for the width of this image.
     */
    public java.lang.String getWidth() {
        if (null != this.width) {
            return this.width;
        }
        ValueExpression _ve = getValueExpression("width");
        if (_ve != null) {
            return (java.lang.String) _ve.getValue(getFacesContext().getELContext());
        } else {
            return null;
        }
    }

    /**
     * <p>Set the value of the <code>width</code> property.</p>
     */
    public void setWidth(java.lang.String width) {
        this.width = width;
    }


    private Object[] _values;

    public Object saveState(FacesContext _context) {
        if (_values == null) {
            _values = new Object[23];
        }
        _values[0] = super.saveState(_context);
        _values[1] = alt;
        _values[2] = dir;
        _values[3] = height;
        _values[4] = this.ismap ? Boolean.TRUE : Boolean.FALSE;
        _values[5] = this.ismap_set ? Boolean.TRUE : Boolean.FALSE;
        _values[6] = lang;
        _values[7] = longdesc;
        _values[8] = onclick;
        _values[9] = ondblclick;
        _values[10] = onkeydown;
        _values[11] = onkeypress;
        _values[12] = onkeyup;
        _values[13] = onmousedown;
        _values[14] = onmousemove;
        _values[15] = onmouseout;
        _values[16] = onmouseover;
        _values[17] = onmouseup;
        _values[18] = style;
        _values[19] = styleClass;
        _values[20] = title;
        _values[21] = usemap;
        _values[22] = width;
        return _values;
}


    public void restoreState(FacesContext _context, Object _state) {
        _values = (Object[]) _state;
        super.restoreState(_context, _values[0]);
        this.alt = (java.lang.String) _values[1];
        this.dir = (java.lang.String) _values[2];
        this.height = (java.lang.String) _values[3];
        this.ismap = ((java.lang.Boolean) _values[4]).booleanValue();
        this.ismap_set = ((Boolean) _values[5]).booleanValue();
        this.lang = (java.lang.String) _values[6];
        this.longdesc = (java.lang.String) _values[7];
        this.onclick = (java.lang.String) _values[8];
        this.ondblclick = (java.lang.String) _values[9];
        this.onkeydown = (java.lang.String) _values[10];
        this.onkeypress = (java.lang.String) _values[11];
        this.onkeyup = (java.lang.String) _values[12];
        this.onmousedown = (java.lang.String) _values[13];
        this.onmousemove = (java.lang.String) _values[14];
        this.onmouseout = (java.lang.String) _values[15];
        this.onmouseover = (java.lang.String) _values[16];
        this.onmouseup = (java.lang.String) _values[17];
        this.style = (java.lang.String) _values[18];
        this.styleClass = (java.lang.String) _values[19];
        this.title = (java.lang.String) _values[20];
        this.usemap = (java.lang.String) _values[21];
        this.width = (java.lang.String) _values[22];
    }


}
