/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.annotation.impl;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.annotation.CacheInvocationParameter;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.impl.AbstractKeyedCacheInterceptor;
import javax.cache.annotation.impl.CacheContextSource;
import javax.cache.annotation.impl.CachePutMethodDetails;
import javax.cache.annotation.impl.ClassFilter;
import javax.cache.annotation.impl.InterceptorType;
import javax.cache.annotation.impl.InternalCacheKeyInvocationContext;

public abstract class AbstractCachePutInterceptor<I>
extends AbstractKeyedCacheInterceptor<I, CachePutMethodDetails> {
    public Object cachePut(CacheContextSource<I> cacheContextSource, I invocation) throws Throwable {
        Object result;
        InternalCacheKeyInvocationContext<Annotation> cacheKeyInvocationContext = cacheContextSource.getCacheKeyInvocationContext(invocation);
        CachePutMethodDetails methodDetails = (CachePutMethodDetails)this.getStaticCacheKeyInvocationContext(cacheKeyInvocationContext, InterceptorType.CACHE_PUT);
        CachePut cachePutAnnotation = (CachePut)methodDetails.getCacheAnnotation();
        boolean afterInvocation = cachePutAnnotation.afterInvocation();
        CacheInvocationParameter valueParameter = cacheKeyInvocationContext.getValueParameter();
        Object value = valueParameter.getValue();
        if (!afterInvocation) {
            this.cacheValue(cacheKeyInvocationContext, methodDetails, value);
        }
        try {
            result = this.proceed(invocation);
        }
        catch (Throwable t) {
            Class[] noCacheFor;
            Class[] cacheFor;
            boolean cache;
            if (afterInvocation && (cache = ClassFilter.isIncluded(t, cacheFor = cachePutAnnotation.cacheFor(), noCacheFor = cachePutAnnotation.noCacheFor(), false))) {
                this.cacheValue(cacheKeyInvocationContext, methodDetails, value);
            }
            throw t;
        }
        if (afterInvocation) {
            this.cacheValue(cacheKeyInvocationContext, methodDetails, value);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void cacheValue(InternalCacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext, CachePutMethodDetails methodDetails, Object value) {
        void var4_6;
        if (value == null) {
            if (!((CachePut)methodDetails.getCacheAnnotation()).cacheNull()) return;
            CacheContextSource.NullPlaceholder nullPlaceholder = CacheContextSource.NULL_PLACEHOLDER;
        } else {
            Object object = value;
        }
        CacheResolver cacheResolver = methodDetails.getCacheResolver();
        Cache cache = cacheResolver.resolveCache(cacheKeyInvocationContext);
        CacheKeyGenerator cacheKeyGenerator = methodDetails.getCacheKeyGenerator();
        CacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        cache.put((Object)cacheKey, (Object)var4_6);
    }
}

