/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.annotation.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyParam;
import javax.cache.annotation.CacheMethodDetails;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheRemoveEntry;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.CacheValue;
import javax.cache.annotation.impl.AnnotationProviderImpl;
import javax.cache.annotation.impl.CacheContextSource;
import javax.cache.annotation.impl.CacheMethodDetailsImpl;
import javax.cache.annotation.impl.CacheParameterDetails;
import javax.cache.annotation.impl.CachePutMethodDetails;
import javax.cache.annotation.impl.CacheRemoveAllMethodDetails;
import javax.cache.annotation.impl.CacheRemoveEntryMethodDetails;
import javax.cache.annotation.impl.CacheResultMethodDetails;
import javax.cache.annotation.impl.InternalCacheInvocationContext;
import javax.cache.annotation.impl.InternalCacheKeyInvocationContext;
import javax.cache.annotation.impl.StaticCacheInvocationContext;
import javax.cache.annotation.impl.StaticCacheKeyInvocationContext;

public abstract class AbstractCacheLookupUtil<I>
implements CacheContextSource<I> {
    private final ConcurrentMap<MethodKey, StaticCacheInvocationContext<? extends Annotation>> methodDetailsCache = new ConcurrentHashMap<MethodKey, StaticCacheInvocationContext<? extends Annotation>>();

    public AbstractCacheLookupUtil() {
        AnnotationProviderImpl.setAnnotationsInitialized();
    }

    @Override
    public InternalCacheKeyInvocationContext<? extends Annotation> getCacheKeyInvocationContext(I invocation) {
        Class<?> targetClass;
        Method method = this.getMethod(invocation);
        StaticCacheInvocationContext<Annotation> staticCacheInvocationContext = this.getMethodDetails(method, targetClass = this.getTargetClass(invocation));
        if (staticCacheInvocationContext == null) {
            throw new AnnotationFormatError("At least one cache related annotation must be specified on " + method + " for intercepted invocation to be valid: " + invocation);
        }
        switch (staticCacheInvocationContext.getInterceptorType()) {
            case CACHE_RESULT: 
            case CACHE_PUT: 
            case CACHE_REMOVE_ENTRY: {
                return this.createCacheKeyInvocationContextImpl((StaticCacheKeyInvocationContext)staticCacheInvocationContext, invocation);
            }
        }
        throw new UnsupportedOperationException("Cannot get AbstractInternalCacheKeyInvocationContext for interceptor type: " + (Object)((Object)staticCacheInvocationContext.getInterceptorType()));
    }

    protected abstract InternalCacheKeyInvocationContext<? extends Annotation> createCacheKeyInvocationContextImpl(StaticCacheKeyInvocationContext<? extends Annotation> var1, I var2);

    @Override
    public InternalCacheInvocationContext<? extends Annotation> getCacheInvocationContext(I invocation) {
        Class<?> targetClass;
        Method method = this.getMethod(invocation);
        StaticCacheInvocationContext<Annotation> staticCacheInvocationContext = this.getMethodDetails(method, targetClass = this.getTargetClass(invocation));
        if (staticCacheInvocationContext == null) {
            throw new AnnotationFormatError("At least one cache related annotation must be specified on " + method + " for intercepted invocation to be valid: " + invocation);
        }
        return this.createCacheInvocationContextImpl(staticCacheInvocationContext, invocation);
    }

    protected abstract InternalCacheInvocationContext<? extends Annotation> createCacheInvocationContextImpl(StaticCacheInvocationContext<? extends Annotation> var1, I var2);

    protected <T extends Annotation> T getAnnotation(Class<T> annotationClass, Method method, Class<? extends Object> targetClass) {
        return method.getAnnotation(annotationClass);
    }

    @Override
    public StaticCacheInvocationContext<? extends Annotation> getMethodDetails(Method method, Class<? extends Object> targetClass) {
        MethodKey methodKey = new MethodKey(method, targetClass);
        StaticCacheInvocationContext staticCacheInvocationContext = (StaticCacheInvocationContext)this.methodDetailsCache.get(methodKey);
        if (staticCacheInvocationContext != null) {
            return staticCacheInvocationContext;
        }
        CacheDefaults cacheDefaultsAnnotation = targetClass.getAnnotation(CacheDefaults.class);
        CacheResult cacheResultAnnotation = this.getAnnotation(CacheResult.class, method, targetClass);
        CachePut cachePutAnnotation = this.getAnnotation(CachePut.class, method, targetClass);
        CacheRemoveEntry cacheRemoveEntryAnnotation = this.getAnnotation(CacheRemoveEntry.class, method, targetClass);
        CacheRemoveAll cacheRemoveAllAnnotation = this.getAnnotation(CacheRemoveAll.class, method, targetClass);
        if (cacheResultAnnotation == null && cachePutAnnotation == null && cacheRemoveEntryAnnotation == null && cacheRemoveAllAnnotation == null) {
            return null;
        }
        if (!(cacheResultAnnotation != null ^ cachePutAnnotation != null ^ cacheRemoveEntryAnnotation != null ^ cacheRemoveAllAnnotation != null)) {
            throw new AnnotationFormatError("Multiple cache annotations were found on " + method + " only one cache annotation per method is allowed");
        }
        if (cacheResultAnnotation != null) {
            staticCacheInvocationContext = this.createCacheResultMethodDetails(cacheResultAnnotation, cacheDefaultsAnnotation, method, targetClass);
        } else if (cachePutAnnotation != null) {
            staticCacheInvocationContext = this.createCachePutMethodDetails(cachePutAnnotation, cacheDefaultsAnnotation, method, targetClass);
        } else if (cacheRemoveEntryAnnotation != null) {
            staticCacheInvocationContext = this.createCacheRemoveEntryMethodDetails(cacheRemoveEntryAnnotation, cacheDefaultsAnnotation, method, targetClass);
        } else if (cacheRemoveAllAnnotation != null) {
            staticCacheInvocationContext = this.createCacheRemoveAllMethodDetails(cacheRemoveAllAnnotation, cacheDefaultsAnnotation, method, targetClass);
        } else {
            return null;
        }
        StaticCacheInvocationContext<? extends Annotation> existingMethodDetails = this.methodDetailsCache.putIfAbsent(methodKey, staticCacheInvocationContext);
        if (existingMethodDetails != null) {
            return existingMethodDetails;
        }
        return staticCacheInvocationContext;
    }

    protected abstract Class<?> getTargetClass(I var1);

    protected abstract Method getMethod(I var1);

    protected <A extends Annotation> CacheMethodDetails<A> createCacheMethodDetails(A cacheAnnotation, CacheDefaults cacheDefaultsAnnotation, String methodCacheName, Method method, Class<? extends Object> targetClass) {
        String cacheName = this.resolveCacheName(methodCacheName, cacheDefaultsAnnotation, method, targetClass);
        Set<Annotation> methodAnotations = this.getMethodAnnotations(method);
        return new CacheMethodDetailsImpl<A>(method, methodAnotations, cacheAnnotation, cacheName);
    }

    protected CacheResultMethodDetails createCacheResultMethodDetails(CacheResult cacheResultAnnotation, CacheDefaults cacheDefaultsAnnotation, Method method, Class<? extends Object> targetClass) {
        String methodCacheName = cacheResultAnnotation.cacheName();
        CacheMethodDetails<CacheResult> cacheMethodDetails = this.createCacheMethodDetails(cacheResultAnnotation, cacheDefaultsAnnotation, methodCacheName, method, targetClass);
        Class cacheResolverFactoryType = cacheResultAnnotation.cacheResolverFactory();
        CacheResolverFactory cacheResolverFactory = this.getCacheResolverFactory(cacheResolverFactoryType, cacheDefaultsAnnotation);
        Class cacheKeyGeneratorType = cacheResultAnnotation.cacheKeyGenerator();
        CacheKeyGenerator cacheKeyGenerator = this.getCacheKeyGenerator(cacheKeyGeneratorType, cacheDefaultsAnnotation);
        ParameterDetails parameterDetails = this.getParameterDetails(method, false);
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(cacheMethodDetails);
        String exceptionCacheName = cacheResultAnnotation.exceptionCacheName();
        CacheResolver exceptionCacheResolver = exceptionCacheName != null && exceptionCacheName.trim().length() != 0 ? cacheResolverFactory.getExceptionCacheResolver(cacheMethodDetails) : null;
        return new CacheResultMethodDetails(cacheMethodDetails, cacheResolver, exceptionCacheResolver, cacheKeyGenerator, parameterDetails.allParameters, parameterDetails.keyParameters);
    }

    protected CachePutMethodDetails createCachePutMethodDetails(CachePut cachePutAnnotation, CacheDefaults cacheDefaultsAnnotation, Method method, Class<? extends Object> targetClass) {
        String methodCacheName = cachePutAnnotation.cacheName();
        CacheMethodDetails<CachePut> cacheMethodDetails = this.createCacheMethodDetails(cachePutAnnotation, cacheDefaultsAnnotation, methodCacheName, method, targetClass);
        Class cacheResolverFactoryType = cachePutAnnotation.cacheResolverFactory();
        CacheResolverFactory cacheResolverFactory = this.getCacheResolverFactory(cacheResolverFactoryType, cacheDefaultsAnnotation);
        Class cacheKeyGeneratorType = cachePutAnnotation.cacheKeyGenerator();
        CacheKeyGenerator cacheKeyGenerator = this.getCacheKeyGenerator(cacheKeyGeneratorType, cacheDefaultsAnnotation);
        ParameterDetails parameterDetails = this.getParameterDetails(method, true);
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(cacheMethodDetails);
        return new CachePutMethodDetails(cacheMethodDetails, cacheResolver, cacheKeyGenerator, parameterDetails.allParameters, parameterDetails.keyParameters, parameterDetails.cacheValueParameter);
    }

    protected CacheRemoveEntryMethodDetails createCacheRemoveEntryMethodDetails(CacheRemoveEntry cacheRemoveEntryAnnotation, CacheDefaults cacheDefaultsAnnotation, Method method, Class<? extends Object> targetClass) {
        String methodCacheName = cacheRemoveEntryAnnotation.cacheName();
        CacheMethodDetails<CacheRemoveEntry> cacheMethodDetails = this.createCacheMethodDetails(cacheRemoveEntryAnnotation, cacheDefaultsAnnotation, methodCacheName, method, targetClass);
        Class cacheResolverFactoryType = cacheRemoveEntryAnnotation.cacheResolverFactory();
        CacheResolverFactory cacheResolverFactory = this.getCacheResolverFactory(cacheResolverFactoryType, cacheDefaultsAnnotation);
        Class cacheKeyGeneratorType = cacheRemoveEntryAnnotation.cacheKeyGenerator();
        CacheKeyGenerator cacheKeyGenerator = this.getCacheKeyGenerator(cacheKeyGeneratorType, cacheDefaultsAnnotation);
        ParameterDetails parameterDetails = this.getParameterDetails(method, false);
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(cacheMethodDetails);
        return new CacheRemoveEntryMethodDetails(cacheMethodDetails, cacheResolver, cacheKeyGenerator, (List<CacheParameterDetails>)parameterDetails.allParameters, (List<CacheParameterDetails>)parameterDetails.keyParameters);
    }

    protected CacheRemoveAllMethodDetails createCacheRemoveAllMethodDetails(CacheRemoveAll cacheRemoveAllAnnotation, CacheDefaults cacheDefaultsAnnotation, Method method, Class<? extends Object> targetClass) {
        String methodCacheName = cacheRemoveAllAnnotation.cacheName();
        CacheMethodDetails<CacheRemoveAll> cacheMethodDetails = this.createCacheMethodDetails(cacheRemoveAllAnnotation, cacheDefaultsAnnotation, methodCacheName, method, targetClass);
        Class cacheResolverFactoryType = cacheRemoveAllAnnotation.cacheResolverFactory();
        CacheResolverFactory cacheResolverFactory = this.getCacheResolverFactory(cacheResolverFactoryType, cacheDefaultsAnnotation);
        ParameterDetails parameterDetails = this.getParameterDetails(method, false);
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(cacheMethodDetails);
        return new CacheRemoveAllMethodDetails(cacheMethodDetails, cacheResolver, (List<CacheParameterDetails>)parameterDetails.allParameters);
    }

    protected Set<Annotation> getMethodAnnotations(Method method) {
        return Collections.unmodifiableSet(new LinkedHashSet<Annotation>(Arrays.asList(method.getAnnotations())));
    }

    protected ParameterDetails getParameterDetails(Method method, boolean cacheValueAllowed) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<CacheParameterDetails> allParameters = new ArrayList<CacheParameterDetails>(parameterTypes.length);
        ArrayList<CacheParameterDetails> keyParameters = new ArrayList<CacheParameterDetails>(parameterTypes.length);
        CacheParameterDetails cacheValueParameter = null;
        for (int pIdx = 0; pIdx < parameterTypes.length; ++pIdx) {
            Class<?> rawType = parameterTypes[pIdx];
            boolean isKey = false;
            boolean isValue = false;
            LinkedHashSet<Annotation> annotations = new LinkedHashSet<Annotation>();
            for (Annotation parameterAnnotation : parameterAnnotations[pIdx]) {
                annotations.add(parameterAnnotation);
                if (!isKey && CacheKeyParam.class.isAssignableFrom(parameterAnnotation.annotationType())) {
                    isKey = true;
                    continue;
                }
                if (!CacheValue.class.isAssignableFrom(parameterAnnotation.annotationType())) continue;
                if (!cacheValueAllowed) {
                    throw new AnnotationFormatError("CacheValue parameter annotation is not allowed on " + method);
                }
                if (cacheValueParameter != null || isValue) {
                    throw new AnnotationFormatError("Multiple CacheValue parameter annotations are not allowed: " + method);
                }
                isValue = true;
            }
            CacheParameterDetails cacheParameterDetails = new CacheParameterDetails(rawType, Collections.unmodifiableSet(annotations), pIdx);
            allParameters.add(cacheParameterDetails);
            if (isKey) {
                keyParameters.add(cacheParameterDetails);
            }
            if (!isValue) continue;
            cacheValueParameter = cacheParameterDetails;
        }
        if (keyParameters.isEmpty()) {
            keyParameters.addAll(allParameters);
        }
        if (cacheValueParameter != null) {
            keyParameters.remove(cacheValueParameter);
        }
        keyParameters.trimToSize();
        return new ParameterDetails(Collections.unmodifiableList(allParameters), Collections.unmodifiableList(keyParameters), cacheValueParameter);
    }

    protected abstract <T> T getObjectByType(Class<T> var1);

    protected abstract CacheKeyGenerator getDefaultCacheKeyGenerator();

    protected abstract CacheResolverFactory getDefaultCacheResolverFactory();

    protected CacheKeyGenerator getCacheKeyGenerator(Class<? extends CacheKeyGenerator> cacheKeyGeneratorType, CacheDefaults cacheDefaultsAnnotation) {
        Class defaultCacheKeyGeneratorType;
        if (!CacheKeyGenerator.class.equals(cacheKeyGeneratorType)) {
            return this.getObjectByType(cacheKeyGeneratorType);
        }
        if (cacheDefaultsAnnotation != null && !CacheKeyGenerator.class.equals((Object)(defaultCacheKeyGeneratorType = cacheDefaultsAnnotation.cacheKeyGenerator()))) {
            return (CacheKeyGenerator)this.getObjectByType(defaultCacheKeyGeneratorType);
        }
        return this.getDefaultCacheKeyGenerator();
    }

    protected CacheResolverFactory getCacheResolverFactory(Class<? extends CacheResolverFactory> cacheResolverFactoryType, CacheDefaults cacheDefaultsAnnotation) {
        Class defaultCacheResolverType;
        if (!CacheResolverFactory.class.equals(cacheResolverFactoryType)) {
            return this.getObjectByType(cacheResolverFactoryType);
        }
        if (cacheDefaultsAnnotation != null && !CacheResolverFactory.class.equals((Object)(defaultCacheResolverType = cacheDefaultsAnnotation.cacheResolverFactory()))) {
            return (CacheResolverFactory)this.getObjectByType(defaultCacheResolverType);
        }
        return this.getDefaultCacheResolverFactory();
    }

    protected String resolveCacheName(String methodCacheName, CacheDefaults cacheDefaultsAnnotation, Method method, Class<? extends Object> targetClass) {
        String defaultCacheName;
        if (!"".equals(methodCacheName)) {
            return methodCacheName;
        }
        if (cacheDefaultsAnnotation != null && !"".equals(defaultCacheName = cacheDefaultsAnnotation.cacheName())) {
            return defaultCacheName;
        }
        if (targetClass != null) {
            String fqClassName = method.getDeclaringClass().getName();
            StringBuilder generatedCacheNameBuilder = new StringBuilder(fqClassName);
            generatedCacheNameBuilder.append(".");
            generatedCacheNameBuilder.append(method.getName());
            generatedCacheNameBuilder.append("(");
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int pIdx = 0; pIdx < parameterTypes.length; ++pIdx) {
                generatedCacheNameBuilder.append(parameterTypes[pIdx].getName());
                if (pIdx + 1 >= parameterTypes.length) continue;
                generatedCacheNameBuilder.append(",");
            }
            generatedCacheNameBuilder.append(")");
            return generatedCacheNameBuilder.toString();
        }
        throw new AnnotationFormatError("cacheName must be specified in either CacheDefaults or CacheRemoveEntry or CacheRemoveAll for: " + method);
    }

    private static class MethodKey {
        private final Method method;
        private final Class<?> targetClass;
        private final int hashCode;

        public MethodKey(Method method, Class<?> targetClass) {
            this.method = method;
            this.targetClass = targetClass;
            this.hashCode = this.method.hashCode() * 29 + (this.targetClass != null ? this.targetClass.hashCode() : 0);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
                return false;
            }
            return !(this.targetClass == null ? other.targetClass != null : !this.targetClass.equals(other.targetClass));
        }
    }

    private static final class ParameterDetails {
        private final List<CacheParameterDetails> allParameters;
        private final List<CacheParameterDetails> keyParameters;
        private final CacheParameterDetails cacheValueParameter;

        private ParameterDetails(List<CacheParameterDetails> allParameters, List<CacheParameterDetails> keyParameters, CacheParameterDetails cacheValueParameter) {
            this.allParameters = allParameters;
            this.keyParameters = keyParameters;
            this.cacheValueParameter = cacheValueParameter;
        }
    }
}

