/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.interceptor;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheManager;
import javax.cache.interceptor.CacheResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCacheResolver
implements CacheResolver {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final CacheManager cacheManager;
    private final CacheBuilder cacheBuilder;

    public DefaultCacheResolver(CacheManager cacheManager, CacheBuilder cacheBuilder) {
        this.cacheManager = cacheManager;
        this.cacheBuilder = cacheBuilder;
    }

    @Override
    public <K, V> Cache<K, V> resolveCacheManger(String cacheName, Method method) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            this.logger.warning("No Cache named '" + cacheName + "' was found in the CacheManager, a copy of the default cache will be created.");
            cache = this.cacheBuilder.createCache(cacheName);
            this.cacheManager.addCache(cache);
        }
        return cache;
    }
}

