/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.ClassPathUtil;
import ccl.util.FileUtil;
import ccl.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Test
implements Runnable {
    private long _lGLobalTests = 0L;
    private long _lLocalTests = 0L;
    private long _lBugs = 0L;
    private boolean _bTiming = false;
    private boolean _bShowLiveSignals = false;
    private boolean _bLastSuccessfull = false;
    private boolean _bLastSubtest = false;
    private int _subtests = 0;
    private long _lLastBugs = 0L;
    private long _lLastLocalTests = 0L;
    private String _sLastSubTest = null;
    private Vector _vCalendars = new Vector();
    private static Object _oValue = null;
    private static boolean _bTest = false;
    private static boolean _bRedirectStandardStreams = false;
    private static PrintStream _oldOut = null;
    private static PrintStream _newOut = null;
    private static PrintStream _oldErr = null;
    private static PrintStream _newErr = null;

    private void _showLiveSignal() {
        if (this.isVerbose()) {
            Test._ensureStandardStreams();
            if (this._bLastSubtest) {
                Util.println();
            }
            if ((this._bLastSubtest || !this._bLastSuccessfull) && this._subtests > 0) {
                Util.print(Util.getSpaces((this._subtests - 1) * 3));
            }
            Util.showLiveSignal();
            Test._ensureRedirectedStreams();
            this._bLastSuccessfull = true;
            this._bLastSubtest = false;
        }
    }

    protected Object _getValue() {
        return _oValue;
    }

    protected void _enterSubTest(String sName_) {
        if (!this.isVerbose()) {
            return;
        }
        Test._ensureStandardStreams();
        if (this._subtests > 0) {
            Util.println();
            int subtest = 1;
            while (subtest < this._subtests) {
                Util.print("   ");
                ++subtest;
            }
            Util.print("-> ");
        } else if (0L < this._lLocalTests) {
            Util.println();
        }
        this._sLastSubTest = sName_;
        this._lLastBugs = this._lBugs;
        Util.print("Testing " + sName_ + " ");
        this._bLastSubtest = false;
        this._bLastSuccessfull = true;
        if (this.isTiming()) {
            this._vCalendars.addElement(Util.getCalendar("UTC"));
        }
        Test._ensureRedirectedStreams();
        ++this._subtests;
    }

    protected void _exitSubTest() {
        if (!this.isVerbose()) {
            return;
        }
        --this._subtests;
        this._lLastLocalTests = this._lLocalTests;
        Test._ensureStandardStreams();
        if (this._bLastSubtest || !this._bLastSuccessfull) {
            Util.println();
            if (this._subtests > 0) {
                Util.print(Util.getSpaces(this._subtests * 3));
            }
        } else {
            Util.print(" ");
        }
        if (this._lBugs == this._lLastBugs) {
            Util.print("SUCCESS");
        } else {
            Util.print("FAILURE");
        }
        if (this.isTiming()) {
            Calendar calStart = (Calendar)this._vCalendars.lastElement();
            Calendar calEnd = Util.getCalendar("UTC");
            long delta = calEnd.getTime().getTime() - calStart.getTime().getTime();
            Util.debug(this, (Object)("_exitSubTest().delta: " + delta));
            Calendar calDelta = Util.getCalendar("UTC");
            calDelta.set(14, (int)(delta % 1000L));
            calDelta.set(13, (int)(delta / 1000L % 60L));
            calDelta.set(12, (int)(delta / 60000L % 60L));
            calDelta.set(11, (int)(delta / 3600000L % 24L));
            calEnd.setTime(new Date(delta));
            this._vCalendars.removeElementAt(this._vCalendars.size() - 1);
            Util.print(" " + Util.getTime(calDelta) + "." + Util.paddWithZero(delta % 1000L, 3));
        }
        Test._ensureRedirectedStreams();
        this._bLastSubtest = true;
    }

    protected void _setTests(Test pTest_) {
        this.setTests(pTest_);
    }

    protected void _increment() {
        ++this._lGLobalTests;
        ++this._lLocalTests;
        this._showLiveSignal();
    }

    protected void _showLiveSignals(boolean bShowLiveSignals_) {
        this._bShowLiveSignals = bShowLiveSignals_;
    }

    public long getLocalTests() {
        return this._lLocalTests;
    }

    public long getGlobalTests() {
        return this._lGLobalTests;
    }

    public long getBugs() {
        return this._lBugs;
    }

    public void setBug() {
        ++this._lBugs;
    }

    public void setValue(Object oValue_) {
        _oValue = oValue_;
    }

    public boolean isVerbose() {
        return this._bShowLiveSignals;
    }

    public void setVerbose(boolean bVerbose_) {
        this._bShowLiveSignals = bVerbose_;
    }

    public void setTiming(boolean bTiming_) {
        this._bTiming = bTiming_;
        if (this.isTiming()) {
            this.setVerbose(this.isTiming());
        }
    }

    public boolean isTiming() {
        return this._bTiming;
    }

    public void printResult() {
        Test.printResult(this);
    }

    public static void printResult(Test pTest_) {
        Test._ensureStandardStreams();
        Util.println("\n*   *   *   *   *   *   *   *   *   *   *   *   *   *");
        Util.println(pTest_.getClass().getName() + " has finished.");
        if (pTest_.getBugs() == 0L) {
            Util.print("Hey, kewl, ");
            if (pTest_.getGlobalTests() == 1L) {
                Util.print("the one test");
            } else {
                Util.print("all " + pTest_.getGlobalTests() + " tests");
            }
            Util.println(" succeeded! :-)");
        } else {
            Util.print("I hate to say it, but " + pTest_.getBugs() + " test");
            if (pTest_.getBugs() > 1L) {
                Util.print("s");
            }
            Util.println(" out of " + pTest_.getGlobalTests() + " didn't succeed! :-(");
        }
    }

    private void _processFailure() {
        this.setBug();
        Test._ensureStandardStreams();
        if (this.isVerbose() && this._bLastSuccessfull) {
            Util.println();
        }
        Util.print(this.getClass().getName() + ": ");
        if (this._lLocalTests != this._lGLobalTests) {
            Util.println("Test " + this._lLocalTests + "/" + this._lGLobalTests + " failed!");
        } else {
            Util.println("Test " + this._lLocalTests + " failed!");
        }
        Test._ensureRedirectedStreams();
    }

    private boolean _check(boolean bCondition_) {
        this._increment();
        this._bLastSubtest = false;
        return bCondition_;
    }

    private void _printStackTrace() {
        Test._ensureStandardStreams();
        Util.print("    Stack trace: ");
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Test._ensureRedirectedStreams();
            return;
        }
    }

    private void _printMessage(String sDescription) {
        Vector vLines = Util.stringToLines(sDescription);
        Test._ensureStandardStreams();
        Enumeration e = vLines.elements();
        while (e.hasMoreElements()) {
            Util.println("    " + (String)e.nextElement());
        }
        Test._ensureRedirectedStreams();
    }

    public Test() {
    }

    public Test(Test tstParent_) {
        this.setParentTest(tstParent_);
    }

    public void setParentTest(Test tstParent_) {
        this.setVerbose(tstParent_.isVerbose());
        this.setTiming(tstParent_.isTiming());
        this._subtests = tstParent_._subtests;
    }

    public boolean bugIf(boolean bCondition) {
        if (this._check(bCondition)) {
            this._processFailure();
            this._printStackTrace();
        }
        this._bLastSuccessfull = !bCondition;
        return bCondition;
    }

    public boolean bugIf(boolean bCondition, String sDescription) {
        if (this._check(bCondition)) {
            this._processFailure();
            this._printMessage(sDescription);
            this._printStackTrace();
        }
        this._bLastSuccessfull = !bCondition;
        return bCondition;
    }

    public boolean bugIf(boolean bCondition, String sDescription, Throwable pThrowable) {
        if (this._check(bCondition)) {
            this._processFailure();
            this._printMessage(sDescription);
            Test._ensureStandardStreams();
            Util.print("    ");
            pThrowable.printStackTrace();
            Test._ensureRedirectedStreams();
        }
        this._bLastSuccessfull = !bCondition;
        return bCondition;
    }

    public void assertNotNull(Object object_) {
        this.bugIf(object_ == null, "Assert not null test failed!");
    }

    public void assertNotNull(Object object_, String sMessage_) {
        this.bugIf(object_ == null, sMessage_);
    }

    public void assert(boolean bCheck_) {
        this.bugIf(!bCheck_, "Assert test failed!");
    }

    public void assert(boolean bCheck_, String sMessage_) {
        this.bugIf(!bCheck_, sMessage_);
    }

    public void Assert(boolean bCheck_) {
        this.bugIf(!bCheck_, "Assert test failed!");
    }

    public void Assert(boolean bCheck_, String sMessage_) {
        this.bugIf(!bCheck_, sMessage_);
    }

    public void assertTrue(boolean bCheck_) {
        this.bugIf(!bCheck_, "Assert test failed!");
    }

    public void assertTrue(boolean bCheck_, String sMessage_) {
        this.bugIf(!bCheck_, sMessage_);
    }

    public void assertTrue(String sMessage_, boolean bCheck_) {
        this.bugIf(!bCheck_, sMessage_);
    }

    public void assertEquals(String message, boolean expected, boolean actual) {
        this.Assert(expected == actual, message);
    }

    public void assertEquals(boolean expected, boolean actual) {
        this.Assert(expected == actual);
    }

    public void assertEquals(String message, int expected, int actual) {
        this.Assert(expected == actual, message);
    }

    public void assertEquals(String message, String expected, String actual) {
        if (expected == null) {
            this.Assert(actual == expected, message);
        }
        this.Assert(expected.equals(actual), message);
    }

    public void assertEquals(String expected, String actual) {
        if (expected == null) {
            this.Assert(actual == expected, "Given string '" + actual + "' is not null as expected");
        }
        String message = "Given string '" + actual + "' does not have the expected value '" + expected + "'";
        this.Assert(expected.equals(actual), message);
    }

    public void assertEquals(double actual, double expected, double delta) {
        this.Assert(Math.abs(actual - expected) <= Math.abs(delta));
    }

    public void assertEquals(double actual, double expected, double delta, String message) {
        this.Assert(Math.abs(actual - expected) <= Math.abs(delta), message);
    }

    public void fail(String message) {
        this.bug(message);
    }

    public void fail() {
        this.Assert(false);
    }

    public void bug(String message) {
        this.bugIf(true, message);
    }

    protected abstract void _doIt() throws Exception;

    public void run() {
        if (this.isVerbose()) {
            this._enterSubTest(this.getName());
        }
        try {
            this._doIt();
        }
        catch (OutOfMemoryError memoryError) {
            this.bugIf(true, "Test memory error (" + Util.formatMemoryInfo() + ")!", memoryError);
        }
        catch (Throwable throwable) {
            this.bugIf(true, "Test error!", throwable);
        }
        if (this.isVerbose()) {
            this._exitSubTest();
        }
    }

    public String getName() {
        return Test.getTestName(this);
    }

    public static String getTestName(Object testObject) {
        String sTestName = Util.getObjectName(testObject);
        return Test.getTestName(sTestName);
    }

    public static String getTestName(String sTestName) {
        if (sTestName.startsWith("Test")) {
            return sTestName.substring(4);
        }
        int testIndex = sTestName.lastIndexOf("Test");
        if (testIndex == -1) {
            testIndex = sTestName.length();
        }
        return sTestName.substring(0, testIndex);
    }

    public void initialize(String[] asArg_) {
        Util.debug(this, (Object)("initialize(..).args: " + Util.toString(Util.objectsToVector(asArg_))));
    }

    public static boolean isTest() {
        return _bTest;
    }

    public static Object getValue() {
        return _oValue;
    }

    public String getTestClassDirectory() {
        return FileUtil.getClassPath(this);
    }

    public String getTestDirectory() {
        return FileUtil.concatPath(ClassPathUtil.getApplicationHome(this), "test");
    }

    public String toString() {
        return ">> no comment available <<";
    }

    public void setTests(Test test_) {
        if (test_ == null) {
            this._lGLobalTests = 0L;
            this._lBugs = 0L;
            this._lLocalTests = 0L;
        } else {
            this._lGLobalTests += test_.getGlobalTests();
            this._lBugs += test_.getBugs();
            this._bLastSubtest = true;
        }
    }

    public String getComment() {
        return ">> no comment available <<";
    }

    private static void _setOutNew() {
        System.setOut(_newOut);
        System.setErr(_newErr);
    }

    private static void _setOutOld() {
        System.setOut(_oldOut);
        System.setErr(_oldErr);
    }

    private static void _ensureStandardStreams() {
        if (_bRedirectStandardStreams) {
            Test._setOutOld();
        }
    }

    private static void _ensureRedirectedStreams() {
        if (_bRedirectStandardStreams) {
            Test._setOutNew();
        }
    }

    public static void redirectStandardStreams(boolean bRedirect_) {
        if (_bRedirectStandardStreams == bRedirect_) {
            return;
        }
        _bRedirectStandardStreams = bRedirect_;
        if (_bRedirectStandardStreams) {
            if (_newOut == null) {
                _oldOut = System.out;
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                _newOut = new PrintStream(byteStream);
                _oldErr = System.err;
                ByteArrayOutputStream errorByteStream = new ByteArrayOutputStream();
                _newErr = new PrintStream(errorByteStream);
            }
            Test._setOutNew();
        } else {
            Test._setOutOld();
        }
    }
}

