/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.swing.CCLBorder;
import ccl.swing.DoubleListModel;
import ccl.swing.SwingUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DoubleList
extends JPanel
implements MouseListener {
    private JList _lstFirst;
    private JList _lstSecond;
    private Vector _vSecond = null;
    private boolean _bMultiSelect = false;
    private int _firstIndex = -1;
    private DoubleListModel _pDoubleListModel = null;
    private JScrollPane _jspFirst = null;
    private JScrollPane _jspSecond = null;

    public void _showSecondList() {
        if (this.getFirstIndex() >= 0) {
            this._lstSecond.clearSelection();
            this._lstSecond.setModel(this._pDoubleListModel.getSecondModel(this.getFirstIndex()));
        }
    }

    public DoubleList(Vector vFirstList_, Vector vSecondList_, boolean bMultiSelect_) {
        this._bMultiSelect = bMultiSelect_;
        this._pDoubleListModel = new DoubleListModel(vFirstList_, vSecondList_);
        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        this.setLayout(new GridLayout(0, 2));
        DefaultListModel dlmFirst = this._pDoubleListModel.getFirstModel();
        this._lstFirst = new JList(dlmFirst);
        this._lstFirst.setFont(new Font("Dialog", 1, 12));
        this._lstFirst.addMouseListener(this);
        this._lstFirst.setSelectionMode(0);
        this._lstSecond = new JList(new DefaultListModel());
        if (bMultiSelect_) {
            this._lstSecond.setSelectionMode(2);
        } else {
            this._lstSecond.setSelectionMode(0);
        }
        this._lstSecond.setFont(new Font("Dialog", 1, 12));
        this._lstSecond.addMouseListener(this);
        pAutoGridBagLayout.setExpandBoth();
        pAutoGridBagLayout.setFillBoth();
        this._jspFirst = new JScrollPane(this._lstFirst);
        this._jspFirst.setBorder(new CCLBorder());
        this._jspSecond = new JScrollPane(this._lstSecond);
        this._jspSecond.setBorder(new CCLBorder());
        this.add(this._jspFirst);
        this.add(this._jspSecond);
    }

    public void setLists(Vector vFirstList_, Vector vSecondList_) {
        this._pDoubleListModel.set(vFirstList_, vSecondList_);
        this._lstFirst.clearSelection();
        this._lstSecond.clearSelection();
        this._lstFirst.setModel(this._pDoubleListModel.getFirstModel());
        this._lstSecond.setModel(new DefaultListModel());
    }

    public void setBackground(Color pColor_) {
        super.setBackground(pColor_);
        if (this._jspFirst != null) {
            this._jspFirst.setBackground(pColor_);
        }
        if (this._jspSecond != null) {
            this._jspSecond.setBackground(pColor_);
        }
    }

    public void mousePressed(MouseEvent pMouseEvent_) {
        Object oSource = pMouseEvent_.getSource();
        if (oSource == this._lstFirst) {
            this._firstIndex = this._lstFirst.getSelectedIndex();
            this._showSecondList();
            return;
        }
    }

    public void mouseClicked(MouseEvent pMouseEvent_) {
    }

    public void mouseEntered(MouseEvent pMouseEvent_) {
    }

    public void mouseExited(MouseEvent pMouseEvent_) {
    }

    public void mouseReleased(MouseEvent pMouseEvent_) {
    }

    public void setListBackground(Color pColor_) {
        this._lstFirst.setBackground(pColor_);
        this._lstSecond.setBackground(pColor_);
        this._lstFirst.setSelectionForeground(pColor_);
        this._lstSecond.setSelectionForeground(pColor_);
    }

    public void setListForeground(Color pColor_) {
        this._lstFirst.setForeground(pColor_);
        this._lstSecond.setForeground(pColor_);
        this._lstFirst.setSelectionBackground(pColor_);
        this._lstSecond.setSelectionBackground(pColor_);
    }

    public Vector getFirstVector() {
        return SwingUtil.toVector((DefaultListModel)this._lstFirst.getModel());
    }

    public Vector getSecondVector() {
        Vector<Vector> vSecond = new Vector<Vector>();
        Enumeration eSubLists = this._pDoubleListModel.getSecondVector().elements();
        while (eSubLists.hasMoreElements()) {
            DefaultListModel dlmNext = (DefaultListModel)eSubLists.nextElement();
            Vector vNext = SwingUtil.toVector(dlmNext);
            vSecond.addElement(vNext);
        }
        return vSecond;
    }

    public JList getFirstList() {
        return this._lstFirst;
    }

    public JList getSecondList() {
        return this._lstSecond;
    }

    public void setFirstSelectedIndex(int index_) {
        this._firstIndex = index_;
        this._lstFirst.setSelectedIndex(index_);
        this._showSecondList();
    }

    public int getFirstIndex() {
        return this._firstIndex;
    }

    public String getFirstItem() {
        if (this._firstIndex == -1) {
            return null;
        }
        return (String)this._pDoubleListModel.getFirstModel().getElementAt(this._firstIndex);
    }

    public Object getFirstSelectedValue() {
        if (this._firstIndex == -1) {
            return null;
        }
        return this._pDoubleListModel.getFirstModel().getElementAt(this._firstIndex);
    }

    public int getSecondSelectedIndex() {
        return this._lstSecond.getSelectedIndex();
    }

    public String getSecondSelectedItem() {
        if (this.getSecondSelectedIndex() == -1) {
            return null;
        }
        return this._lstSecond.getSelectedValue().toString();
    }

    public Vector getSecondSelectedItems() {
        Vector<Object> vSelectedItems = new Vector<Object>();
        if (!this._bMultiSelect) {
            if (this.getSecondSelectedIndex() == -1) {
                return null;
            }
            vSelectedItems.addElement(this.getSecondSelectedItem());
        } else {
            Object[] aItems = this._lstSecond.getSelectedValues();
            if (aItems == null) {
                return null;
            }
            int i = 0;
            while (i < aItems.length) {
                vSelectedItems.addElement(aItems[i]);
                ++i;
            }
        }
        return vSelectedItems;
    }

    public DoubleListModel getModel() {
        return this._pDoubleListModel;
    }
}

