/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocument
implements Document,
Serializable {
    private transient int numReaders;
    private transient Thread currWriter;
    private transient int numWriters;
    private transient boolean notifyingListeners;
    private static Boolean defaultI18NProperty;
    private Dictionary<Object, Object> documentProperties = null;
    protected EventListenerList listenerList = new EventListenerList();
    private Content data;
    private AttributeContext context;
    private transient BranchElement bidiRoot;
    private DocumentFilter documentFilter;
    private transient DocumentFilter.FilterBypass filterBypass;
    private static final String BAD_LOCK_STATE = "document lock failure";
    protected static final String BAD_LOCATION = "document location failure";
    public static final String ParagraphElementName = "paragraph";
    public static final String ContentElementName = "content";
    public static final String SectionElementName = "section";
    public static final String BidiElementName = "bidi level";
    public static final String ElementNameAttribute = "$ename";
    static final String I18NProperty = "i18n";
    static final Object MultiByteProperty;
    static final String AsyncLoadPriority = "load priority";

    protected AbstractDocument(Content content) {
        this(content, StyleContext.getDefaultStyleContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractDocument(Content content, AttributeContext attributeContext) {
        Object object;
        this.data = content;
        this.context = attributeContext;
        this.bidiRoot = new BidiRootElement();
        if (defaultI18NProperty == null) {
            object = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return null;
                }
            });
            defaultI18NProperty = object != null ? Boolean.valueOf((String)object) : Boolean.FALSE;
        }
        this.putProperty(I18NProperty, defaultI18NProperty);
        this.writeLock();
        try {
            object = new Element[]{new BidiElement((Element)this.bidiRoot, 0, 1, 0)};
            this.bidiRoot.replace(0, 0, (Element[])object);
        }
        finally {
            this.writeUnlock();
        }
    }

    public Dictionary<Object, Object> getDocumentProperties() {
        return null;
    }

    public void setDocumentProperties(Dictionary<Object, Object> dictionary) {
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return null;
    }

    public int getAsynchronousLoadPriority() {
        return 0;
    }

    public void setAsynchronousLoadPriority(int n) {
    }

    public void setDocumentFilter(DocumentFilter documentFilter) {
    }

    public DocumentFilter getDocumentFilter() {
        return null;
    }

    @Override
    public void render(Runnable runnable) {
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
    }

    public DocumentListener[] getDocumentListeners() {
        return null;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        return null;
    }

    @Override
    public final Object getProperty(Object object) {
        return null;
    }

    @Override
    public final void putProperty(Object object, Object object2) {
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
    }

    void handleRemove(int n, int n2) throws BadLocationException {
    }

    private static final boolean isComplex(char c) {
        return false;
    }

    private static final boolean isComplex(char[] cArray, int n, int n2) {
        return false;
    }

    public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
    }

    void handleInsertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
    }

    @Override
    public String getText(int n, int n2) throws BadLocationException {
        return null;
    }

    @Override
    public void getText(int n, int n2, Segment segment) throws BadLocationException {
    }

    @Override
    public synchronized Position createPosition(int n) throws BadLocationException {
        return null;
    }

    @Override
    public final Position getStartPosition() {
        return null;
    }

    @Override
    public final Position getEndPosition() {
        return null;
    }

    @Override
    public Element[] getRootElements() {
        return null;
    }

    @Override
    public abstract Element getDefaultRootElement();

    private DocumentFilter.FilterBypass getFilterBypass() {
        return null;
    }

    public Element getBidiRootElement() {
        return null;
    }

    boolean isLeftToRight(int n, int n2) {
        return false;
    }

    public abstract Element getParagraphElement(int var1);

    protected final AttributeContext getAttributeContext() {
        return null;
    }

    protected void insertUpdate(DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
    }

    protected void removeUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    protected void postRemoveUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    void updateBidi(DefaultDocumentEvent defaultDocumentEvent) {
    }

    private byte[] calculateBidiLevels(int n, int n2) {
        return null;
    }

    public void dump(PrintStream printStream) {
    }

    protected final Content getContent() {
        return null;
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return null;
    }

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return null;
    }

    protected final synchronized Thread getCurrentWriter() {
        return null;
    }

    protected final synchronized void writeLock() {
    }

    protected final synchronized void writeUnlock() {
    }

    public final synchronized void readLock() {
    }

    public final synchronized void readUnlock() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    Serializable,
    TreeNode {
        private Element parent;
        private transient AttributeSet attributes;

        public AbstractElement(Element element, AttributeSet attributeSet) {
            this.parent = element;
            this.attributes = AbstractDocument.this.getAttributeContext().getEmptySet();
            if (attributeSet != null) {
                this.addAttributes(attributeSet);
            }
        }

        private final void indent(PrintWriter printWriter, int n) {
        }

        public void dump(PrintStream printStream, int n) {
        }

        @Override
        public int getAttributeCount() {
            return 0;
        }

        @Override
        public boolean isDefined(Object object) {
            return false;
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return false;
        }

        @Override
        public AttributeSet copyAttributes() {
            return null;
        }

        @Override
        public Object getAttribute(Object object) {
            return null;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return null;
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return false;
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            return false;
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }

        @Override
        public void addAttribute(Object object, Object object2) {
        }

        @Override
        public void addAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void removeAttribute(Object object) {
        }

        @Override
        public void removeAttributes(Enumeration<?> enumeration) {
        }

        @Override
        public void removeAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void setResolveParent(AttributeSet attributeSet) {
        }

        private final void checkForIllegalCast() {
        }

        @Override
        public Document getDocument() {
            return null;
        }

        @Override
        public Element getParentElement() {
            return null;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public abstract int getStartOffset();

        @Override
        public abstract int getEndOffset();

        @Override
        public abstract Element getElement(int var1);

        @Override
        public abstract int getElementCount();

        @Override
        public abstract int getElementIndex(int var1);

        @Override
        public abstract boolean isLeaf();

        @Override
        public TreeNode getChildAt(int n) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public int getIndex(TreeNode treeNode) {
            return 0;
        }

        @Override
        public abstract boolean getAllowsChildren();

        @Override
        public abstract Enumeration children();

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration<?> var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);
    }

    class BidiElement
    extends LeafElement {
        BidiElement(Element element, int n, int n2, int n3) {
            super(element, new SimpleAttributeSet(), n, n2);
            this.addAttribute(StyleConstants.BidiLevel, new Integer(n3));
        }

        public String getName() {
            return null;
        }

        int getLevel() {
            return 0;
        }

        boolean isLeftToRight() {
            return false;
        }
    }

    class BidiRootElement
    extends BranchElement {
        BidiRootElement() {
            super(null, null);
        }

        public String getName() {
            return null;
        }
    }

    public class BranchElement
    extends AbstractElement {
        private AbstractElement[] children;
        private int nchildren;
        private int lastIndex;

        public BranchElement(Element element, AttributeSet attributeSet) {
            super(element, attributeSet);
            this.children = new AbstractElement[1];
            this.nchildren = 0;
            this.lastIndex = -1;
        }

        public Element positionToElement(int n) {
            return null;
        }

        public void replace(int n, int n2, Element[] elementArray) {
        }

        public String toString() {
            return null;
        }

        public String getName() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int n) {
            return 0;
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Enumeration children() {
            return null;
        }
    }

    public static interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private int offset;
        private int length;
        private Hashtable changeLookup;
        private DocumentEvent.EventType type;

        public DefaultDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
            this.offset = n;
            this.length = n2;
            this.type = eventType;
        }

        public String toString() {
            return null;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            return false;
        }

        public void redo() throws CannotRedoException {
        }

        public void undo() throws CannotUndoException {
        }

        public boolean isSignificant() {
            return false;
        }

        public String getPresentationName() {
            return null;
        }

        public String getUndoPresentationName() {
            return null;
        }

        public String getRedoPresentationName() {
            return null;
        }

        public DocumentEvent.EventType getType() {
            return null;
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return 0;
        }

        public Document getDocument() {
            return null;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            return null;
        }

        static /* synthetic */ DocumentEvent.EventType access$100(DefaultDocumentEvent defaultDocumentEvent) {
            return null;
        }
    }

    private class DefaultFilterBypass
    extends DocumentFilter.FilterBypass {
        private DefaultFilterBypass() {
        }

        public Document getDocument() {
            return null;
        }

        public void remove(int n, int n2) throws BadLocationException {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        }

        public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        }
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private Element e;
        private int index;
        private Element[] removed;
        private Element[] added;

        public ElementEdit(Element element, int n, Element[] elementArray, Element[] elementArray2) {
            this.e = element;
            this.index = n;
            this.removed = elementArray;
            this.added = elementArray2;
        }

        public Element getElement() {
            return null;
        }

        public int getIndex() {
            return 0;
        }

        public Element[] getChildrenRemoved() {
            return null;
        }

        public Element[] getChildrenAdded() {
            return null;
        }

        public void redo() throws CannotRedoException {
        }

        public void undo() throws CannotUndoException {
        }
    }

    public class LeafElement
    extends AbstractElement {
        private transient Position p0;
        private transient Position p1;

        public LeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(element, attributeSet);
            try {
                this.p0 = AbstractDocument.this.createPosition(n);
                this.p1 = AbstractDocument.this.createPosition(n2);
            }
            catch (BadLocationException badLocationException) {
                this.p0 = null;
                this.p1 = null;
                throw new StateInvariantError("Can't create Position references");
            }
        }

        public String toString() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public String getName() {
            return null;
        }

        public int getElementIndex(int n) {
            return 0;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public boolean isLeaf() {
            return false;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Enumeration children() {
            return null;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        }
    }

    class UndoRedoDocumentEvent
    implements DocumentEvent {
        private DefaultDocumentEvent src = null;
        private boolean isUndo;
        private DocumentEvent.EventType type = null;

        public UndoRedoDocumentEvent(DefaultDocumentEvent defaultDocumentEvent, boolean bl) {
            this.src = defaultDocumentEvent;
            this.isUndo = bl;
            this.type = bl ? (defaultDocumentEvent.getType().equals(DocumentEvent.EventType.INSERT) ? DocumentEvent.EventType.REMOVE : (defaultDocumentEvent.getType().equals(DocumentEvent.EventType.REMOVE) ? DocumentEvent.EventType.INSERT : defaultDocumentEvent.getType())) : defaultDocumentEvent.getType();
        }

        public DefaultDocumentEvent getSource() {
            return null;
        }

        public int getOffset() {
            return 0;
        }

        public int getLength() {
            return 0;
        }

        public Document getDocument() {
            return null;
        }

        public DocumentEvent.EventType getType() {
            return null;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            return null;
        }
    }
}

