/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;

public class SerialClob
implements Clob,
Serializable,
Cloneable {
    private char[] buf;
    private Clob clob;
    private long len;
    private long origLen;
    static final long serialVersionUID = -1662519690087375313L;

    public SerialClob(char[] cArray) throws SerialException, SQLException {
        this.len = cArray.length;
        this.buf = new char[(int)this.len];
        int n = 0;
        while ((long)n < this.len) {
            this.buf[n] = cArray[n];
            ++n;
        }
        this.origLen = this.len;
    }

    public SerialClob(Clob clob) throws SerialException, SQLException {
        if (clob == null) {
            throw new SQLException("Cannot instantiate a SerialClob object with a null Clob object");
        }
        this.len = clob.length();
        this.clob = clob;
        this.buf = new char[(int)this.len];
        int n = 0;
        int n2 = 0;
        if (clob.getCharacterStream() == null || clob.getAsciiStream() == null) {
            throw new SQLException("Invalid Clob object. Calls to getCharacterStream or getAsciiStream return null which cannot be serialized.");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(clob.getCharacterStream());
            do {
                n = bufferedReader.read(this.buf, n2, (int)(this.len - (long)n2));
                n2 += n;
            } while (n > 0);
        }
        catch (IOException iOException) {
            throw new SerialException("SerialClob: " + iOException.getMessage());
        }
        this.origLen = this.len;
    }

    public long length() throws SerialException {
        return 0L;
    }

    public Reader getCharacterStream() throws SerialException {
        return null;
    }

    public InputStream getAsciiStream() throws SerialException, SQLException {
        return null;
    }

    public String getSubString(long l, int n) throws SerialException {
        return null;
    }

    public long position(String string, long l) throws SerialException, SQLException {
        return 0L;
    }

    public long position(Clob clob, long l) throws SerialException, SQLException {
        return 0L;
    }

    public int setString(long l, String string) throws SerialException {
        return 0;
    }

    public int setString(long l, String string, int n, int n2) throws SerialException {
        return 0;
    }

    public OutputStream setAsciiStream(long l) throws SerialException, SQLException {
        return null;
    }

    public Writer setCharacterStream(long l) throws SerialException, SQLException {
        return null;
    }

    public void truncate(long l) throws SerialException {
    }
}

