/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.x500;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import sun.security.util.DerValue;
import sun.security.util.ResourcesMgr;
import sun.security.x509.X500Name;

public final class X500Principal
implements Principal,
Serializable {
    private static final long serialVersionUID = -500463348111345721L;
    public static final String RFC1779 = "RFC1779";
    public static final String RFC2253 = "RFC2253";
    public static final String CANONICAL = "CANONICAL";
    private transient X500Name thisX500Name;

    X500Principal(X500Name x500Name) {
        this.thisX500Name = x500Name;
    }

    public X500Principal(String string) {
        if (string == null) {
            throw new NullPointerException(ResourcesMgr.getString("provided null name"));
        }
        try {
            this.thisX500Name = new X500Name(string);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input name: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public X500Principal(byte[] byArray) {
        try {
            this.thisX500Name = new X500Name(byArray);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input name");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public X500Principal(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("provided null input stream");
        }
        try {
            if (inputStream.markSupported()) {
                inputStream.mark(inputStream.available() + 1);
            }
            DerValue derValue = new DerValue(inputStream);
            this.thisX500Name = new X500Name(derValue.data);
        }
        catch (Exception exception) {
            if (inputStream.markSupported()) {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input stream and unable to reset input stream");
                    illegalArgumentException.initCause(exception);
                    throw illegalArgumentException;
                }
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("improperly specified input stream");
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    public String getName() {
        return null;
    }

    public String getName(String string) {
        return null;
    }

    public byte[] getEncoded() {
        return null;
    }

    public String toString() {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, NotActiveException, ClassNotFoundException {
    }
}

