/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import sun.security.util.Debug;
import sun.security.util.ResourcesMgr;

public class LoginContext {
    private static final String INIT_METHOD = "initialize";
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private boolean loginSucceeded = false;
    private CallbackHandler callbackHandler;
    private Map state = new HashMap();
    private Configuration config;
    private boolean configProvided = false;
    private AccessControlContext creatorAcc = null;
    private ModuleInfo[] moduleStack;
    private ClassLoader contextClassLoader = null;
    private static final Class[] PARAMS;
    private int moduleIndex = 0;
    private LoginException firstError = null;
    private LoginException firstRequiredError = null;
    private boolean success = false;
    private static final Debug debug;

    private void init(String string) throws LoginException {
    }

    private void loadDefaultCallbackHandler() throws LoginException {
    }

    public LoginContext(String string) throws LoginException {
        this.init(string);
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String string, Subject subject) throws LoginException {
        this.init(string);
        if (subject == null) {
            throw new LoginException(ResourcesMgr.getString("invalid null Subject provided"));
        }
        this.subject = subject;
        this.subjectProvided = true;
        this.loadDefaultCallbackHandler();
    }

    public LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        this.init(string);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid null CallbackHandler provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this(string, subject);
        if (callbackHandler == null) {
            throw new LoginException(ResourcesMgr.getString("invalid null CallbackHandler provided"));
        }
        this.callbackHandler = new SecureCallbackHandler(AccessController.getContext(), callbackHandler);
    }

    public LoginContext(String string, Subject subject, CallbackHandler callbackHandler, Configuration configuration) throws LoginException {
        this.config = configuration;
        boolean bl = this.configProvided = configuration != null;
        if (this.configProvided) {
            this.creatorAcc = AccessController.getContext();
        }
        this.init(string);
        if (subject != null) {
            this.subject = subject;
            this.subjectProvided = true;
        }
        if (callbackHandler == null) {
            this.loadDefaultCallbackHandler();
        } else {
            this.callbackHandler = !this.configProvided ? new SecureCallbackHandler(AccessController.getContext(), callbackHandler) : callbackHandler;
        }
    }

    public void login() throws LoginException {
    }

    public void logout() throws LoginException {
    }

    public Subject getSubject() {
        return null;
    }

    private void clearState() {
    }

    private void throwException(LoginException loginException, LoginException loginException2) throws LoginException {
    }

    private void invokePriv(String string) throws LoginException {
    }

    private void invokeCreatorPriv(String string) throws LoginException {
    }

    private void invoke(String string) throws LoginException {
    }

    static /* synthetic */ void access$000(LoginContext loginContext, String string) throws LoginException {
    }

    private static class ModuleInfo {
        AppConfigurationEntry entry;
        Object module;

        ModuleInfo(AppConfigurationEntry appConfigurationEntry, Object object) {
            this.entry = appConfigurationEntry;
            this.module = object;
        }
    }

    private static class SecureCallbackHandler
    implements CallbackHandler {
        private final AccessControlContext acc;
        private final CallbackHandler ch;

        SecureCallbackHandler(AccessControlContext accessControlContext, CallbackHandler callbackHandler) {
            this.acc = accessControlContext;
            this.ch = callbackHandler;
        }

        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        }

        static /* synthetic */ CallbackHandler access$100(SecureCallbackHandler secureCallbackHandler) {
            return null;
        }
    }
}

