/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Rfc2253Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rdn
implements Serializable,
Comparable<Object> {
    private transient ArrayList entries;
    private static final int DEFAULT_SIZE = 1;
    private static final long serialVersionUID = -5994465067210009656L;
    private static final String escapees = ",=+<>#;\"\\";

    public Rdn(Attributes attributes) throws InvalidNameException {
        if (attributes.size() == 0) {
            throw new InvalidNameException("Attributes cannot be empty");
        }
        this.entries = new ArrayList(attributes.size());
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        try {
            int n = 0;
            while (namingEnumeration.hasMore()) {
                RdnEntry rdnEntry = new RdnEntry();
                Attribute attribute = namingEnumeration.next();
                RdnEntry.access$102(rdnEntry, attribute.getID());
                RdnEntry.access$202(rdnEntry, attribute.get());
                this.entries.add(n, rdnEntry);
                ++n;
            }
        }
        catch (NamingException namingException) {
            InvalidNameException invalidNameException = new InvalidNameException(namingException.getMessage());
            invalidNameException.initCause(namingException);
            throw invalidNameException;
        }
        this.sort();
    }

    public Rdn(String string) throws InvalidNameException {
        this.entries = new ArrayList(1);
        new Rfc2253Parser(string).parseRdn(this);
    }

    public Rdn(Rdn rdn) {
        this.entries = new ArrayList(rdn.entries.size());
        this.entries.addAll(rdn.entries);
    }

    public Rdn(String string, Object object) throws InvalidNameException {
        if (object == null) {
            throw new NullPointerException("Cannot set value to null");
        }
        if (string.equals("") || this.isEmptyValue(object)) {
            throw new InvalidNameException("type or value cannot be empty, type:" + string + " value:" + object);
        }
        this.entries = new ArrayList(1);
        this.put(string, object);
    }

    private boolean isEmptyValue(Object object) {
        return false;
    }

    Rdn() {
        this.entries = new ArrayList(1);
    }

    Rdn put(String string, Object object) {
        return null;
    }

    void sort() {
    }

    public Object getValue() {
        return null;
    }

    public String getType() {
        return null;
    }

    public String toString() {
        return null;
    }

    @Override
    public int compareTo(Object object) {
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public Attributes toAttributes() {
        return null;
    }

    public int size() {
        return 0;
    }

    public static String escapeValue(Object object) {
        return null;
    }

    private static String escapeStringValue(String string) {
        return null;
    }

    private static String escapeBinaryValue(byte[] byArray) {
        return null;
    }

    public static Object unescapeValue(String string) {
        return null;
    }

    private static byte[] decodeHexPairs(char[] cArray, int n, int n2) {
        return null;
    }

    private static byte[] getUtf8Octets(char[] cArray, int n, int n2) {
        return null;
    }

    private static boolean isWhitespace(char c) {
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    static /* synthetic */ String access$300(byte[] byArray) {
        return null;
    }

    private static class RdnEntry
    implements Comparable {
        private String type;
        private Object value;
        private String comparable = null;

        private RdnEntry() {
        }

        String getType() {
            return null;
        }

        Object getValue() {
            return null;
        }

        public int compareTo(Object object) {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return null;
        }

        private String getValueComparable() {
            return null;
        }

        static /* synthetic */ String access$102(RdnEntry rdnEntry, String string) {
            return null;
        }

        static /* synthetic */ Object access$202(RdnEntry rdnEntry, Object object) {
            return null;
        }
    }
}

