/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.ClassLogger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.BitSet;

public class JMXServiceURL
implements Serializable {
    private static final long serialVersionUID = 8173364409860779292L;
    private static final Exception randomException;
    private static final BitSet alphaBitSet;
    private static final BitSet numericBitSet;
    private static final BitSet alphaNumericBitSet;
    private static final BitSet protocolBitSet;
    private static final BitSet hostNameBitSet;
    private final String protocol;
    private final String host;
    private final int port;
    private final String urlPath;
    private transient String toString;
    private static final ClassLogger logger;

    public JMXServiceURL(String string) throws MalformedURLException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = string.length();
        for (int i = 0; i < n5; ++i) {
            n4 = string.charAt(i);
            if (n4 >= 32 && n4 < 127) continue;
            throw new MalformedURLException("Service URL contains non-ASCII character 0x" + Integer.toHexString(n4));
        }
        n4 = "service:jmx:".length();
        if (!string.regionMatches(true, 0, "service:jmx:", 0, n4)) {
            throw new MalformedURLException("Service URL must start with service:jmx:");
        }
        int[] nArray = new int[1];
        int n6 = n4;
        int n7 = JMXServiceURL.indexOf(string, ':', n6);
        this.protocol = string.substring(n6, n7).toLowerCase();
        if (!string.regionMatches(n7, "://", 0, 3)) {
            throw new MalformedURLException("Missing \"://\" after protocol name");
        }
        int n8 = n7 + 3;
        if (n8 < n5 && string.charAt(n8) == '[') {
            n3 = string.indexOf(93, n8) + 1;
            if (n3 == 0) {
                throw new MalformedURLException("Bad host name: [ without ]");
            }
            this.host = string.substring(n8 + 1, n3 - 1);
            if (!JMXServiceURL.isNumericIPv6Address(this.host)) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
        } else {
            n3 = JMXServiceURL.indexOfFirstNotInSet(string, hostNameBitSet, n8);
            this.host = string.substring(n8, n3);
        }
        if (n3 < n5 && string.charAt(n3) == ':') {
            if (this.host.length() == 0) {
                throw new MalformedURLException("Cannot give port number without host name");
            }
            n2 = n3 + 1;
            n = JMXServiceURL.indexOfFirstNotInSet(string, numericBitSet, n2);
            String string2 = string.substring(n2, n);
            try {
                this.port = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException("Bad port number: \"" + string2 + "\": " + numberFormatException);
            }
        } else {
            n = n3;
            this.port = 0;
        }
        this.urlPath = (n2 = n) < n5 ? string.substring(n2) : "";
        this.validate();
    }

    public JMXServiceURL(String string, String string2, int n) throws MalformedURLException {
        this(string, string2, n, null);
    }

    public JMXServiceURL(String string, String string2, int n, String string3) throws MalformedURLException {
        if (string == null) {
            string = "jmxmp";
        }
        if (string2 == null) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                throw new MalformedURLException("Local host name unknown: " + unknownHostException);
            }
            string2 = inetAddress.getHostName();
            try {
                JMXServiceURL.validateHost(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (logger.fineOn()) {
                    logger.fine("JMXServiceURL", "Replacing illegal local host name " + string2 + " with numeric IP address " + "(see RFC 1034)", malformedURLException);
                }
                string2 = inetAddress.getHostAddress();
            }
        }
        if (string2.startsWith("[")) {
            if (!string2.endsWith("]")) {
                throw new MalformedURLException("Host starts with [ but does not end with ]");
            }
            if (!JMXServiceURL.isNumericIPv6Address(string2 = string2.substring(1, string2.length() - 1))) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
            if (string2.startsWith("[")) {
                throw new MalformedURLException("More than one [[...]]");
            }
        }
        this.protocol = string.toLowerCase();
        this.host = string2;
        this.port = n;
        if (string3 == null) {
            string3 = "";
        }
        this.urlPath = string3;
        this.validate();
    }

    private void validate() throws MalformedURLException {
    }

    private void validateHost() throws MalformedURLException {
    }

    private static void validateHost(String string) throws MalformedURLException {
    }

    public String getProtocol() {
        return null;
    }

    public String getHost() {
        return null;
    }

    public int getPort() {
        return 0;
    }

    public String getURLPath() {
        return null;
    }

    public String toString() {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    private static boolean isNumericIPv6Address(String string) {
        return false;
    }

    private static int indexOf(String string, char c, int n) {
        return 0;
    }

    private static int indexOfFirstNotInSet(String string, BitSet bitSet, int n) {
        return 0;
    }

    private static void addCharsToBitSet(BitSet bitSet, String string) {
    }
}

