/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import javax.management.openmbean.OpenDataException;

public abstract class OpenType
implements Serializable {
    static final long serialVersionUID = -9195195325186646468L;
    static final List<String> ALLOWED_CLASSNAMES_LIST;
    public static final String[] ALLOWED_CLASSNAMES;
    private String className;
    private String description;
    private String typeName;
    private transient boolean isArray = false;

    protected OpenType(String string, String string2, String string3) throws OpenDataException {
        String string4;
        if (string == null || string.trim().equals("")) {
            throw new IllegalArgumentException("Argument className cannot be null or empty.");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new IllegalArgumentException("Argument typeName cannot be null or empty.");
        }
        if (string3 == null || string3.trim().equals("")) {
            throw new IllegalArgumentException("Argument description cannot be null or empty.");
        }
        string = string.trim();
        string2 = string2.trim();
        string3 = string3.trim();
        int n = 0;
        while (string.startsWith("[", n)) {
            ++n;
        }
        boolean bl = false;
        if (n > 0) {
            string4 = string.substring(n + 1, string.length() - 1);
            bl = true;
        } else {
            string4 = string;
        }
        if (!ALLOWED_CLASSNAMES_LIST.contains(string4)) {
            throw new OpenDataException("Argument className=\"" + string + "\" is not one of the allowed Java class names for open data.");
        }
        this.className = string;
        this.typeName = string2;
        this.description = string3;
        this.isArray = bl;
    }

    public String getClassName() {
        return null;
    }

    public String getTypeName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public boolean isArray() {
        return false;
    }

    public abstract boolean isValue(Object var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

