/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public class OpenMBeanAttributeInfoSupport
extends MBeanAttributeInfo
implements OpenMBeanAttributeInfo,
Serializable {
    static final long serialVersionUID = -4867215622149721849L;
    private OpenType openType;
    private Object defaultValue = null;
    private Set legalValues = null;
    private Comparable minValue = null;
    private Comparable maxValue = null;
    private transient Integer myHashCode = null;
    private transient String myToString = null;

    public OpenMBeanAttributeInfoSupport(String string, String string2, OpenType openType, boolean bl, boolean bl2, boolean bl3) {
        super(string, openType == null ? null : openType.getClassName(), string2, bl, bl2, bl3);
        if (string == null || string.trim().equals("")) {
            throw new IllegalArgumentException("Argument name cannot be null or empty.");
        }
        if (openType == null) {
            throw new IllegalArgumentException("Argument openType cannot be null.");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new IllegalArgumentException("Argument description cannot be null or empty.");
        }
        this.openType = openType;
    }

    public OpenMBeanAttributeInfoSupport(String string, String string2, OpenType openType, boolean bl, boolean bl2, boolean bl3, Object object) throws OpenDataException {
        this(string, string2, openType, bl, bl2, bl3);
        if (object != null) {
            if (openType.isArray() || openType instanceof TabularType) {
                throw new OpenDataException("Default value not supported for ArrayType and TabularType.");
            }
            if (!openType.isValue(object)) {
                throw new OpenDataException("Argument defaultValue's class [\"" + object.getClass().getName() + "\"] does not match the one defined in openType[\"" + openType.getClassName() + "\"].");
            }
            this.defaultValue = object;
        }
    }

    public OpenMBeanAttributeInfoSupport(String string, String string2, OpenType openType, boolean bl, boolean bl2, boolean bl3, Object object, Object[] objectArray) throws OpenDataException {
        this(string, string2, openType, bl, bl2, bl3, object);
        if (objectArray != null && objectArray.length > 0) {
            if (openType instanceof TabularType || openType.isArray()) {
                throw new OpenDataException("Legal values not supported for TabularType and arrays");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (openType.isValue(objectArray[i])) continue;
                throw new OpenDataException("Element legalValues[" + i + "]=" + objectArray[i] + " is not a valid value for the specified openType [" + openType.toString() + "].");
            }
            HashSet<Object> hashSet = new HashSet<Object>(objectArray.length + 1, 1.0f);
            for (int i = 0; i < objectArray.length; ++i) {
                hashSet.add(objectArray[i]);
            }
            this.legalValues = Collections.unmodifiableSet(hashSet);
        }
        if (this.hasDefaultValue() && this.hasLegalValues() && !this.legalValues.contains(object)) {
            throw new OpenDataException("defaultValue is not contained in legalValues");
        }
    }

    public OpenMBeanAttributeInfoSupport(String string, String string2, OpenType openType, boolean bl, boolean bl2, boolean bl3, Object object, Comparable comparable, Comparable comparable2) throws OpenDataException {
        this(string, string2, openType, bl, bl2, bl3, object);
        if (comparable != null) {
            if (!openType.isValue(comparable)) {
                throw new OpenDataException("Argument minValue's class [\"" + comparable.getClass().getName() + "\"] does not match openType's definition [\"" + openType.getClassName() + "\"].");
            }
            this.minValue = comparable;
        }
        if (comparable2 != null) {
            if (!openType.isValue(comparable2)) {
                throw new OpenDataException("Argument maxValue's class [\"" + comparable2.getClass().getName() + "\"] does not match openType's definition [\"" + openType.getClassName() + "\"].");
            }
            this.maxValue = comparable2;
        }
        if (this.hasMinValue() && this.hasMaxValue() && comparable.compareTo(comparable2) > 0) {
            throw new OpenDataException("minValue cannot be greater than maxValue.");
        }
        if (this.hasDefaultValue() && this.hasMinValue() && comparable.compareTo((Comparable)object) > 0) {
            throw new OpenDataException("minValue cannot be greater than defaultValue.");
        }
        if (this.hasDefaultValue() && this.hasMaxValue() && ((Comparable)object).compareTo(comparable2) > 0) {
            throw new OpenDataException("defaultValue cannot be greater than maxValue.");
        }
    }

    public OpenType getOpenType() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    public Set getLegalValues() {
        return null;
    }

    public Comparable getMinValue() {
        return null;
    }

    public Comparable getMaxValue() {
        return null;
    }

    public boolean hasDefaultValue() {
        return false;
    }

    public boolean hasLegalValues() {
        return false;
    }

    public boolean hasMinValue() {
        return false;
    }

    public boolean hasMaxValue() {
        return false;
    }

    public boolean isValue(Object object) {
        return false;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return null;
    }
}

