/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeDataSupport
implements CompositeData,
Serializable {
    static final long serialVersionUID = 8003518976613702244L;
    private SortedMap contents = new TreeMap();
    private CompositeType compositeType;

    public CompositeDataSupport(CompositeType compositeType, String[] stringArray, Object[] objectArray) throws OpenDataException {
        int n;
        if (compositeType == null) {
            throw new IllegalArgumentException("Argument compositeType cannot be null.");
        }
        Set set = compositeType.keySet();
        CompositeDataSupport.checkForNullElement(stringArray, "itemNames");
        CompositeDataSupport.checkForEmptyString(stringArray, "itemNames");
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument itemValues[] cannot be null or empty.");
        }
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("Array arguments itemNames[] and itemValues[] should be of same length (got " + stringArray.length + " and " + objectArray.length + ").");
        }
        if (stringArray.length != set.size()) {
            throw new OpenDataException("The size of array arguments itemNames[] and itemValues[] should be equal to the number of items defined in argument compositeType (found " + stringArray.length + " elements in itemNames[] and itemValues[]," + " expecting " + set.size() + " elements according to compositeType.");
        }
        if (!Arrays.asList(stringArray).containsAll(set)) {
            throw new OpenDataException("Argument itemNames[] does not contain all names defined in the compositeType of this instance.");
        }
        for (n = 0; n < objectArray.length; ++n) {
            OpenType openType = compositeType.getType(stringArray[n]);
            if (objectArray[n] == null || openType.isValue(objectArray[n])) continue;
            throw new OpenDataException("Argument's element itemValues[" + n + "]=\"" + objectArray[n] + "\" is not a valid value for" + " this item (itemName=" + stringArray[n] + ",itemType=" + openType + ").");
        }
        this.compositeType = compositeType;
        for (n = 0; n < stringArray.length; ++n) {
            this.contents.put(stringArray[n], objectArray[n]);
        }
    }

    public CompositeDataSupport(CompositeType compositeType, Map map) throws OpenDataException {
        this(compositeType, map == null ? null : map.keySet().toArray(new String[map.size()]), map == null ? null : map.values().toArray());
    }

    private static void checkForNullElement(Object[] objectArray, String string) {
    }

    private static void checkForEmptyString(String[] stringArray, String string) {
    }

    public CompositeType getCompositeType() {
        return null;
    }

    public Object get(String string) {
        return null;
    }

    public Object[] getAll(String[] stringArray) {
        return null;
    }

    public boolean containsKey(String string) {
        return false;
    }

    public boolean containsValue(Object object) {
        return false;
    }

    public Collection values() {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return null;
    }
}

