/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorSupport
implements Descriptor {
    private static final long oldSerialVersionUID = 8071560848919417985L;
    private static final long newSerialVersionUID = -6292969195866300415L;
    private static final ObjectStreamField[] oldSerialPersistentFields;
    private static final ObjectStreamField[] newSerialPersistentFields;
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final String serialForm;
    private transient SortedMap<String, Object> descriptorMap;
    private static final int DEFAULT_SIZE = 20;
    private static final String currClass = "DescriptorSupport";
    private static final String[] entities;
    private static final Map<String, Character> entityToCharMap;
    private static final String[] charToEntityMap;

    public DescriptorSupport() {
        if (this.tracing()) {
            this.trace("DescriptorSupport()", "Constructor");
        }
        this.init(null);
    }

    public DescriptorSupport(int n) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(initNumFields=" + n + ")", "Constructor");
        }
        if (n <= 0) {
            if (this.tracing()) {
                this.trace("Descriptor(maxNumFields)", "Illegal arguments: initNumFields <= 0");
            }
            String string = "Descriptor field limit invalid: " + n;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            throw new RuntimeOperationsException(illegalArgumentException, string);
        }
        this.init(null);
    }

    public DescriptorSupport(DescriptorSupport descriptorSupport) {
        if (this.tracing()) {
            this.trace("Descriptor(Descriptor)", "Constructor");
        }
        if (descriptorSupport == null) {
            this.init(null);
        } else {
            this.init(descriptorSupport.descriptorMap);
        }
    }

    public DescriptorSupport(String string) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (this.tracing()) {
            this.trace("Descriptor(String ='" + string + "')", "Constructor");
        }
        if (string == null) {
            if (this.tracing()) {
                this.trace("Descriptor(String = null)", "Illegal arguments");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("String in parameter is null");
            throw new RuntimeOperationsException(illegalArgumentException, "String in parameter is null");
        }
        String string2 = string.toLowerCase();
        if (!string2.startsWith("<descriptor>") || !string2.endsWith("</descriptor>")) {
            throw new XMLParseException("No <descriptor>, </descriptor> pair");
        }
        this.init(null);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<> \t\n\r\f");
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            String string6 = stringTokenizer.nextToken();
            if (string6.equalsIgnoreCase("FIELD")) {
                bl = true;
                continue;
            }
            if (string6.equalsIgnoreCase("/FIELD")) {
                if (string3 != null && string4 != null) {
                    string3 = string3.substring(string3.indexOf(34) + 1, string3.lastIndexOf(34));
                    Object object = DescriptorSupport.parseQuotedFieldValue(string4);
                    this.setField(string3, object);
                }
                string3 = null;
                string4 = null;
                bl = false;
                continue;
            }
            if (string6.equalsIgnoreCase("DESCRIPTOR")) {
                bl2 = true;
                continue;
            }
            if (string6.equalsIgnoreCase("/DESCRIPTOR")) {
                bl2 = false;
                string3 = null;
                string4 = null;
                bl = false;
                continue;
            }
            if (!bl || !bl2) continue;
            int n = string6.indexOf("=");
            if (n > 0) {
                string5 = string6.substring(0, n);
                String string7 = string6.substring(n + 1);
                if (string5.equalsIgnoreCase("NAME")) {
                    string3 = string7;
                    continue;
                }
                if (string5.equalsIgnoreCase("VALUE")) {
                    string4 = string7;
                    continue;
                }
                String string8 = "Expected `name' or `value', got `" + string6 + "'";
                throw new XMLParseException(string8);
            }
            string5 = "Expected `keyword=value', got `" + string6 + "'";
            throw new XMLParseException(string5);
        }
        if (this.tracing()) {
            this.trace("Descriptor(XMLString)", "Exit");
        }
    }

    public DescriptorSupport(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Constructor");
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            if (this.tracing()) {
                this.trace("Descriptor(String[],Object[])", "Illegal arguments");
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Null or invalid fieldNames or fieldValues");
            throw new RuntimeOperationsException(illegalArgumentException, "Null or invalid fieldNames or fieldValues");
        }
        this.init(null);
        for (int i = 0; i < stringArray.length; ++i) {
            this.setField(stringArray[i], objectArray[i]);
        }
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Exit");
        }
    }

    public DescriptorSupport(String[] stringArray) {
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Constructor");
        }
        this.init(null);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.init(null);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i] == null || stringArray[i].equals("")) continue;
            int n = stringArray[i].indexOf("=");
            if (n < 0) {
                if (this.tracing()) {
                    this.trace("Descriptor(String[])", "Illegal arguments: field does not have '=' as a name and value separator");
                }
                object = new IllegalArgumentException("Field in invalid format: no equals sign");
                throw new RuntimeOperationsException((RuntimeException)object, "Field in invalid format: no equals sign");
            }
            String string = stringArray[i].substring(0, n);
            object = null;
            if (n < stringArray[i].length()) {
                object = stringArray[i].substring(n + 1);
            }
            if (string.equals("")) {
                if (this.tracing()) {
                    this.trace("Descriptor(String[])", "Illegal arguments: fieldName is empty");
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Field in invalid format: no fieldName");
                throw new RuntimeOperationsException(illegalArgumentException, "Field in invalid format: no fieldName");
            }
            this.setField(string, object);
        }
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Exit");
        }
    }

    private void init(Map<String, ?> map) {
    }

    @Override
    public synchronized Object getFieldValue(String string) throws RuntimeOperationsException {
        return null;
    }

    @Override
    public synchronized void setField(String string, Object object) throws RuntimeOperationsException {
    }

    @Override
    public synchronized String[] getFields() {
        return null;
    }

    @Override
    public synchronized String[] getFieldNames() {
        return null;
    }

    @Override
    public synchronized Object[] getFieldValues(String[] stringArray) {
        return null;
    }

    @Override
    public synchronized void setFields(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
    }

    @Override
    public synchronized Object clone() throws RuntimeOperationsException {
        return null;
    }

    @Override
    public synchronized void removeField(String string) {
    }

    @Override
    public synchronized boolean isValid() throws RuntimeOperationsException {
        return false;
    }

    private boolean validateField(String string, Object object) {
        return false;
    }

    public synchronized String toXMLString() {
        return null;
    }

    private static boolean isMagic(char c) {
        return false;
    }

    private static String quote(String string) {
        return null;
    }

    private static String unquote(String string) throws XMLParseException {
        return null;
    }

    private static String makeFieldValue(Object object) {
        return null;
    }

    private static Object parseQuotedFieldValue(String string) throws XMLParseException {
        return null;
    }

    public synchronized String toString() {
        return null;
    }

    private long toNumeric(String string) {
        return 0L;
    }

    private boolean tracing() {
        return false;
    }

    private void trace(String string, String string2, String string3) {
    }

    private void trace(String string, String string2) {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }
}

