/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;

public class ImageTypeSpecifier {
    protected ColorModel colorModel;
    protected SampleModel sampleModel;
    private static ImageTypeSpecifier[] BISpecifier;

    private ImageTypeSpecifier() {
    }

    public ImageTypeSpecifier(ColorModel colorModel, SampleModel sampleModel) {
        if (colorModel == null) {
            throw new IllegalArgumentException("colorModel == null!");
        }
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        if (!colorModel.isCompatibleSampleModel(sampleModel)) {
            throw new IllegalArgumentException("sampleModel is incompatible with colorModel!");
        }
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
    }

    public ImageTypeSpecifier(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        this.colorModel = renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel();
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return null;
    }

    static ColorModel createComponentCM(ColorSpace colorSpace, int n, int n2, boolean bl, boolean bl2) {
        return null;
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
        return null;
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        return null;
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl) {
        return null;
    }

    public static ImageTypeSpecifier createGrayscale(int n, int n2, boolean bl, boolean bl2) {
        return null;
    }

    public static ImageTypeSpecifier createIndexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) {
        return null;
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int n) {
        return null;
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage renderedImage) {
        return null;
    }

    public int getBufferedImageType() {
        return 0;
    }

    public int getNumComponents() {
        return 0;
    }

    public int getNumBands() {
        return 0;
    }

    public int getBitsPerBand(int n) {
        return 0;
    }

    public SampleModel getSampleModel() {
        return null;
    }

    public SampleModel getSampleModel(int n, int n2) {
        return null;
    }

    public ColorModel getColorModel() {
        return null;
    }

    public BufferedImage createBufferedImage(int n, int n2) {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    static class Banded
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bankIndices;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Banded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (nArray == null) {
                throw new IllegalArgumentException("bankIndices == null!");
            }
            if (nArray2 == null) {
                throw new IllegalArgumentException("bandOffsets == null!");
            }
            if (nArray.length != nArray2.length) {
                throw new IllegalArgumentException("bankIndices.length != bandOffsets.length!");
            }
            if (n != 0 && n != 2 && n != 1 && n != 3 && n != 4 && n != 5) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            int n2 = colorSpace.getNumComponents() + (bl ? 1 : 0);
            if (nArray2.length != n2) {
                throw new IllegalArgumentException("bandOffsets.length is wrong!");
            }
            this.colorSpace = colorSpace;
            this.bankIndices = (int[])nArray.clone();
            this.bandOffsets = (int[])nArray2.clone();
            this.dataType = n;
            this.hasAlpha = bl;
            this.isAlphaPremultiplied = bl2;
            this.colorModel = ImageTypeSpecifier.createComponentCM(colorSpace, nArray.length, n, bl, bl2);
            int n3 = 1;
            int n4 = 1;
            this.sampleModel = new BandedSampleModel(n, n3, n4, n3, nArray, nArray2);
        }

        public boolean equals(Object object) {
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }

    static class Grayscale
    extends ImageTypeSpecifier {
        int bits;
        int dataType;
        boolean isSigned;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Grayscale(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
            if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16) {
                throw new IllegalArgumentException("Bad value for bits!");
            }
            if (n2 != 0 && n2 != 2 && n2 != 1) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            if (n > 8 && n2 == 0) {
                throw new IllegalArgumentException("Too many bits for dataType!");
            }
            this.bits = n;
            this.dataType = n2;
            this.isSigned = bl;
            this.hasAlpha = bl2;
            this.isAlphaPremultiplied = bl3;
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            if (n == 8 && n2 == 0 || n == 16 && (n2 == 2 || n2 == 1)) {
                int n3 = bl2 ? 2 : 1;
                int n4 = bl2 ? 3 : 1;
                int[] nArray = new int[n3];
                nArray[0] = n;
                if (n3 == 2) {
                    nArray[1] = n;
                }
                this.colorModel = new ComponentColorModel(colorSpace, nArray, bl2, bl3, n4, n2);
                int[] nArray2 = new int[n3];
                nArray2[0] = 0;
                if (n3 == 2) {
                    nArray2[1] = 1;
                }
                int n5 = 1;
                int n6 = 1;
                this.sampleModel = new PixelInterleavedSampleModel(n2, n5, n6, n3, n5 * n3, nArray2);
            } else {
                int n7 = 1 << n;
                byte[] byArray = new byte[n7];
                for (int i = 0; i < n7; ++i) {
                    byArray[i] = (byte)(i * 255 / (n7 - 1));
                }
                this.colorModel = new IndexColorModel(n, n7, byArray, byArray, byArray);
                this.sampleModel = new MultiPixelPackedSampleModel(n2, 1, 1, n);
            }
        }
    }

    static class Indexed
    extends ImageTypeSpecifier {
        byte[] redLUT;
        byte[] greenLUT;
        byte[] blueLUT;
        byte[] alphaLUT = null;
        int bits;
        int dataType;

        public Indexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) {
            if (byArray == null || byArray2 == null || byArray3 == null) {
                throw new IllegalArgumentException("LUT is null!");
            }
            if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16) {
                throw new IllegalArgumentException("Bad value for bits!");
            }
            if (n2 != 0 && n2 != 2 && n2 != 1 && n2 != 3) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            if (n > 8 && n2 == 0 || n > 16 && n2 != 3) {
                throw new IllegalArgumentException("Too many bits for dataType!");
            }
            int n3 = 1 << n;
            if (byArray.length != n3 || byArray2.length != n3 || byArray3.length != n3 || byArray4 != null && byArray4.length != n3) {
                throw new IllegalArgumentException("LUT has improper length!");
            }
            this.redLUT = (byte[])byArray.clone();
            this.greenLUT = (byte[])byArray2.clone();
            this.blueLUT = (byte[])byArray3.clone();
            if (byArray4 != null) {
                this.alphaLUT = (byte[])byArray4.clone();
            }
            this.bits = n;
            this.dataType = n2;
            this.colorModel = byArray4 == null ? new IndexColorModel(n, byArray.length, byArray, byArray2, byArray3) : new IndexColorModel(n, byArray.length, byArray, byArray2, byArray3, byArray4);
            if (n == 8 && n2 == 0 || n == 16 && (n2 == 2 || n2 == 1)) {
                int[] nArray = new int[]{0};
                this.sampleModel = new PixelInterleavedSampleModel(n2, 1, 1, 1, 1, nArray);
            } else {
                this.sampleModel = new MultiPixelPackedSampleModel(n2, 1, 1, n);
            }
        }
    }

    static class Interleaved
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Interleaved(ColorSpace colorSpace, int[] nArray, int n, boolean bl, boolean bl2) {
            int n2;
            int n3;
            int n4;
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (nArray == null) {
                throw new IllegalArgumentException("bandOffsets == null!");
            }
            int n5 = colorSpace.getNumComponents() + (bl ? 1 : 0);
            if (nArray.length != n5) {
                throw new IllegalArgumentException("bandOffsets.length is wrong!");
            }
            if (n != 0 && n != 2 && n != 1 && n != 3 && n != 4 && n != 5) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            this.colorSpace = colorSpace;
            this.bandOffsets = (int[])nArray.clone();
            this.dataType = n;
            this.hasAlpha = bl;
            this.isAlphaPremultiplied = bl2;
            this.colorModel = ImageTypeSpecifier.createComponentCM(colorSpace, nArray.length, n, bl, bl2);
            int n6 = n4 = nArray[0];
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                n4 = Math.min(n2, n4);
                n6 = Math.max(n2, n6);
            }
            n3 = n6 - n4 + 1;
            n2 = 1;
            int n7 = 1;
            this.sampleModel = new PixelInterleavedSampleModel(n, n2, n7, n3, n2 * n3, nArray);
        }

        public boolean equals(Object object) {
            return false;
        }

        public int hashCode() {
            return 0;
        }
    }

    static class Packed
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int redMask;
        int greenMask;
        int blueMask;
        int alphaMask;
        int transferType;
        boolean isAlphaPremultiplied;

        public Packed(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl) {
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (colorSpace.getType() != 5) {
                throw new IllegalArgumentException("colorSpace is not of type TYPE_RGB!");
            }
            if (n5 != 0 && n5 != 1 && n5 != 3) {
                throw new IllegalArgumentException("Bad value for transferType!");
            }
            if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                throw new IllegalArgumentException("No mask has at least 1 bit set!");
            }
            this.colorSpace = colorSpace;
            this.redMask = n;
            this.greenMask = n2;
            this.blueMask = n3;
            this.alphaMask = n4;
            this.transferType = n5;
            this.isAlphaPremultiplied = bl;
            int n6 = 32;
            this.colorModel = new DirectColorModel(colorSpace, n6, n, n2, n3, n4, bl, n5);
            this.sampleModel = this.colorModel.createCompatibleSampleModel(1, 1);
        }
    }
}

