/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import sun.nio.ByteBuffered;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements ZipConstants {
    private long jzfile;
    private String name;
    private int total;
    private MappedByteBuffer mappedBuffer;
    private ZipCloser closer;
    private boolean mbUsed;
    private boolean closeRequested;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static Constructor directByteBufferConstructor;
    private Vector inflaters = new Vector();

    private static native void initIDs();

    public ZipFile(String string) throws IOException {
        this(new File(string), 1);
    }

    private static void initDBBConstructor() {
    }

    private static MappedByteBuffer newMappedByteBuffer(int n, long l, Runnable runnable) {
        return null;
    }

    public ZipFile(File file, int n) throws IOException {
        if ((n & 1) == 0 || (n & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(n));
        }
        String string = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
            if ((n & 4) != 0) {
                securityManager.checkDelete(string);
            }
        }
        long l = ZipFile.open(string, n, file.lastModified());
        this.name = string;
        this.total = ZipFile.getTotal(l);
        this.mbUsed = false;
        long l2 = ZipFile.getMappedAddr(l);
        long l3 = ZipFile.getMappedLen(l);
        if (l2 != 0L && l3 < Integer.MAX_VALUE) {
            this.closer = new ZipCloser(l);
            this.mappedBuffer = ZipFile.newMappedByteBuffer((int)l3, l2, this.closer);
        }
        this.jzfile = l;
    }

    private static native long open(String var0, int var1, long var2);

    private static native int getTotal(long var0);

    private static native long getMappedAddr(long var0);

    private static native long getMappedLen(long var0);

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipEntry getEntry(String string) {
        return null;
    }

    private static native long getEntry(long var0, String var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return null;
    }

    private InputStream getInputStream(String string) throws IOException {
        return null;
    }

    private static native int getMethod(long var0);

    private Inflater getInflater() {
        return null;
    }

    private void releaseInflater(Inflater inflater) {
    }

    public String getName() {
        return null;
    }

    public Enumeration<? extends ZipEntry> entries() {
        return null;
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        return 0;
    }

    public void close() throws IOException {
    }

    protected void finalize() throws IOException {
    }

    private static native void close(long var0);

    private void ensureOpen() {
    }

    private void ensureOpenOrZipException() throws IOException {
    }

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getCSize(long var0);

    private static native long getSize(long var0);

    private static native long getEntryOffset(long var0);

    private static native String getZipMessage(long var0);

    static /* synthetic */ void access$000(long l) {
    }

    static /* synthetic */ Constructor access$102(Constructor constructor) {
        return null;
    }

    static /* synthetic */ Constructor access$100() {
        return null;
    }

    static /* synthetic */ void access$300(ZipFile zipFile, Inflater inflater) {
    }

    static /* synthetic */ void access$400(ZipFile zipFile) {
    }

    static /* synthetic */ int access$500(ZipFile zipFile) {
        return 0;
    }

    static /* synthetic */ long access$600(ZipFile zipFile) {
        return 0L;
    }

    static /* synthetic */ long access$700(long l, int n) {
        return 0L;
    }

    static /* synthetic */ boolean access$800(ZipFile zipFile) {
        return false;
    }

    static /* synthetic */ String access$900(long l) {
        return null;
    }

    static /* synthetic */ String access$1000(ZipFile zipFile) {
        return null;
    }

    static /* synthetic */ void access$1100(long l, long l2) {
    }

    static /* synthetic */ long access$1200(long l) {
        return 0L;
    }

    static /* synthetic */ long access$1300(long l) {
        return 0L;
    }

    static /* synthetic */ void access$1400(ZipFile zipFile) throws IOException {
    }

    static /* synthetic */ int access$1500(long l, long l2, long l3, byte[] byArray, int n, int n2) {
        return 0;
    }

    static /* synthetic */ long access$1600(long l) {
        return 0L;
    }

    static /* synthetic */ MappedByteBuffer access$1700(ZipFile zipFile) {
        return null;
    }

    static /* synthetic */ boolean access$1802(ZipFile zipFile, boolean bl) {
        return false;
    }

    private class MappedZipFileInputStream
    extends ZipFileInputStream
    implements ByteBuffered {
        private ByteBuffer directBuffer;
        private String name;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MappedZipFileInputStream(long l, String string) {
            MappedByteBuffer mappedByteBuffer;
            super(l);
            this.directBuffer = null;
            this.name = string;
            int n = (int)ZipFile.access$1600(l);
            MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer = ZipFile.access$1700(ZipFile.this);
            synchronized (mappedByteBuffer2) {
                mappedByteBuffer.position(n);
                mappedByteBuffer.limit((int)((long)n + this.rem));
                this.directBuffer = mappedByteBuffer.slice();
                mappedByteBuffer.position(0);
                mappedByteBuffer.limit(mappedByteBuffer.capacity());
            }
        }

        public ByteBuffer getByteBuffer() throws IOException {
            return null;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return 0;
        }

        public int read() throws IOException {
            return 0;
        }

        public long skip(long l) {
            return 0L;
        }

        public int available() {
            return 0;
        }

        public long size() {
            return 0L;
        }

        public void close() {
        }
    }

    private static class ZipCloser
    implements Runnable {
        private long mappedFileID;

        private ZipCloser(long l) {
            this.mappedFileID = l;
        }

        public synchronized void setClosed() {
        }

        public synchronized void run() {
        }
    }

    private class ZipFileInputStream
    extends InputStream {
        protected long jzentry;
        private long pos = 0L;
        protected long rem;
        protected long size;

        ZipFileInputStream(long l) {
            this.rem = ZipFile.access$1200(l);
            this.size = ZipFile.access$1300(l);
            this.jzentry = l;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return 0;
        }

        public int read() throws IOException {
            return 0;
        }

        public long skip(long l) {
            return 0L;
        }

        public int available() {
            return 0;
        }

        public long size() {
            return 0L;
        }

        public void close() {
        }
    }
}

