/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY;
    private static final RuntimePermission shutdownPerm;
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final HashSet<Worker> workers = new HashSet();
    private volatile long keepAliveTime;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler defaultHandler;
    static final /* synthetic */ boolean $assertionsDisabled;

    void reject(Runnable runnable) {
    }

    private Thread addThread(Runnable runnable) {
        return null;
    }

    private boolean addIfUnderCorePoolSize(Runnable runnable) {
        return false;
    }

    private Runnable addIfUnderMaximumPoolSize(Runnable runnable) {
        return null;
    }

    Runnable getTask() throws InterruptedException {
        return null;
    }

    void interruptIdleWorkers() {
    }

    void workerDone(Worker worker) {
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        this(n, n2, l, timeUnit, blockingQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, RejectedExecutionHandler rejectedExecutionHandler) {
        this(n, n2, l, timeUnit, blockingQueue, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public ThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (n < 0 || n2 <= 0 || n2 < n || l < 0L) {
            throw new IllegalArgumentException();
        }
        if (blockingQueue == null || threadFactory == null || rejectedExecutionHandler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = n;
        this.maximumPoolSize = n2;
        this.workQueue = blockingQueue;
        this.keepAliveTime = timeUnit.toNanos(l);
        this.threadFactory = threadFactory;
        this.handler = rejectedExecutionHandler;
    }

    @Override
    public void execute(Runnable runnable) {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return null;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    public boolean isTerminating() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    protected void finalize() {
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
    }

    public ThreadFactory getThreadFactory() {
        return null;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return null;
    }

    public BlockingQueue<Runnable> getQueue() {
        return null;
    }

    public boolean remove(Runnable runnable) {
        return false;
    }

    public void purge() {
    }

    public void setCorePoolSize(int n) {
    }

    public int getCorePoolSize() {
        return 0;
    }

    public boolean prestartCoreThread() {
        return false;
    }

    public int prestartAllCoreThreads() {
        return 0;
    }

    public void setMaximumPoolSize(int n) {
    }

    public int getMaximumPoolSize() {
        return 0;
    }

    public void setKeepAliveTime(long l, TimeUnit timeUnit) {
    }

    public long getKeepAliveTime(TimeUnit timeUnit) {
        return 0L;
    }

    public int getPoolSize() {
        return 0;
    }

    public int getActiveCount() {
        return 0;
    }

    public int getLargestPoolSize() {
        return 0;
    }

    public long getTaskCount() {
        return 0L;
    }

    public long getCompletedTaskCount() {
        return 0L;
    }

    protected void beforeExecute(Thread thread, Runnable runnable) {
    }

    protected void afterExecute(Runnable runnable, Throwable throwable) {
    }

    protected void terminated() {
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }

    private class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        volatile long completedTasks;
        Thread thread;

        Worker(Runnable runnable) {
            this.firstTask = runnable;
        }

        boolean isActive() {
            return false;
        }

        void interruptIfIdle() {
        }

        void interruptNow() {
        }

        private void runTask(Runnable runnable) {
        }

        public void run() {
        }
    }
}

