/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<K> queue = new ReferenceQueue();
    private volatile int modCount;
    private static final Object NULL_KEY;
    private transient Set<Map.Entry<K, V>> entrySet = null;

    public WeakHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.table = new Entry[n2];
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
    }

    public WeakHashMap(int n) {
        this(n, 0.75f);
    }

    public WeakHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    public WeakHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        return null;
    }

    private static <K> K unmaskNull(Object object) {
        return null;
    }

    static boolean eq(Object object, Object object2) {
        return false;
    }

    static int indexFor(int n, int n2) {
        return 0;
    }

    private void expungeStaleEntries() {
    }

    private Entry[] getTable() {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public V get(Object object) {
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return false;
    }

    Entry<K, V> getEntry(Object object) {
        return null;
    }

    @Override
    public V put(K k, V v) {
        return null;
    }

    void resize(int n) {
    }

    private void transfer(Entry[] entryArray, Entry[] entryArray2) {
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
    }

    @Override
    public V remove(Object object) {
        return null;
    }

    Entry<K, V> removeMapping(Object object) {
        return null;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean containsValue(Object object) {
        return false;
    }

    private boolean containsNullValue() {
        return false;
    }

    @Override
    public Set<K> keySet() {
        return null;
    }

    @Override
    public Collection<V> values() {
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    static /* synthetic */ Object access$300(Object object) {
        return null;
    }

    static /* synthetic */ int access$400(WeakHashMap weakHashMap) {
        return 0;
    }

    static /* synthetic */ Entry[] access$500(WeakHashMap weakHashMap) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends WeakReference<K>
    implements Map.Entry<K, V> {
        private V value;
        private final int hash;
        private Entry<K, V> next;

        Entry(K k, V v, ReferenceQueue<K> referenceQueue, int n, Entry<K, V> entry) {
            super(k, referenceQueue);
            this.value = v;
            this.hash = n;
            this.next = entry;
        }

        @Override
        public K getKey() {
            return null;
        }

        @Override
        public V getValue() {
            return null;
        }

        @Override
        public V setValue(V v) {
            return null;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        public String toString() {
            return null;
        }

        static /* synthetic */ int access$000(Entry entry) {
            return 0;
        }

        static /* synthetic */ Entry access$100(Entry entry) {
            return null;
        }

        static /* synthetic */ Entry access$102(Entry entry, Entry entry2) {
            return null;
        }

        static /* synthetic */ Object access$202(Entry entry, Object object) {
            return null;
        }

        static /* synthetic */ Object access$200(Entry entry) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return null;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean remove(Object object) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<T>
    implements Iterator<T> {
        int index;
        Entry<K, V> entry = null;
        Entry<K, V> lastReturned = null;
        int expectedModCount = WeakHashMap.access$400(WeakHashMap.this);
        Object nextKey = null;
        Object currentKey = null;

        HashIterator() {
            this.index = WeakHashMap.this.size() != 0 ? WeakHashMap.access$500(WeakHashMap.this).length : 0;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        protected Entry<K, V> nextEntry() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public boolean remove(Object object) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends HashIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return null;
        }
    }
}

