/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;

public final class Bidi {
    byte dir;
    byte baselevel;
    int length;
    int[] runs;
    int[] cws;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
    private static final int DIR_MIXED = 2;
    private static final char NUMLEVELS = '>';
    private static final int RMASK = 57378;

    public Bidi(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        Bidi.nativeBidiChars(this, string.toCharArray(), 0, null, 0, string.length(), n);
    }

    public Bidi(AttributedCharacterIterator attributedCharacterIterator) {
        int n;
        Serializable serializable;
        if (attributedCharacterIterator == null) {
            throw new IllegalArgumentException("paragraph is null");
        }
        int n2 = -2;
        byte[] byArray = null;
        int n3 = attributedCharacterIterator.getBeginIndex();
        int n4 = attributedCharacterIterator.getEndIndex();
        int n5 = n4 - n3;
        int n6 = 0;
        char[] cArray = new char[n5];
        char c = attributedCharacterIterator.first();
        while (true) {
            if (c == '\uffff') break;
            cArray[n6++] = c;
            c = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        try {
            serializable = (Boolean)attributedCharacterIterator.getAttribute(TextAttribute.RUN_DIRECTION);
            if (serializable != null) {
                n2 = TextAttribute.RUN_DIRECTION_LTR.equals(serializable) ? 0 : 1;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            serializable = (NumericShaper)attributedCharacterIterator.getAttribute(TextAttribute.NUMERIC_SHAPING);
            if (serializable != null) {
                ((NumericShaper)serializable).shape(cArray, 0, cArray.length);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        int n7 = n3;
        do {
            attributedCharacterIterator.setIndex(n7);
            Object object = attributedCharacterIterator.getAttribute(TextAttribute.BIDI_EMBEDDING);
            n = attributedCharacterIterator.getRunLimit(TextAttribute.BIDI_EMBEDDING);
            if (object == null) continue;
            try {
                int n8 = (Integer)object;
                if (n8 < -61 || n8 >= 61) continue;
                byte by = (byte)(n8 < 0 ? -n8 | 0x80 : n8);
                if (byArray == null) {
                    byArray = new byte[n5];
                }
                for (int i = n7 - n3; i < n - n3; ++i) {
                    byArray[i] = by;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        } while ((n7 = n) < n4);
        Bidi.nativeBidiChars(this, cArray, 0, byArray, 0, cArray.length, n2);
    }

    public Bidi(char[] cArray, int n, byte[] byArray, int n2, int n3, int n4) {
        if (cArray == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("bad length: " + n3);
        }
        if (n < 0 || n3 > cArray.length - n) {
            throw new IllegalArgumentException("bad range: " + n + " length: " + n3 + " for text of length: " + cArray.length);
        }
        if (byArray != null && (n2 < 0 || n3 > byArray.length - n2)) {
            throw new IllegalArgumentException("bad range: " + n2 + " length: " + n3 + " for embeddings of length: " + cArray.length);
        }
        if (byArray != null) {
            int n5 = n2 + n3;
            for (int i = n2; i < n5; ++i) {
                if (byArray[i] >= 0) continue;
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                i -= n2;
                while (i < n3) {
                    if (byArray2[i] < 0) {
                        byArray2[i] = (byte)(-byArray2[i] | 0x80);
                    }
                    ++i;
                }
                byArray = byArray2;
                n2 = 0;
                break;
            }
        }
        Bidi.nativeBidiChars(this, cArray, n, byArray, n2, n3, n4);
    }

    private Bidi(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        this.reset(n, n2, n3, nArray, nArray2);
    }

    private void reset(int n, int n2, int n3, int[] nArray, int[] nArray2) {
    }

    public Bidi createLineBidi(int n, int n2) {
        return null;
    }

    public boolean isMixed() {
        return false;
    }

    public boolean isLeftToRight() {
        return false;
    }

    public boolean isRightToLeft() {
        return false;
    }

    public int getLength() {
        return 0;
    }

    public boolean baseIsLeftToRight() {
        return false;
    }

    public int getBaseLevel() {
        return 0;
    }

    public int getLevelAt(int n) {
        return 0;
    }

    public int getRunCount() {
        return 0;
    }

    public int getRunLevel(int n) {
        return 0;
    }

    public int getRunStart(int n) {
        return 0;
    }

    public int getRunLimit(int n) {
        return 0;
    }

    public static boolean requiresBidi(char[] cArray, int n, int n2) {
        return false;
    }

    public static void reorderVisually(byte[] byArray, int n, Object[] objectArray, int n2, int n3) {
    }

    private static native int nativeGetDirectionCode(int var0);

    private static synchronized native void nativeBidiChars(Bidi var0, char[] var1, int var2, byte[] var3, int var4, int var5, int var6);

    public String toString() {
        return null;
    }
}

