/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedString {
    private static final int ARRAY_SIZE_INCREMENT = 10;
    String text;
    int runArraySize;
    int runCount;
    int[] runStarts;
    Vector[] runAttributes;
    Vector[] runAttributeValues;

    AttributedString(AttributedCharacterIterator[] attributedCharacterIteratorArray) {
        if (attributedCharacterIteratorArray == null) {
            throw new NullPointerException("Iterators must not be null");
        }
        if (attributedCharacterIteratorArray.length == 0) {
            this.text = "";
        } else {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < attributedCharacterIteratorArray.length; ++n) {
                this.appendContents(stringBuffer, attributedCharacterIteratorArray[n]);
            }
            this.text = stringBuffer.toString();
            if (this.text.length() > 0) {
                n = 0;
                Map<AttributedCharacterIterator.Attribute, Object> map = null;
                for (int i = 0; i < attributedCharacterIteratorArray.length; ++i) {
                    AttributedCharacterIterator attributedCharacterIterator = attributedCharacterIteratorArray[i];
                    int n2 = attributedCharacterIterator.getBeginIndex();
                    int n3 = attributedCharacterIterator.getEndIndex();
                    int n4 = n2;
                    while (n4 < n3) {
                        attributedCharacterIterator.setIndex(n4);
                        Map<AttributedCharacterIterator.Attribute, Object> map2 = attributedCharacterIterator.getAttributes();
                        if (AttributedString.mapsDiffer(map, map2)) {
                            this.setAttributes(map2, n4 - n2 + n);
                        }
                        map = map2;
                        n4 = attributedCharacterIterator.getRunLimit();
                    }
                    n += n3 - n2;
                }
            }
        }
    }

    public AttributedString(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
    }

    public AttributedString(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        if (string == null || map == null) {
            throw new NullPointerException();
        }
        this.text = string;
        if (string.length() == 0) {
            if (map.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException("Can't add attribute to 0-length text");
        }
        int n = map.size();
        if (n > 0) {
            this.createRunAttributeDataVectors();
            Vector<AttributedCharacterIterator.Attribute> vector = new Vector<AttributedCharacterIterator.Attribute>(n);
            Vector vector2 = new Vector(n);
            this.runAttributes[0] = vector;
            this.runAttributeValues[0] = vector2;
            for (Map.Entry<AttributedCharacterIterator.Attribute, ?> entry : map.entrySet()) {
                vector.addElement(entry.getKey());
                vector2.addElement(entry.getValue());
            }
        }
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator) {
        this(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this(attributedCharacterIterator, n, n2, null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException();
        }
        int n3 = attributedCharacterIterator.getBeginIndex();
        int n4 = attributedCharacterIterator.getEndIndex();
        if (n < n3 || n2 > n4 || n > n2) {
            throw new IllegalArgumentException("Invalid substring range");
        }
        StringBuffer stringBuffer = new StringBuffer();
        attributedCharacterIterator.setIndex(n);
        char c = attributedCharacterIterator.current();
        while (attributedCharacterIterator.getIndex() < n2) {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.text = stringBuffer.toString();
        if (n == n2) {
            return;
        }
        HashSet<AttributedCharacterIterator.Attribute> hashSet = new HashSet<AttributedCharacterIterator.Attribute>();
        if (attributeArray == null) {
            hashSet.addAll(attributedCharacterIterator.getAllAttributeKeys());
        } else {
            for (int i = 0; i < attributeArray.length; ++i) {
                hashSet.add(attributeArray[i]);
            }
            hashSet.retainAll(attributedCharacterIterator.getAllAttributeKeys());
        }
        if (hashSet.isEmpty()) {
            return;
        }
        block2: for (AttributedCharacterIterator.Attribute attribute : hashSet) {
            attributedCharacterIterator.setIndex(n3);
            while (attributedCharacterIterator.getIndex() < n2) {
                int n5 = attributedCharacterIterator.getRunStart(attribute);
                int n6 = attributedCharacterIterator.getRunLimit(attribute);
                Object object = attributedCharacterIterator.getAttribute(attribute);
                if (object != null) {
                    if (object instanceof Annotation) {
                        if (n5 >= n && n6 <= n2) {
                            this.addAttribute(attribute, object, n5 - n, n6 - n);
                        } else if (n6 > n2) {
                            continue block2;
                        }
                    } else {
                        if (n5 >= n2) continue block2;
                        if (n6 > n) {
                            if (n5 < n) {
                                n5 = n;
                            }
                            if (n6 > n2) {
                                n6 = n2;
                            }
                            if (n5 != n6) {
                                this.addAttribute(attribute, object, n5 - n, n6 - n);
                            }
                        }
                    }
                }
                attributedCharacterIterator.setIndex(n6);
            }
        }
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
    }

    public void addAttributes(Map<? extends AttributedCharacterIterator.Attribute, ?> map, int n, int n2) {
    }

    private synchronized void addAttributeImpl(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
    }

    private final void createRunAttributeDataVectors() {
    }

    private final int ensureRunBreak(int n) {
        return 0;
    }

    private final int ensureRunBreak(int n, boolean bl) {
        return 0;
    }

    private void addAttributeRunData(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
    }

    public AttributedCharacterIterator getIterator() {
        return null;
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n, int n2) {
        return null;
    }

    int length() {
        return 0;
    }

    private char charAt(int n) {
        return '\u0000';
    }

    private synchronized Object getAttribute(AttributedCharacterIterator.Attribute attribute, int n) {
        return null;
    }

    private Object getAttributeCheckRange(AttributedCharacterIterator.Attribute attribute, int n, int n2, int n3) {
        return null;
    }

    private boolean attributeValuesMatch(Set set, int n, int n2) {
        return false;
    }

    private static final boolean valuesMatch(Object object, Object object2) {
        return false;
    }

    private final void appendContents(StringBuffer stringBuffer, CharacterIterator characterIterator) {
    }

    private void setAttributes(Map map, int n) {
    }

    private static boolean mapsDiffer(Map map, Map map2) {
        return false;
    }

    static /* synthetic */ char access$000(AttributedString attributedString, int n) {
        return '\u0000';
    }

    static /* synthetic */ Object access$100(AttributedString attributedString, AttributedCharacterIterator.Attribute attribute, int n) {
        return null;
    }

    static /* synthetic */ boolean access$200(Object object, Object object2) {
        return false;
    }

    static /* synthetic */ boolean access$300(AttributedString attributedString, Set set, int n, int n2) {
        return false;
    }

    static /* synthetic */ Object access$400(AttributedString attributedString, AttributedCharacterIterator.Attribute attribute, int n, int n2, int n3) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AttributeMap
    extends AbstractMap<AttributedCharacterIterator.Attribute, Object> {
        int runIndex;
        int beginIndex;
        int endIndex;

        AttributeMap(int n, int n2, int n3) {
            this.runIndex = n;
            this.beginIndex = n2;
            this.endIndex = n3;
        }

        @Override
        public Set entrySet() {
            return null;
        }

        @Override
        public Object get(Object object) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AttributedStringIterator
    implements AttributedCharacterIterator {
        private int beginIndex;
        private int endIndex;
        private AttributedCharacterIterator.Attribute[] relevantAttributes;
        private int currentIndex;
        private int currentRunIndex;
        private int currentRunStart;
        private int currentRunLimit;

        AttributedStringIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n, int n2) {
            if (n < 0 || n > n2 || n2 > AttributedString.this.length()) {
                throw new IllegalArgumentException("Invalid substring range");
            }
            this.beginIndex = n;
            this.endIndex = n2;
            this.currentIndex = n;
            this.updateRunInfo();
            if (attributeArray != null) {
                this.relevantAttributes = (AttributedCharacterIterator.Attribute[])attributeArray.clone();
            }
        }

        public boolean equals(Object object) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public Object clone() {
            return null;
        }

        @Override
        public char first() {
            return '\u0000';
        }

        @Override
        public char last() {
            return '\u0000';
        }

        @Override
        public char current() {
            return '\u0000';
        }

        @Override
        public char next() {
            return '\u0000';
        }

        @Override
        public char previous() {
            return '\u0000';
        }

        @Override
        public char setIndex(int n) {
            return '\u0000';
        }

        @Override
        public int getBeginIndex() {
            return 0;
        }

        @Override
        public int getEndIndex() {
            return 0;
        }

        @Override
        public int getIndex() {
            return 0;
        }

        @Override
        public int getRunStart() {
            return 0;
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            return 0;
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> set) {
            return 0;
        }

        @Override
        public int getRunLimit() {
            return 0;
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            return 0;
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> set) {
            return 0;
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            return null;
        }

        @Override
        public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
            return null;
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            return null;
        }

        private AttributedString getString() {
            return null;
        }

        private char internalSetIndex(int n) {
            return '\u0000';
        }

        private void updateRunInfo() {
        }
    }
}

