/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIXParameters
implements CertPathParameters {
    private Set<TrustAnchor> unmodTrustAnchors;
    private Date date;
    private List<PKIXCertPathChecker> certPathCheckers;
    private String sigProvider;
    private boolean revocationEnabled = true;
    private Set<String> unmodInitialPolicies;
    private boolean explicitPolicyRequired = false;
    private boolean policyMappingInhibited = false;
    private boolean anyPolicyInhibited = false;
    private boolean policyQualifiersRejected = true;
    private List<CertStore> certStores;
    private CertSelector certSelector;

    public PKIXParameters(Set<TrustAnchor> set) throws InvalidAlgorithmParameterException {
        this.setTrustAnchors(set);
        this.unmodInitialPolicies = Collections.emptySet();
        this.certPathCheckers = new ArrayList<PKIXCertPathChecker>();
        this.certStores = new ArrayList<CertStore>();
    }

    public PKIXParameters(KeyStore keyStore) throws KeyStoreException, InvalidAlgorithmParameterException {
        if (keyStore == null) {
            throw new NullPointerException("the keystore parameter must be non-null");
        }
        HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            hashSet.add(new TrustAnchor((X509Certificate)certificate, null));
        }
        this.setTrustAnchors(hashSet);
        this.unmodInitialPolicies = Collections.emptySet();
        this.certPathCheckers = new ArrayList<PKIXCertPathChecker>();
        this.certStores = new ArrayList<CertStore>();
    }

    public Set<TrustAnchor> getTrustAnchors() {
        return null;
    }

    public void setTrustAnchors(Set<TrustAnchor> set) throws InvalidAlgorithmParameterException {
    }

    public Set<String> getInitialPolicies() {
        return null;
    }

    public void setInitialPolicies(Set<String> set) {
    }

    public void setCertStores(List<CertStore> list) {
    }

    public void addCertStore(CertStore certStore) {
    }

    public List<CertStore> getCertStores() {
        return null;
    }

    public void setRevocationEnabled(boolean bl) {
    }

    public boolean isRevocationEnabled() {
        return false;
    }

    public void setExplicitPolicyRequired(boolean bl) {
    }

    public boolean isExplicitPolicyRequired() {
        return false;
    }

    public void setPolicyMappingInhibited(boolean bl) {
    }

    public boolean isPolicyMappingInhibited() {
        return false;
    }

    public void setAnyPolicyInhibited(boolean bl) {
    }

    public boolean isAnyPolicyInhibited() {
        return false;
    }

    public void setPolicyQualifiersRejected(boolean bl) {
    }

    public boolean getPolicyQualifiersRejected() {
        return false;
    }

    public Date getDate() {
        return null;
    }

    public void setDate(Date date) {
    }

    public void setCertPathCheckers(List<PKIXCertPathChecker> list) {
    }

    public List<PKIXCertPathChecker> getCertPathCheckers() {
        return null;
    }

    public void addCertPathChecker(PKIXCertPathChecker pKIXCertPathChecker) {
    }

    public String getSigProvider() {
        return null;
    }

    public void setSigProvider(String string) {
    }

    public CertSelector getTargetCertConstraints() {
        return null;
    }

    public void setTargetCertConstraints(CertSelector certSelector) {
    }

    @Override
    public Object clone() {
        return null;
    }

    public String toString() {
        return null;
    }
}

