/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlContext;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.callback.CallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStore {
    private static final String KEYSTORE_TYPE = "keystore.type";
    private String type;
    private Provider provider;
    private KeyStoreSpi keyStoreSpi;
    private boolean initialized = false;

    protected KeyStore(KeyStoreSpi keyStoreSpi, Provider provider, String string) {
        this.keyStoreSpi = keyStoreSpi;
        this.provider = provider;
        this.type = string;
    }

    public static KeyStore getInstance(String string) throws KeyStoreException {
        return null;
    }

    public static KeyStore getInstance(String string, String string2) throws KeyStoreException, NoSuchProviderException {
        return null;
    }

    public static KeyStore getInstance(String string, Provider provider) throws KeyStoreException {
        return null;
    }

    public static final String getDefaultType() {
        return null;
    }

    public final Provider getProvider() {
        return null;
    }

    public final String getType() {
        return null;
    }

    public final Key getKey(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return null;
    }

    public final Certificate[] getCertificateChain(String string) throws KeyStoreException {
        return null;
    }

    public final Certificate getCertificate(String string) throws KeyStoreException {
        return null;
    }

    public final Date getCreationDate(String string) throws KeyStoreException {
        return null;
    }

    public final void setKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
    }

    public final void setKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
    }

    public final void setCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
    }

    public final void deleteEntry(String string) throws KeyStoreException {
    }

    public final Enumeration<String> aliases() throws KeyStoreException {
        return null;
    }

    public final boolean containsAlias(String string) throws KeyStoreException {
        return false;
    }

    public final int size() throws KeyStoreException {
        return 0;
    }

    public final boolean isKeyEntry(String string) throws KeyStoreException {
        return false;
    }

    public final boolean isCertificateEntry(String string) throws KeyStoreException {
        return false;
    }

    public final String getCertificateAlias(Certificate certificate) throws KeyStoreException {
        return null;
    }

    public final void store(OutputStream outputStream, char[] cArray) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
    }

    public final void store(LoadStoreParameter loadStoreParameter) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
    }

    public final void load(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public final void load(LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    public final Entry getEntry(String string, ProtectionParameter protectionParameter) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        return null;
    }

    public final void setEntry(String string, Entry entry, ProtectionParameter protectionParameter) throws KeyStoreException {
    }

    public final boolean entryInstanceOf(String string, Class<? extends Entry> clazz) throws KeyStoreException {
        return false;
    }

    static /* synthetic */ boolean access$000(KeyStore keyStore) {
        return false;
    }

    public static abstract class Builder {
        protected Builder() {
        }

        public abstract KeyStore getKeyStore() throws KeyStoreException;

        public abstract ProtectionParameter getProtectionParameter(String var1) throws KeyStoreException;

        public static Builder newInstance(KeyStore keyStore, ProtectionParameter protectionParameter) {
            return null;
        }

        public static Builder newInstance(String string, Provider provider, File file, ProtectionParameter protectionParameter) {
            return null;
        }

        public static Builder newInstance(String string, Provider provider, ProtectionParameter protectionParameter) {
            return null;
        }

        private static final class FileBuilder
        extends Builder {
            private final String type;
            private final Provider provider;
            private final File file;
            private ProtectionParameter protection;
            private final AccessControlContext context;
            private KeyStore keyStore;
            private Throwable oldException;

            FileBuilder(String string, Provider provider, File file, ProtectionParameter protectionParameter, AccessControlContext accessControlContext) {
                this.type = string;
                this.provider = provider;
                this.file = file;
                this.protection = protectionParameter;
                this.context = accessControlContext;
            }

            public synchronized KeyStore getKeyStore() throws KeyStoreException {
                return null;
            }

            public synchronized ProtectionParameter getProtectionParameter(String string) {
                return null;
            }

            static /* synthetic */ Provider access$100(FileBuilder fileBuilder) {
                return null;
            }

            static /* synthetic */ String access$200(FileBuilder fileBuilder) {
                return null;
            }

            static /* synthetic */ File access$300(FileBuilder fileBuilder) {
                return null;
            }

            static /* synthetic */ ProtectionParameter access$400(FileBuilder fileBuilder) {
                return null;
            }

            static /* synthetic */ ProtectionParameter access$402(FileBuilder fileBuilder, ProtectionParameter protectionParameter) {
                return null;
            }
        }
    }

    public static class CallbackHandlerProtection
    implements ProtectionParameter {
        private final CallbackHandler handler;

        public CallbackHandlerProtection(CallbackHandler callbackHandler) {
            if (callbackHandler == null) {
                throw new NullPointerException("handler must not be null");
            }
            this.handler = callbackHandler;
        }

        public CallbackHandler getCallbackHandler() {
            return null;
        }
    }

    public static interface Entry {
    }

    public static interface LoadStoreParameter {
        public ProtectionParameter getProtectionParameter();
    }

    public static class PasswordProtection
    implements ProtectionParameter,
    Destroyable {
        private final char[] password;
        private volatile boolean destroyed = false;

        public PasswordProtection(char[] cArray) {
            this.password = cArray == null ? null : (char[])cArray.clone();
        }

        public synchronized char[] getPassword() {
            return null;
        }

        public synchronized void destroy() throws DestroyFailedException {
        }

        public synchronized boolean isDestroyed() {
            return false;
        }
    }

    public static final class PrivateKeyEntry
    implements Entry {
        private final PrivateKey privKey;
        private final Certificate[] chain;

        public PrivateKeyEntry(PrivateKey privateKey, Certificate[] certificateArray) {
            if (privateKey == null || certificateArray == null) {
                throw new NullPointerException("invalid null input");
            }
            if (certificateArray.length == 0) {
                throw new IllegalArgumentException("invalid zero-length input chain");
            }
            Certificate[] certificateArray2 = (Certificate[])certificateArray.clone();
            String string = certificateArray2[0].getType();
            for (int i = 1; i < certificateArray2.length; ++i) {
                if (string.equals(certificateArray2[i].getType())) continue;
                throw new IllegalArgumentException("chain does not contain certificates of the same type");
            }
            if (!privateKey.getAlgorithm().equals(certificateArray2[0].getPublicKey().getAlgorithm())) {
                throw new IllegalArgumentException("private key algorithm does not match algorithm of public key in end entity certificate (at index 0)");
            }
            this.privKey = privateKey;
            if (certificateArray2[0] instanceof X509Certificate && !(certificateArray2 instanceof X509Certificate[])) {
                this.chain = new X509Certificate[certificateArray2.length];
                System.arraycopy(certificateArray2, 0, this.chain, 0, certificateArray2.length);
            } else {
                this.chain = certificateArray2;
            }
        }

        public PrivateKey getPrivateKey() {
            return null;
        }

        public Certificate[] getCertificateChain() {
            return null;
        }

        public Certificate getCertificate() {
            return null;
        }

        public String toString() {
            return null;
        }
    }

    public static interface ProtectionParameter {
    }

    public static final class SecretKeyEntry
    implements Entry {
        private final SecretKey sKey;

        public SecretKeyEntry(SecretKey secretKey) {
            if (secretKey == null) {
                throw new NullPointerException("invalid null input");
            }
            this.sKey = secretKey;
        }

        public SecretKey getSecretKey() {
            return null;
        }

        public String toString() {
            return null;
        }
    }

    static class SimpleLoadStoreParameter
    implements LoadStoreParameter {
        private final ProtectionParameter protection;

        SimpleLoadStoreParameter(ProtectionParameter protectionParameter) {
            this.protection = protectionParameter;
        }

        public ProtectionParameter getProtectionParameter() {
            return null;
        }
    }

    public static final class TrustedCertificateEntry
    implements Entry {
        private final Certificate cert;

        public TrustedCertificateEntry(Certificate certificate) {
            if (certificate == null) {
                throw new NullPointerException("invalid null input");
            }
            this.cert = certificate;
        }

        public Certificate getTrustedCertificate() {
            return null;
        }

        public String toString() {
            return null;
        }
    }
}

