/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.SocksSocketImpl;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;

public class Socket {
    private boolean created = false;
    private boolean bound = false;
    private boolean connected = false;
    private boolean closed = false;
    private Object closeLock = new Object();
    private boolean shutIn = false;
    private boolean shutOut = false;
    SocketImpl impl;
    private boolean oldImpl = false;
    private static SocketImplFactory factory;

    public Socket() {
        this.setImpl();
    }

    public Socket(Proxy proxy) {
        if (proxy != null && proxy.type() == Proxy.Type.SOCKS) {
            SecurityManager securityManager = System.getSecurityManager();
            InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
            if (securityManager != null) {
                if (inetSocketAddress.isUnresolved()) {
                    inetSocketAddress = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                }
                if (inetSocketAddress.isUnresolved()) {
                    securityManager.checkConnect(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                } else {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
            }
            this.impl = new SocksSocketImpl(proxy);
            this.impl.setSocket(this);
        } else if (proxy == Proxy.NO_PROXY) {
            if (factory == null) {
                this.impl = new PlainSocketImpl();
                this.impl.setSocket(this);
            } else {
                this.setImpl();
            }
        } else {
            throw new IllegalArgumentException("Invalid Proxy");
        }
    }

    protected Socket(SocketImpl socketImpl) throws SocketException {
        this.impl = socketImpl;
        if (socketImpl != null) {
            this.checkOldImpl();
            this.impl.setSocket(this);
        }
    }

    public Socket(String string, int n) throws UnknownHostException, IOException {
        this(string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n), new InetSocketAddress(0), true);
    }

    public Socket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n) : null, new InetSocketAddress(0), true);
    }

    public Socket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        this(string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n), new InetSocketAddress(inetAddress, n2), true);
    }

    public Socket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n) : null, new InetSocketAddress(inetAddress2, n2), true);
    }

    @Deprecated
    public Socket(String string, int n, boolean bl) throws IOException {
        this(string != null ? new InetSocketAddress(string, n) : new InetSocketAddress(InetAddress.getByName(null), n), new InetSocketAddress(0), bl);
    }

    @Deprecated
    public Socket(InetAddress inetAddress, int n, boolean bl) throws IOException {
        this(inetAddress != null ? new InetSocketAddress(inetAddress, n) : null, new InetSocketAddress(0), bl);
    }

    private Socket(SocketAddress socketAddress, SocketAddress socketAddress2, boolean bl) throws IOException {
        this.setImpl();
        if (socketAddress == null) {
            throw new NullPointerException();
        }
        try {
            this.createImpl(bl);
            if (socketAddress2 == null) {
                socketAddress2 = new InetSocketAddress(0);
            }
            this.bind(socketAddress2);
            if (socketAddress != null) {
                this.connect(socketAddress);
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    void createImpl(boolean bl) throws SocketException {
    }

    private void checkOldImpl() {
    }

    void setImpl() {
    }

    SocketImpl getImpl() throws SocketException {
        return null;
    }

    public void connect(SocketAddress socketAddress) throws IOException {
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
    }

    public void bind(SocketAddress socketAddress) throws IOException {
    }

    final void postAccept() {
    }

    void setCreated() {
    }

    void setBound() {
    }

    void setConnected() {
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public InetAddress getLocalAddress() {
        return null;
    }

    public int getPort() {
        return 0;
    }

    public int getLocalPort() {
        return 0;
    }

    public SocketAddress getRemoteSocketAddress() {
        return null;
    }

    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    public SocketChannel getChannel() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return 0;
    }

    public void sendUrgentData(int n) throws IOException {
    }

    public void setOOBInline(boolean bl) throws SocketException {
    }

    public boolean getOOBInline() throws SocketException {
        return false;
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
    }

    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    public synchronized void setSendBufferSize(int n) throws SocketException {
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return 0;
    }

    public synchronized void setReceiveBufferSize(int n) throws SocketException {
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return 0;
    }

    public void setKeepAlive(boolean bl) throws SocketException {
    }

    public boolean getKeepAlive() throws SocketException {
        return false;
    }

    public void setTrafficClass(int n) throws SocketException {
    }

    public int getTrafficClass() throws SocketException {
        return 0;
    }

    public void setReuseAddress(boolean bl) throws SocketException {
    }

    public boolean getReuseAddress() throws SocketException {
        return false;
    }

    public synchronized void close() throws IOException {
    }

    public void shutdownInput() throws IOException {
    }

    public void shutdownOutput() throws IOException {
    }

    public String toString() {
        return null;
    }

    public boolean isConnected() {
        return false;
    }

    public boolean isBound() {
        return false;
    }

    public boolean isClosed() {
        return false;
    }

    public boolean isInputShutdown() {
        return false;
    }

    public boolean isOutputShutdown() {
        return false;
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory socketImplFactory) throws IOException {
    }

    public void setPerformancePreferences(int n, int n2, int n3) {
    }
}

