/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class InetSocketAddress
extends SocketAddress {
    private String hostname = null;
    private InetAddress addr = null;
    private int port;
    private static final long serialVersionUID = 5076001401234631237L;

    private InetSocketAddress() {
    }

    public InetSocketAddress(int n) {
        this(InetAddress.anyLocalAddress(), n);
    }

    public InetSocketAddress(InetAddress inetAddress, int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port out of range:" + n);
        }
        this.port = n;
        this.addr = inetAddress == null ? InetAddress.anyLocalAddress() : inetAddress;
    }

    public InetSocketAddress(String string, int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port out of range:" + n);
        }
        if (string == null) {
            throw new IllegalArgumentException("hostname can't be null");
        }
        try {
            this.addr = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            this.hostname = string;
            this.addr = null;
        }
        this.port = n;
    }

    public static InetSocketAddress createUnresolved(String string, int n) {
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public final int getPort() {
        return 0;
    }

    public final InetAddress getAddress() {
        return null;
    }

    public final String getHostName() {
        return null;
    }

    final String getHostString() {
        return null;
    }

    public final boolean isUnresolved() {
        return false;
    }

    public String toString() {
        return null;
    }

    public final boolean equals(Object object) {
        return false;
    }

    public final int hashCode() {
        return 0;
    }
}

