/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.math.MutableBigInteger;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigInteger
extends Number
implements Comparable<BigInteger> {
    int signum;
    int[] mag;
    private int bitCount = -1;
    private int bitLength = -1;
    private int lowestSetBit = -2;
    private int firstNonzeroByteNum = -2;
    private int firstNonzeroIntNum = -2;
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private static long[] bitsPerDigit;
    private static final int SMALL_PRIME_THRESHOLD = 95;
    private static final int DEFAULT_PRIME_CERTAINTY = 100;
    private static final BigInteger SMALL_PRIME_PRODUCT;
    private static final int MAX_CONSTANT = 16;
    private static BigInteger[] posConst;
    private static BigInteger[] negConst;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger TWO;
    public static final BigInteger TEN;
    static int[] bnExpModThreshTable;
    static final byte[] trailingZeroTable;
    private static String[] zeros;
    private static int[] digitsPerLong;
    private static BigInteger[] longRadix;
    private static int[] digitsPerInt;
    private static int[] intRadix;
    private static final long serialVersionUID = -8287574255936472291L;
    private static final ObjectStreamField[] serialPersistentFields;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BigInteger(byte[] byArray) {
        if (byArray.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (byArray[0] < 0) {
            this.mag = BigInteger.makePositive(byArray);
            this.signum = -1;
        } else {
            this.mag = BigInteger.stripLeadingZeroBytes(byArray);
            this.signum = this.mag.length == 0 ? 0 : 1;
        }
    }

    private BigInteger(int[] nArray) {
        if (nArray.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (nArray[0] < 0) {
            this.mag = BigInteger.makePositive(nArray);
            this.signum = -1;
        } else {
            this.mag = BigInteger.trustedStripLeadingZeroInts(nArray);
            this.signum = this.mag.length == 0 ? 0 : 1;
        }
    }

    public BigInteger(int n, byte[] byArray) {
        this.mag = BigInteger.stripLeadingZeroBytes(byArray);
        if (n < -1 || n > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (n == 0) {
                throw new NumberFormatException("signum-magnitude mismatch");
            }
            this.signum = n;
        }
    }

    private BigInteger(int n, int[] nArray) {
        this.mag = BigInteger.stripLeadingZeroInts(nArray);
        if (n < -1 || n > 1) {
            throw new NumberFormatException("Invalid signum value");
        }
        if (this.mag.length == 0) {
            this.signum = 0;
        } else {
            if (n == 0) {
                throw new NumberFormatException("signum-magnitude mismatch");
            }
            this.signum = n;
        }
    }

    public BigInteger(String string, int n) {
        int n2 = 0;
        int n3 = string.length();
        if (n < 2 || n > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        this.signum = 1;
        int n4 = string.lastIndexOf("-");
        if (n4 != -1) {
            if (n4 == 0) {
                if (string.length() == 1) {
                    throw new NumberFormatException("Zero length BigInteger");
                }
                this.signum = -1;
                n2 = 1;
            } else {
                throw new NumberFormatException("Illegal embedded minus sign");
            }
        }
        while (n2 < n3 && Character.digit(string.charAt(n2), n) == 0) {
            ++n2;
        }
        if (n2 == n3) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int n5 = n3 - n2;
        int n6 = (int)(((long)n5 * bitsPerDigit[n] >>> 10) + 1L);
        int n7 = (n6 + 31) / 32;
        this.mag = new int[n7];
        int n8 = n5 % digitsPerInt[n];
        if (n8 == 0) {
            n8 = digitsPerInt[n];
        }
        String string2 = string.substring(n2, n2 += n8);
        this.mag[this.mag.length - 1] = Integer.parseInt(string2, n);
        if (this.mag[this.mag.length - 1] < 0) {
            throw new NumberFormatException("Illegal digit");
        }
        int n9 = intRadix[n];
        int n10 = 0;
        while (n2 < string.length()) {
            if ((n10 = Integer.parseInt(string2 = string.substring(n2, n2 += digitsPerInt[n]), n)) < 0) {
                throw new NumberFormatException("Illegal digit");
            }
            BigInteger.destructiveMulAdd(this.mag, n9, n10);
        }
        this.mag = BigInteger.trustedStripLeadingZeroInts(this.mag);
    }

    BigInteger(char[] cArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = cArray.length;
        this.signum = 1;
        if (cArray[0] == '-') {
            if (n4 == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
            this.signum = -1;
            n3 = 1;
        }
        while (n3 < n4 && Character.digit(cArray[n3], 10) == 0) {
            ++n3;
        }
        if (n3 == n4) {
            this.signum = 0;
            this.mag = BigInteger.ZERO.mag;
            return;
        }
        int n5 = n4 - n3;
        if (n4 < 10) {
            n2 = 1;
        } else {
            n = (int)(((long)n5 * bitsPerDigit[10] >>> 10) + 1L);
            n2 = (n + 31) / 32;
        }
        this.mag = new int[n2];
        n = n5 % digitsPerInt[10];
        if (n == 0) {
            n = digitsPerInt[10];
        }
        this.mag[this.mag.length - 1] = this.parseInt(cArray, n3, n3 += n);
        while (n3 < n4) {
            int n6 = this.parseInt(cArray, n3, n3 += digitsPerInt[10]);
            BigInteger.destructiveMulAdd(this.mag, intRadix[10], n6);
        }
        this.mag = BigInteger.trustedStripLeadingZeroInts(this.mag);
    }

    private int parseInt(char[] cArray, int n, int n2) {
        return 0;
    }

    private static void destructiveMulAdd(int[] nArray, int n, int n2) {
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(int n, Random random) {
        this(1, BigInteger.randomBits(n, random));
    }

    private static byte[] randomBits(int n, Random random) {
        return null;
    }

    public BigInteger(int n, int n2, Random random) {
        if (n < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        BigInteger bigInteger = n < 95 ? BigInteger.smallPrime(n, n2, random) : BigInteger.largePrime(n, n2, random);
        this.signum = 1;
        this.mag = bigInteger.mag;
    }

    public static BigInteger probablePrime(int n, Random random) {
        return null;
    }

    private static BigInteger smallPrime(int n, int n2, Random random) {
        return null;
    }

    private static BigInteger largePrime(int n, int n2, Random random) {
        return null;
    }

    public BigInteger nextProbablePrime() {
        return null;
    }

    boolean primeToCertainty(int n) {
        return false;
    }

    private boolean passesLucasLehmer() {
        return false;
    }

    private static int jacobiSymbol(int n, BigInteger bigInteger) {
        return 0;
    }

    private static BigInteger lucasLehmerSequence(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        return null;
    }

    private boolean passesMillerRabin(int n) {
        return false;
    }

    private BigInteger(int[] nArray, int n) {
        this.signum = nArray.length == 0 ? 0 : n;
        this.mag = nArray;
    }

    private BigInteger(byte[] byArray, int n) {
        this.signum = byArray.length == 0 ? 0 : n;
        this.mag = BigInteger.stripLeadingZeroBytes(byArray);
    }

    BigInteger(MutableBigInteger mutableBigInteger, int n) {
        if (mutableBigInteger.offset > 0 || mutableBigInteger.value.length != mutableBigInteger.intLen) {
            this.mag = new int[mutableBigInteger.intLen];
            for (int i = 0; i < mutableBigInteger.intLen; ++i) {
                this.mag[i] = mutableBigInteger.value[mutableBigInteger.offset + i];
            }
        } else {
            this.mag = mutableBigInteger.value;
        }
        this.signum = mutableBigInteger.intLen == 0 ? 0 : n;
    }

    public static BigInteger valueOf(long l) {
        return null;
    }

    private BigInteger(long l) {
        if (l < 0L) {
            this.signum = -1;
            l = -l;
        } else {
            this.signum = 1;
        }
        int n = (int)(l >>> 32);
        if (n == 0) {
            this.mag = new int[1];
            this.mag[0] = (int)l;
        } else {
            this.mag = new int[2];
            this.mag[0] = n;
            this.mag[1] = (int)l;
        }
    }

    private static BigInteger valueOf(int[] nArray) {
        return null;
    }

    public BigInteger add(BigInteger bigInteger) {
        return null;
    }

    private static int[] add(int[] nArray, int[] nArray2) {
        return null;
    }

    public BigInteger subtract(BigInteger bigInteger) {
        return null;
    }

    private static int[] subtract(int[] nArray, int[] nArray2) {
        return null;
    }

    public BigInteger multiply(BigInteger bigInteger) {
        return null;
    }

    private int[] multiplyToLen(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3) {
        return null;
    }

    private BigInteger square() {
        return null;
    }

    private static final int[] squareToLen(int[] nArray, int n, int[] nArray2) {
        return null;
    }

    public BigInteger divide(BigInteger bigInteger) {
        return null;
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        return null;
    }

    public BigInteger remainder(BigInteger bigInteger) {
        return null;
    }

    public BigInteger pow(int n) {
        return null;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        return null;
    }

    private static int[] leftShift(int[] nArray, int n, int n2) {
        return null;
    }

    static void primitiveRightShift(int[] nArray, int n, int n2) {
    }

    static void primitiveLeftShift(int[] nArray, int n, int n2) {
    }

    private static int bitLength(int[] nArray, int n) {
        return 0;
    }

    public BigInteger abs() {
        return null;
    }

    public BigInteger negate() {
        return null;
    }

    public int signum() {
        return 0;
    }

    public BigInteger mod(BigInteger bigInteger) {
        return null;
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        return null;
    }

    private BigInteger oddModPow(BigInteger bigInteger, BigInteger bigInteger2) {
        return null;
    }

    private static int[] montReduce(int[] nArray, int[] nArray2, int n, int n2) {
        return null;
    }

    private static int intArrayCmpToLen(int[] nArray, int[] nArray2, int n) {
        return 0;
    }

    private static int subN(int[] nArray, int[] nArray2, int n) {
        return 0;
    }

    static int mulAdd(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        return 0;
    }

    static int addOne(int[] nArray, int n, int n2, int n3) {
        return 0;
    }

    private BigInteger modPow2(BigInteger bigInteger, int n) {
        return null;
    }

    private BigInteger mod2(int n) {
        return null;
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        return null;
    }

    public BigInteger shiftLeft(int n) {
        return null;
    }

    public BigInteger shiftRight(int n) {
        return null;
    }

    int[] javaIncrement(int[] nArray) {
        return null;
    }

    public BigInteger and(BigInteger bigInteger) {
        return null;
    }

    public BigInteger or(BigInteger bigInteger) {
        return null;
    }

    public BigInteger xor(BigInteger bigInteger) {
        return null;
    }

    public BigInteger not() {
        return null;
    }

    public BigInteger andNot(BigInteger bigInteger) {
        return null;
    }

    public boolean testBit(int n) {
        return false;
    }

    public BigInteger setBit(int n) {
        return null;
    }

    public BigInteger clearBit(int n) {
        return null;
    }

    public BigInteger flipBit(int n) {
        return null;
    }

    public int getLowestSetBit() {
        return 0;
    }

    public int bitLength() {
        return 0;
    }

    static int bitLen(int n) {
        return 0;
    }

    public int bitCount() {
        return 0;
    }

    static int bitCnt(int n) {
        return 0;
    }

    static int trailingZeroCnt(int n) {
        return 0;
    }

    public boolean isProbablePrime(int n) {
        return false;
    }

    @Override
    public int compareTo(BigInteger bigInteger) {
        return 0;
    }

    private static int intArrayCmp(int[] nArray, int[] nArray2) {
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }

    public BigInteger min(BigInteger bigInteger) {
        return null;
    }

    public BigInteger max(BigInteger bigInteger) {
        return null;
    }

    public int hashCode() {
        return 0;
    }

    public String toString(int n) {
        return null;
    }

    public String toString() {
        return null;
    }

    public byte[] toByteArray() {
        return null;
    }

    @Override
    public int intValue() {
        return 0;
    }

    @Override
    public long longValue() {
        return 0L;
    }

    @Override
    public float floatValue() {
        return 0.0f;
    }

    @Override
    public double doubleValue() {
        return 0.0;
    }

    private static int[] stripLeadingZeroInts(int[] nArray) {
        return null;
    }

    private static int[] trustedStripLeadingZeroInts(int[] nArray) {
        return null;
    }

    private static int[] stripLeadingZeroBytes(byte[] byArray) {
        return null;
    }

    private static int[] makePositive(byte[] byArray) {
        return null;
    }

    private static int[] makePositive(int[] nArray) {
        return null;
    }

    private int intLength() {
        return 0;
    }

    private int signBit() {
        return 0;
    }

    private int signInt() {
        return 0;
    }

    private int getInt(int n) {
        return 0;
    }

    private int firstNonzeroIntNum() {
        return 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private byte[] magSerializedForm() {
        return null;
    }
}

