/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends Number
implements Comparable<BigDecimal> {
    private volatile BigInteger intVal;
    private int scale = 0;
    private volatile transient int precision = 0;
    private volatile transient String stringCache = null;
    private static final long INFLATED = Long.MIN_VALUE;
    private transient long intCompact = Long.MIN_VALUE;
    private static final int MAX_COMPACT_DIGITS = 18;
    private static final int MAX_BIGINT_BITS = 62;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final BigDecimal[] zeroThroughTen;
    public static final BigDecimal ZERO;
    public static final BigDecimal ONE;
    public static final BigDecimal TEN;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static BigInteger LONGMIN;
    private static BigInteger LONGMAX;
    private static BigInteger[] TENPOWERS;
    private static long[][] thresholds;
    private static int[] ilogTable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BigDecimal(char[] cArray, int n, int n2) {
        try {
            char[] cArray2;
            int n3;
            boolean bl = false;
            if (cArray[n] == '-') {
                bl = true;
                ++n;
                --n2;
            } else if (cArray[n] == '+') {
                ++n;
                --n2;
            }
            int n4 = -1;
            int n5 = n;
            long l = 0L;
            if (n2 > cArray.length) {
                throw new NumberFormatException();
            }
            char[] cArray3 = new char[n2];
            while (n2 > 0) {
                char c = cArray[n];
                if (c >= '0' && c <= '9' || Character.isDigit(c)) {
                    cArray3[this.precision] = c;
                    ++this.precision;
                } else if (c == '.') {
                    if (n4 >= 0) {
                        throw new NumberFormatException();
                    }
                    n4 = n;
                } else {
                    if (c != 'e' && c != 'E') {
                        throw new NumberFormatException();
                    }
                    c = cArray[++n];
                    --n2;
                    n3 = 0;
                    if (c == '-' || c == '+') {
                        n3 = c == '-' ? 1 : 0;
                        c = cArray[++n];
                        --n2;
                    }
                    if (n2 <= 0) {
                        throw new NumberFormatException();
                    }
                    while (n2 > 10 && Character.digit(c, 10) == 0) {
                        c = cArray[++n];
                        --n2;
                    }
                    if (n2 > 10) {
                        throw new NumberFormatException();
                    }
                    while (true) {
                        int n6;
                        if (c >= '0' && c <= '9') {
                            n6 = c - 48;
                        } else {
                            n6 = Character.digit(c, 10);
                            if (n6 < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        l = l * 10L + (long)n6;
                        if (n2 == 1) break;
                        c = cArray[++n];
                        --n2;
                    }
                    if (n3 != 0) {
                        l = -l;
                    }
                    if ((long)((int)l) == l) break;
                    throw new NumberFormatException();
                }
                ++n;
                --n2;
            }
            if (this.precision == 0) {
                throw new NumberFormatException();
            }
            if (n4 >= 0) {
                this.scale = this.precision - (n4 - n5);
            }
            if (l != 0L) {
                try {
                    this.scale = this.checkScale(-l + (long)this.scale);
                }
                catch (ArithmeticException arithmeticException) {
                    throw new NumberFormatException("Scale out of range.");
                }
            }
            n3 = 0;
            while ((cArray3[n3] == '0' || Character.digit(cArray3[n3], 10) == 0) && this.precision > 1) {
                --this.precision;
                ++n3;
            }
            if (!bl) {
                cArray2 = new char[this.precision];
                System.arraycopy(cArray3, n3, cArray2, 0, this.precision);
            } else {
                cArray2 = new char[this.precision + 1];
                cArray2[0] = 45;
                System.arraycopy(cArray3, n3, cArray2, 1, this.precision);
            }
            if (this.precision <= 18) {
                this.intCompact = Long.parseLong(new String(cArray2));
            } else {
                this.intVal = new BigInteger(cArray2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NumberFormatException();
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new NumberFormatException();
        }
    }

    public BigDecimal(char[] cArray, int n, int n2, MathContext mathContext) {
        this(cArray, n, n2);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public BigDecimal(char[] cArray, MathContext mathContext) {
        this(cArray, 0, cArray.length, mathContext);
    }

    public BigDecimal(String string) {
        this(string.toCharArray(), 0, string.length());
    }

    public BigDecimal(String string, MathContext mathContext) {
        this(string.toCharArray(), 0, string.length());
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        long l = Double.doubleToLongBits(d);
        int n = l >> 63 == 0L ? 1 : -1;
        int n2 = (int)(l >> 52 & 0x7FFL);
        long l2 = n2 == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        n2 -= 1075;
        if (l2 == 0L) {
            this.intVal = BigInteger.ZERO;
            this.intCompact = 0L;
            this.precision = 1;
            return;
        }
        while ((l2 & 1L) == 0L) {
            l2 >>= 1;
            ++n2;
        }
        this.intVal = BigInteger.valueOf((long)n * l2);
        if (n2 < 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(5L).pow(-n2));
            this.scale = -n2;
        } else if (n2 > 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(2L).pow(n2));
        }
        if (this.intVal.bitLength() <= 62) {
            this.intCompact = this.intVal.longValue();
        }
    }

    public BigDecimal(double d, MathContext mathContext) {
        this(d);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(BigInteger bigInteger) {
        this.intVal = bigInteger;
        if (bigInteger.bitLength() <= 62) {
            this.intCompact = bigInteger.longValue();
        }
    }

    public BigDecimal(BigInteger bigInteger, MathContext mathContext) {
        this.intVal = bigInteger;
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(BigInteger bigInteger, int n) {
        this.intVal = bigInteger;
        this.scale = n;
        if (bigInteger.bitLength() <= 62) {
            this.intCompact = bigInteger.longValue();
        }
    }

    public BigDecimal(BigInteger bigInteger, int n, MathContext mathContext) {
        this.intVal = bigInteger;
        this.scale = n;
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(int n) {
        this.intCompact = n;
    }

    public BigDecimal(int n, MathContext mathContext) {
        this.intCompact = n;
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(long l) {
        if (BigDecimal.compactLong(l)) {
            this.intCompact = l;
        } else {
            this.intVal = BigInteger.valueOf(l);
        }
    }

    public BigDecimal(long l, MathContext mathContext) {
        if (BigDecimal.compactLong(l)) {
            this.intCompact = l;
        } else {
            this.intVal = BigInteger.valueOf(l);
        }
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    private BigDecimal(long l, int n) {
        this.intCompact = l;
        this.scale = n;
    }

    private BigDecimal(BigInteger bigInteger, long l, int n) {
        this.intVal = bigInteger;
        this.intCompact = l;
        this.scale = n;
    }

    public static BigDecimal valueOf(long l, int n) {
        return null;
    }

    public static BigDecimal valueOf(long l) {
        return null;
    }

    public static BigDecimal valueOf(double d) {
        return null;
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        return null;
    }

    public BigDecimal add(BigDecimal bigDecimal, MathContext mathContext) {
        return null;
    }

    private BigDecimal[] preAlign(BigDecimal bigDecimal, BigDecimal bigDecimal2, long l, MathContext mathContext) {
        return null;
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        return null;
    }

    public BigDecimal subtract(BigDecimal bigDecimal, MathContext mathContext) {
        return null;
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        return null;
    }

    public BigDecimal multiply(BigDecimal bigDecimal, MathContext mathContext) {
        return null;
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) {
        return null;
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, RoundingMode roundingMode) {
        return null;
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) {
        return null;
    }

    public BigDecimal divide(BigDecimal bigDecimal, RoundingMode roundingMode) {
        return null;
    }

    public BigDecimal divide(BigDecimal bigDecimal) {
        return null;
    }

    public BigDecimal divide(BigDecimal bigDecimal, MathContext mathContext) {
        return null;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal) {
        return null;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal, MathContext mathContext) {
        return null;
    }

    public BigDecimal remainder(BigDecimal bigDecimal) {
        return null;
    }

    public BigDecimal remainder(BigDecimal bigDecimal, MathContext mathContext) {
        return null;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal) {
        return null;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal, MathContext mathContext) {
        return null;
    }

    public BigDecimal pow(int n) {
        return null;
    }

    public BigDecimal pow(int n, MathContext mathContext) {
        return null;
    }

    public BigDecimal abs() {
        return null;
    }

    public BigDecimal abs(MathContext mathContext) {
        return null;
    }

    public BigDecimal negate() {
        return null;
    }

    public BigDecimal negate(MathContext mathContext) {
        return null;
    }

    public BigDecimal plus() {
        return null;
    }

    public BigDecimal plus(MathContext mathContext) {
        return null;
    }

    public int signum() {
        return 0;
    }

    public int scale() {
        return 0;
    }

    public int precision() {
        return 0;
    }

    public BigInteger unscaledValue() {
        return null;
    }

    public BigDecimal round(MathContext mathContext) {
        return null;
    }

    public BigDecimal setScale(int n, RoundingMode roundingMode) {
        return null;
    }

    public BigDecimal setScale(int n, int n2) {
        return null;
    }

    public BigDecimal setScale(int n) {
        return null;
    }

    public BigDecimal movePointLeft(int n) {
        return null;
    }

    public BigDecimal movePointRight(int n) {
        return null;
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        return null;
    }

    public BigDecimal stripTrailingZeros() {
        return null;
    }

    @Override
    public int compareTo(BigDecimal bigDecimal) {
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        return null;
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        return null;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return null;
    }

    public String toEngineeringString() {
        return null;
    }

    public String toPlainString() {
        return null;
    }

    private String getValueString(int n, String string, int n2) {
        return null;
    }

    public BigInteger toBigInteger() {
        return null;
    }

    public BigInteger toBigIntegerExact() {
        return null;
    }

    @Override
    public long longValue() {
        return 0L;
    }

    public long longValueExact() {
        return 0L;
    }

    @Override
    public int intValue() {
        return 0;
    }

    public int intValueExact() {
        return 0;
    }

    public short shortValueExact() {
        return 0;
    }

    public byte byteValueExact() {
        return 0;
    }

    @Override
    public float floatValue() {
        return 0.0f;
    }

    @Override
    public double doubleValue() {
        return 0.0;
    }

    public BigDecimal ulp() {
        return null;
    }

    private String layoutChars(boolean bl) {
        return null;
    }

    private static BigInteger tenToThe(int n) {
        return null;
    }

    private static long longTenToThe(long l, int n) {
        return 0L;
    }

    private static boolean compactLong(long l) {
        return false;
    }

    private BigDecimal inflate() {
        return null;
    }

    private static void matchScale(BigDecimal[] bigDecimalArray) {
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private int digitLength() {
        return 0;
    }

    private int intLength(int n) {
        return 0;
    }

    private BigDecimal stripZerosToMatchScale(long l) {
        return null;
    }

    private int checkScale(long l) {
        return 0;
    }

    private BigDecimal roundOp(MathContext mathContext) {
        return null;
    }

    private void roundThis(MathContext mathContext) {
    }

    private BigDecimal doRound(MathContext mathContext) {
        return null;
    }

    private BigDecimal dropDigits(MathContext mathContext, int n) {
        return null;
    }

    private static int longCompareTo(long l, long l2) {
        return 0;
    }

    private static void print(String string, BigDecimal bigDecimal) {
    }

    private BigDecimal audit() {
        return null;
    }
}

