/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import javax.management.openmbean.CompositeData;
import sun.management.ManagementFactory;
import sun.management.ThreadInfoCompositeData;

public class ThreadInfo {
    private final String threadName;
    private final long threadId;
    private final long blockedTime;
    private final long blockedCount;
    private final long waitedTime;
    private final long waitedCount;
    private final String lockName;
    private final long lockOwnerId;
    private final String lockOwnerName;
    private final boolean inNative;
    private final boolean suspended;
    private final Thread.State threadState;
    private final StackTraceElement[] stackTrace;
    private static final StackTraceElement[] NO_STACK_TRACE;

    private ThreadInfo(Thread thread, int n, Object object, Thread thread2, long l, long l2, long l3, long l4, StackTraceElement[] stackTraceElementArray) {
        this.threadId = thread.getId();
        this.threadName = thread.getName();
        this.threadState = ManagementFactory.toThreadState((int)n);
        this.suspended = ManagementFactory.isThreadSuspended((int)n);
        this.inNative = ManagementFactory.isThreadRunningNative((int)n);
        this.blockedCount = l;
        this.blockedTime = l2;
        this.waitedCount = l3;
        this.waitedTime = l4;
        this.lockName = object == null ? null : object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
        if (thread2 == null) {
            this.lockOwnerId = -1L;
            this.lockOwnerName = null;
        } else {
            this.lockOwnerId = thread2.getId();
            this.lockOwnerName = thread2.getName();
        }
        this.stackTrace = stackTraceElementArray;
    }

    private ThreadInfo(CompositeData compositeData) {
        ThreadInfoCompositeData.validateCompositeData(compositeData);
        this.threadId = ThreadInfoCompositeData.getThreadId((CompositeData)compositeData);
        this.threadName = ThreadInfoCompositeData.getThreadName((CompositeData)compositeData);
        this.blockedTime = ThreadInfoCompositeData.getBlockedTime((CompositeData)compositeData);
        this.blockedCount = ThreadInfoCompositeData.getBlockedCount((CompositeData)compositeData);
        this.waitedTime = ThreadInfoCompositeData.getWaitedTime((CompositeData)compositeData);
        this.waitedCount = ThreadInfoCompositeData.getWaitedCount((CompositeData)compositeData);
        this.lockName = ThreadInfoCompositeData.getLockName((CompositeData)compositeData);
        this.lockOwnerId = ThreadInfoCompositeData.getLockOwnerId((CompositeData)compositeData);
        this.lockOwnerName = ThreadInfoCompositeData.getLockOwnerName((CompositeData)compositeData);
        this.threadState = ThreadInfoCompositeData.getThreadState((CompositeData)compositeData);
        this.suspended = ThreadInfoCompositeData.isSuspended((CompositeData)compositeData);
        this.inNative = ThreadInfoCompositeData.isInNative((CompositeData)compositeData);
        this.stackTrace = ThreadInfoCompositeData.getStackTrace((CompositeData)compositeData);
    }

    public long getThreadId() {
        return 0L;
    }

    public String getThreadName() {
        return null;
    }

    public Thread.State getThreadState() {
        return null;
    }

    public long getBlockedTime() {
        return 0L;
    }

    public long getBlockedCount() {
        return 0L;
    }

    public long getWaitedTime() {
        return 0L;
    }

    public long getWaitedCount() {
        return 0L;
    }

    public String getLockName() {
        return null;
    }

    public long getLockOwnerId() {
        return 0L;
    }

    public String getLockOwnerName() {
        return null;
    }

    public StackTraceElement[] getStackTrace() {
        return null;
    }

    public boolean isSuspended() {
        return false;
    }

    public boolean isInNative() {
        return false;
    }

    public String toString() {
        return null;
    }

    public static ThreadInfo from(CompositeData compositeData) {
        return null;
    }
}

