/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class RandomAccessFile
implements DataOutput,
DataInput,
Closeable {
    private FileDescriptor fd;
    private FileChannel channel = null;
    private boolean rw;
    private static final int O_RDONLY = 1;
    private static final int O_RDWR = 2;
    private static final int O_SYNC = 4;
    private static final int O_DSYNC = 8;

    public RandomAccessFile(String string, String string2) throws FileNotFoundException {
        this(string != null ? new File(string) : null, string2);
    }

    public RandomAccessFile(File file, String string) throws FileNotFoundException {
        String string2 = file != null ? file.getPath() : null;
        int n = -1;
        if (string.equals("r")) {
            n = 1;
        } else if (string.startsWith("rw")) {
            n = 2;
            this.rw = true;
            if (string.length() > 2) {
                n = string.equals("rws") ? (n |= 4) : (string.equals("rwd") ? (n |= 8) : -1);
            }
        }
        if (n < 0) {
            throw new IllegalArgumentException("Illegal mode \"" + string + "\" must be one of " + "\"r\", \"rw\", \"rws\"," + " or \"rwd\"");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string2);
            if (this.rw) {
                securityManager.checkWrite(string2);
            }
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.open(string2, n);
    }

    public final FileDescriptor getFD() throws IOException {
        return null;
    }

    public final FileChannel getChannel() {
        return null;
    }

    private native void open(String var1, int var2) throws FileNotFoundException;

    public native int read() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return 0;
    }

    public int read(byte[] byArray) throws IOException {
        return 0;
    }

    public final void readFully(byte[] byArray) throws IOException {
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
    }

    public int skipBytes(int n) throws IOException {
        return 0;
    }

    public native void write(int var1) throws IOException;

    private native void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void write(byte[] byArray) throws IOException {
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
    }

    public native long getFilePointer() throws IOException;

    public native void seek(long var1) throws IOException;

    public native long length() throws IOException;

    public native void setLength(long var1) throws IOException;

    public void close() throws IOException {
    }

    public final boolean readBoolean() throws IOException {
        return false;
    }

    public final byte readByte() throws IOException {
        return 0;
    }

    public final int readUnsignedByte() throws IOException {
        return 0;
    }

    public final short readShort() throws IOException {
        return 0;
    }

    public final int readUnsignedShort() throws IOException {
        return 0;
    }

    public final char readChar() throws IOException {
        return '\u0000';
    }

    public final int readInt() throws IOException {
        return 0;
    }

    public final long readLong() throws IOException {
        return 0L;
    }

    public final float readFloat() throws IOException {
        return 0.0f;
    }

    public final double readDouble() throws IOException {
        return 0.0;
    }

    public final String readLine() throws IOException {
        return null;
    }

    public final String readUTF() throws IOException {
        return null;
    }

    public final void writeBoolean(boolean bl) throws IOException {
    }

    public final void writeByte(int n) throws IOException {
    }

    public final void writeShort(int n) throws IOException {
    }

    public final void writeChar(int n) throws IOException {
    }

    public final void writeInt(int n) throws IOException {
    }

    public final void writeLong(long l) throws IOException {
    }

    public final void writeFloat(float f) throws IOException {
    }

    public final void writeDouble(double d) throws IOException {
    }

    public final void writeBytes(String string) throws IOException {
    }

    public final void writeChars(String string) throws IOException {
    }

    public final void writeUTF(String string) throws IOException {
    }

    private static native void initIDs();

    private native void close0() throws IOException;
}

